/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.parser.tree;

import io.ballerina.toml.internal.parser.tree.STIdentifierToken;
import io.ballerina.toml.internal.parser.tree.STInvalidNodeMinutiae;
import io.ballerina.toml.internal.parser.tree.STInvalidToken;
import io.ballerina.toml.internal.parser.tree.STInvalidTokenMinutiaeNode;
import io.ballerina.toml.internal.parser.tree.STLiteralValueToken;
import io.ballerina.toml.internal.parser.tree.STMinutiae;
import io.ballerina.toml.internal.parser.tree.STMissingToken;
import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.toml.internal.parser.tree.STNodeList;
import io.ballerina.toml.internal.parser.tree.STToken;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import java.util.Collection;

public abstract class STAbstractNodeFactory {
    private static final STNodeList EMPTY_LIST = new STNodeList(new STNode[0]);

    public static STToken createIdentifierToken(String text2, STNode leadingTrivia, STNode trailingTrivia) {
        return new STIdentifierToken(text2, leadingTrivia, trailingTrivia);
    }

    public static STToken createIdentifierToken(String text2, STNode leadingTrivia, STNode trailingTrivia, Collection<STNodeDiagnostic> diagnostics) {
        return new STIdentifierToken(text2, leadingTrivia, trailingTrivia, diagnostics);
    }

    public static STNode createNodeList(Collection<STNode> children2) {
        if (children2.isEmpty()) {
            return EMPTY_LIST;
        }
        return new STNodeList(children2);
    }

    public static STNode createNodeList(STNode ... children2) {
        if (children2.length == 0) {
            return EMPTY_LIST;
        }
        return new STNodeList(children2);
    }

    public static STNode createEmptyNodeList() {
        return EMPTY_LIST;
    }

    public static STNode createEmptyNode() {
        return null;
    }

    public static STToken createMissingToken(SyntaxKind kind) {
        return new STMissingToken(kind);
    }

    public static STToken createMissingToken(SyntaxKind kind, Collection<STNodeDiagnostic> diagnostics) {
        return new STMissingToken(kind, diagnostics);
    }

    public static STToken createMissingToken(SyntaxKind kind, STNode leadingTrivia, STNode trailingTrivia, Collection<STNodeDiagnostic> diagnostics) {
        return new STMissingToken(kind, leadingTrivia, trailingTrivia, diagnostics);
    }

    public static STToken createInvalidToken(String tokenText) {
        return new STInvalidToken(tokenText);
    }

    public static STToken createToken(SyntaxKind kind, STNode leadingTrivia, STNode trailingTrivia) {
        return new STToken(kind, leadingTrivia, trailingTrivia);
    }

    public static STToken createToken(SyntaxKind kind, STNode leadingTrivia, STNode trailingTrivia, Collection<STNodeDiagnostic> diagnostics) {
        return new STToken(kind, kind.stringValue().length(), leadingTrivia, trailingTrivia, diagnostics);
    }

    public static STToken createLiteralValueToken(SyntaxKind kind, String text2, STNode leadingTrivia, STNode trailingTrivia) {
        return new STLiteralValueToken(kind, text2, leadingTrivia, trailingTrivia);
    }

    public static STToken createLiteralValueToken(SyntaxKind kind, String text2, STNode leadingTrivia, STNode trailingTrivia, Collection<STNodeDiagnostic> diagnostics) {
        return new STLiteralValueToken(kind, text2, leadingTrivia, trailingTrivia, diagnostics);
    }

    public static STNode createMinutiae(SyntaxKind kind, String text2) {
        return new STMinutiae(kind, text2);
    }

    public static STNode createMinutiae(SyntaxKind kind, String text2, int width) {
        return new STMinutiae(kind, text2, width);
    }

    public static STNode createInvalidNodeMinutiae(STToken invalidToken) {
        return new STInvalidNodeMinutiae(STAbstractNodeFactory.createInvalidTokenMinutiaeNode(invalidToken));
    }

    public static STNode createInvalidNodeMinutiae(STInvalidTokenMinutiaeNode invalidTokenTriviaNode) {
        return new STInvalidNodeMinutiae(invalidTokenTriviaNode);
    }

    public static STInvalidTokenMinutiaeNode createInvalidTokenMinutiaeNode(STToken invalidToken) {
        return new STInvalidTokenMinutiaeNode(invalidToken);
    }
}

