/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.semantic.ast;

import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlKeyEntryNode;
import io.ballerina.toml.semantic.ast.TomlKeyNode;
import io.ballerina.toml.semantic.ast.TomlNodeVisitor;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TomlUnquotedKeyNode;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.toml.syntax.tree.IdentifierLiteralNode;
import io.ballerina.toml.syntax.tree.InlineTableNode;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class TomlInlineTableValueNode
extends TomlValueNode {
    private final List<TopLevelNode> elements;

    public TomlInlineTableValueNode(InlineTableNode table2, List<TopLevelNode> elements2, TomlNodeLocation location) {
        super(table2, TomlType.INLINE_TABLE, location);
        this.elements = elements2;
    }

    public <T extends TopLevelNode> T get(int index) {
        TopLevelNode tomlValue = this.elements.get(index);
        return (T)tomlValue;
    }

    public List<TopLevelNode> elements() {
        return this.elements;
    }

    @Override
    public TomlType kind() {
        return super.kind();
    }

    @Override
    public void accept(TomlNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Set<Diagnostic> diagnostics() {
        Set tomlDiagnostics = this.diagnostics;
        for (TopLevelNode child : this.elements) {
            tomlDiagnostics.addAll(child.diagnostics());
        }
        return tomlDiagnostics;
    }

    @Override
    public void clearDiagnostics() {
        this.diagnostics.clear();
        for (TopLevelNode child : this.elements) {
            child.clearDiagnostics();
        }
    }

    @Override
    public boolean isMissingNode() {
        InlineTableNode inlineNode = (InlineTableNode)this.externalTreeNode();
        if (inlineNode.isMissing()) {
            return true;
        }
        return inlineNode.openBrace().isMissing() || inlineNode.closeBrace().isMissing();
    }

    @Override
    public List<Object> toNativeValue() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (TopLevelNode element : this.elements) {
            list.add(element.toNativeObject());
        }
        return list;
    }

    public TomlTableNode toTable() {
        LinkedHashMap<String, TopLevelNode> table2 = new LinkedHashMap<String, TopLevelNode>();
        for (TopLevelNode node : this.elements) {
            table2.put(node.key().name(), node);
        }
        return new TomlTableNode((InlineTableNode)this.externalTreeNode(), this.generateKey(), false, this.location(), table2);
    }

    private TomlKeyNode generateKey() {
        String tableKey = "__inline_value";
        IdentifierLiteralNode key = NodeFactory.createIdentifierLiteralNode(NodeFactory.createIdentifierToken(tableKey));
        TomlKeyEntryNode root = new TomlKeyEntryNode(key, new TomlUnquotedKeyNode(key, tableKey, this.location()));
        List<TomlKeyEntryNode> tomlKeyEntryNodes = Collections.singletonList(root);
        return new TomlKeyNode(NodeFactory.createKeyNode(NodeFactory.createSeparatedNodeList(key)), tomlKeyEntryNodes, this.location());
    }
}

