/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.syntax.SyntaxUtils;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import java.util.Iterator;

public class ChildNodeList
implements Iterable<Node> {
    private final NonTerminalNode parent;
    private final int size;
    private final Node[] childNodes;

    ChildNodeList(NonTerminalNode parent) {
        this.parent = parent;
        this.size = this.getChildCount(parent.internalNode());
        this.childNodes = new Node[this.size];
    }

    public Node get(int childIndex) {
        this.rangeCheck(childIndex);
        Node child = this.childNodes[childIndex];
        if (child != null) {
            return child;
        }
        return this.loadNode(childIndex);
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<Node> iterator() {
        return new ChildNodeIterator(this.size);
    }

    private int getChildCount(STNode parent) {
        int count2 = 0;
        for (int bucket = 0; bucket < parent.bucketCount(); ++bucket) {
            STNode child = parent.childInBucket(bucket);
            if (!SyntaxUtils.isSTNodePresent(child)) continue;
            if (child.kind == SyntaxKind.LIST) {
                count2 += child.bucketCount();
                continue;
            }
            ++count2;
        }
        return count2;
    }

    private Node loadNode(int childIndex) {
        int index = 0;
        Node child = null;
        for (int bucket = 0; bucket < this.parent.bucketCount(); ++bucket) {
            STNode internalChild = this.parent.internalNode.childInBucket(bucket);
            if (!SyntaxUtils.isSTNodePresent(internalChild)) continue;
            if (internalChild.kind == SyntaxKind.LIST) {
                if (childIndex < index + internalChild.bucketCount()) {
                    int listChildIndex = childIndex - index;
                    NonTerminalNode listChild = (NonTerminalNode)this.parent.childInBucket(bucket);
                    this.childNodes[childIndex] = child = (Node)listChild.childInBucket(listChildIndex);
                    break;
                }
                index += internalChild.bucketCount();
                continue;
            }
            if (index == childIndex) {
                this.childNodes[childIndex] = child = (Node)this.parent.childInBucket(bucket);
                break;
            }
            ++index;
        }
        return child;
    }

    private void rangeCheck(int childIndex) {
        if (childIndex >= this.size || childIndex < 0) {
            throw new IndexOutOfBoundsException("Index: '" + childIndex + "', Size: '" + this.size + "'");
        }
    }

    private class ChildNodeIterator
    implements Iterator<Node> {
        private final int childCount;
        private int currentChildIndex = 0;

        ChildNodeIterator(int childCount) {
            this.childCount = childCount;
        }

        @Override
        public boolean hasNext() {
            return this.currentChildIndex < this.childCount;
        }

        @Override
        public Node next() {
            return ChildNodeList.this.get(this.currentChildIndex++);
        }
    }
}

