/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.syntax.SyntaxUtils;
import io.ballerina.toml.internal.syntax.TreeModifiers;
import io.ballerina.toml.syntax.tree.ChildNodeEntry;
import io.ballerina.toml.syntax.tree.ChildNodeList;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.Minutiae;
import io.ballerina.toml.syntax.tree.MinutiaeList;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;

public abstract class NonTerminalNode
extends Node {
    protected final Node[] childBuckets;
    private ChildNodeList childNodeList;

    public NonTerminalNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
        this.childBuckets = new Node[internalNode.bucketCount()];
    }

    public ChildNodeList children() {
        if (this.childNodeList != null) {
            return this.childNodeList;
        }
        this.childNodeList = new ChildNodeList(this);
        return this.childNodeList;
    }

    public Collection<ChildNodeEntry> childEntries() {
        String[] childNames = this.childNames();
        return Collections.unmodifiableCollection(IntStream.range(0, this.bucketCount()).filter(bucket -> this.childInBucket(bucket) != null).mapToObj(bucket -> new ChildNodeEntry(childNames[bucket], (Node)this.childInBucket(bucket))).toList());
    }

    @Override
    public MinutiaeList leadingMinutiae() {
        return ((Node)this.internalNode.firstToken().createUnlinkedFacade()).leadingMinutiae();
    }

    @Override
    public MinutiaeList trailingMinutiae() {
        return ((Node)this.internalNode.lastToken().createUnlinkedFacade()).trailingMinutiae();
    }

    public Token findToken(int position) {
        NonTerminalNode nonTerminalNode;
        TextRange textRangeWithMinutiae = this.textRangeWithMinutiae();
        if (textRangeWithMinutiae.endOffset() == position && (nonTerminalNode = this) instanceof DocumentNode) {
            DocumentNode modulePartNode = (DocumentNode)nonTerminalNode;
            return modulePartNode.eofToken();
        }
        if (!textRangeWithMinutiae.contains(position)) {
            throw new IndexOutOfBoundsException("Index: '" + position + "', Size: '" + textRangeWithMinutiae.endOffset() + "'");
        }
        Node foundNode = this;
        while (!SyntaxUtils.isToken(foundNode)) {
            foundNode = foundNode.findChildNode(position);
        }
        return (Token)foundNode;
    }

    public Token findToken(int position, boolean insideMinutiae) {
        Token token = this.findToken(position);
        if (!insideMinutiae) {
            return token;
        }
        Optional<Object> tokenInsideMinutiae = Optional.empty();
        if (this.positionWithinLeadingMinutiae(position, token)) {
            tokenInsideMinutiae = this.getInvalidNodeMinutiae(token.leadingMinutiae(), position);
        } else if (this.positionWithinTrailingMinutiae(position, token)) {
            tokenInsideMinutiae = this.getInvalidNodeMinutiae(token.trailingMinutiae(), position);
        }
        return tokenInsideMinutiae.orElse(token);
    }

    public NonTerminalNode findNode(TextRange textRange) {
        TextRange textRangeWithMinutiae = this.textRangeWithMinutiae();
        if (!(this instanceof DocumentNode || textRangeWithMinutiae.contains(textRange.startOffset()) && textRangeWithMinutiae.contains(textRange.endOffset()))) {
            throw new IllegalStateException("Invalid Text Range for: " + textRange.toString());
        }
        NonTerminalNode foundNode = null;
        Optional<Node> temp = Optional.of(this);
        while (temp.isPresent() && SyntaxUtils.isNonTerminalNode(temp.get())) {
            foundNode = temp.get();
            temp = temp.get().findChildNode(textRange);
        }
        return foundNode;
    }

    public <T extends NonTerminalNode> T replace(Node target, Node replacement) {
        return (T)TreeModifiers.replace(this, target, replacement);
    }

    @Override
    public Iterable<Diagnostic> diagnostics() {
        if (!this.internalNode.hasDiagnostics()) {
            return Collections::emptyIterator;
        }
        return () -> this.collectDiagnostics().iterator();
    }

    protected abstract String[] childNames();

    protected int bucketCount() {
        return this.internalNode.bucketCount();
    }

    protected <T extends Node> T childInBucket(int bucket) {
        Node child = this.childBuckets[bucket];
        if (child != null) {
            return (T)child;
        }
        STNode internalChild = this.internalNode.childInBucket(bucket);
        if (SyntaxUtils.isSTNodePresent(internalChild)) {
            this.childBuckets[bucket] = child = internalChild.createFacade(this.getChildPosition(bucket), this);
        }
        return (T)child;
    }

    protected <T extends Node> Optional<T> optionalChildInBucket(int bucket) {
        return Optional.ofNullable(this.childInBucket(bucket));
    }

    protected int getChildPosition(int bucket) {
        int childPos = this.position;
        for (int i = 0; i < bucket; ++i) {
            STNode childNode = this.internalNode.childInBucket(i);
            if (childNode == null) continue;
            childPos += childNode.widthWithMinutiae();
        }
        return childPos;
    }

    protected boolean checkForReferenceEquality(Node ... children2) {
        for (int bucket = 0; bucket < children2.length; ++bucket) {
            if (this.checkForReferenceEquality(bucket, children2[bucket])) continue;
            return false;
        }
        return true;
    }

    protected boolean checkForReferenceEquality(int index, Node child) {
        return this.childBuckets[index] == child;
    }

    private Node findChildNode(int position) {
        int offset = this.textRangeWithMinutiae().startOffset();
        for (int bucket = 0; bucket < this.internalNode.bucketCount(); ++bucket) {
            STNode internalChildNode = this.internalNode.childInBucket(bucket);
            if (!SyntaxUtils.isSTNodePresent(internalChildNode)) continue;
            if (position < offset + internalChildNode.widthWithMinutiae()) {
                return this.childInBucket(bucket);
            }
            offset += internalChildNode.widthWithMinutiae();
        }
        throw new IllegalStateException();
    }

    private Optional<Node> findChildNode(TextRange textRange) {
        int offset = this.textRangeWithMinutiae().startOffset();
        for (int bucket = 0; bucket < this.internalNode.bucketCount(); ++bucket) {
            STNode internalChildNode = this.internalNode.childInBucket(bucket);
            if (!SyntaxUtils.isSTNodePresent(internalChildNode)) continue;
            int offsetWithMinutiae = offset + internalChildNode.widthWithMinutiae();
            if (textRange.startOffset() > offset && textRange.endOffset() <= offsetWithMinutiae) {
                return Optional.ofNullable(this.childInBucket(bucket));
            }
            offset += internalChildNode.widthWithMinutiae();
        }
        return Optional.empty();
    }

    private List<Diagnostic> collectDiagnostics() {
        ArrayList<Diagnostic> diagnosticList = new ArrayList<Diagnostic>();
        this.collectDiagnostics(this, diagnosticList);
        return diagnosticList;
    }

    private void collectDiagnostics(NonTerminalNode node, List<Diagnostic> diagnosticList) {
        for (Node child : node.children()) {
            child.diagnostics().forEach(diagnosticList::add);
        }
        this.internalNode.diagnostics().stream().map(this::createSyntaxDiagnostic).forEach(diagnosticList::add);
    }

    private boolean positionWithinLeadingMinutiae(int position, Token token) {
        return token.containsLeadingMinutiae() && position < token.textRange().startOffset();
    }

    private boolean positionWithinTrailingMinutiae(int position, Token token) {
        return token.containsTrailingMinutiae() && token.textRange().endOffset() <= position;
    }

    private Optional<Token> getInvalidNodeMinutiae(MinutiaeList minutiaeList, int position) {
        for (Minutiae minutiae : minutiaeList) {
            if (!minutiae.textRange().contains(position) || !minutiae.isInvalidNodeMinutiae()) continue;
            return Optional.of(minutiae.invalidTokenMinutiaeNode().get().invalidToken());
        }
        return Optional.empty();
    }
}

