/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.internal.parser.ParserFactory;
import io.ballerina.toml.internal.parser.TomlParser;
import io.ballerina.toml.internal.syntax.SyntaxUtils;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;

public class SyntaxTree {
    private final Node rootNode;
    private final String filePath;
    private TextDocument textDocument;

    SyntaxTree(Node rootNode, TextDocument textDocument, String filePath, boolean clone2) {
        this.rootNode = this.modifyWithMe(rootNode, clone2);
        this.textDocument = textDocument;
        this.filePath = filePath;
    }

    static SyntaxTree from(Node rootNode, boolean clone2) {
        return new SyntaxTree(rootNode, null, null, clone2);
    }

    public static SyntaxTree from(TextDocument textDocument) {
        return SyntaxTree.from(textDocument, null);
    }

    public static SyntaxTree from(TextDocument textDocument, String filePath) {
        TomlParser parser = ParserFactory.getParser(textDocument);
        return new SyntaxTree((Node)parser.parse().createUnlinkedFacade(), textDocument, filePath, false);
    }

    public TextDocument textDocument() {
        if (this.textDocument != null) {
            return this.textDocument;
        }
        this.textDocument = TextDocuments.from(this.rootNode.toSourceCode());
        return this.textDocument;
    }

    public boolean containsModulePart() {
        return this.rootNode.kind() == SyntaxKind.MODULE_PART;
    }

    public <T extends Node> T rootNode() {
        return (T)this.rootNode;
    }

    public String filePath() {
        return this.filePath;
    }

    public SyntaxTree modifyWith(Node rootNode) {
        return new SyntaxTree(rootNode, null, this.filePath, true);
    }

    public SyntaxTree replaceNode(Node target, Node replacement) {
        Node newRootNode = SyntaxUtils.isToken(target) ? replacement : ((NonTerminalNode)this.rootNode).replace(target, replacement);
        return this.modifyWith(newRootNode);
    }

    public Iterable<Diagnostic> diagnostics() {
        return this.rootNode.diagnostics();
    }

    public boolean hasDiagnostics() {
        return this.rootNode.hasDiagnostics();
    }

    public String toString() {
        return this.rootNode.toString();
    }

    public String toSourceCode() {
        return this.rootNode.toSourceCode();
    }

    private <T extends Node> T modifyWithMe(T node, boolean clone2) {
        T clonedNode = clone2 ? node.internalNode().createUnlinkedFacade() : node;
        clonedNode.setSyntaxTree(this);
        return clonedNode;
    }
}

