/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.validator;

import io.ballerina.toml.semantic.ast.TomlArrayValueNode;
import io.ballerina.toml.semantic.ast.TomlBooleanValueNode;
import io.ballerina.toml.semantic.ast.TomlDoubleValueNodeNode;
import io.ballerina.toml.semantic.ast.TomlInlineTableValueNode;
import io.ballerina.toml.semantic.ast.TomlKeyValueNode;
import io.ballerina.toml.semantic.ast.TomlLongValueNode;
import io.ballerina.toml.semantic.ast.TomlNode;
import io.ballerina.toml.semantic.ast.TomlNodeVisitor;
import io.ballerina.toml.semantic.ast.TomlStringValueNode;
import io.ballerina.toml.semantic.ast.TomlTableArrayNode;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.validator.ValidationUtil;
import io.ballerina.toml.validator.schema.AbstractSchema;
import io.ballerina.toml.validator.schema.ArraySchema;
import io.ballerina.toml.validator.schema.BooleanSchema;
import io.ballerina.toml.validator.schema.CompositionSchema;
import io.ballerina.toml.validator.schema.Schema;
import io.ballerina.toml.validator.schema.StringSchema;
import io.ballerina.toml.validator.schema.Type;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SchemaValidator
extends TomlNodeVisitor {
    private AbstractSchema schema;
    private String key;

    public SchemaValidator(Schema schema) {
        this.schema = schema;
    }

    @Override
    public void visit(TomlTableNode tomlTableNode) {
        if (this.schema.type() != Type.OBJECT) {
            if (!tomlTableNode.isMissingNode()) {
                TomlDiagnostic diagnostic = ValidationUtil.getTomlDiagnostic(tomlTableNode.location(), "TVE0002", "error.invalid.type", DiagnosticSeverity.ERROR, SchemaValidator.getTypeErrorMessage(this.schema, Type.OBJECT, this.key));
                tomlTableNode.addDiagnostic(diagnostic);
            }
            return;
        }
        Schema objectSchema = (Schema)this.schema;
        tomlTableNode.addDiagnostics(objectSchema.validate(tomlTableNode, this.key));
        Map<String, AbstractSchema> properties = objectSchema.properties();
        Map<String, TopLevelNode> tableEntries = tomlTableNode.entries();
        for (Map.Entry<String, TopLevelNode> tableEntry : tableEntries.entrySet()) {
            String key = tableEntry.getKey();
            TopLevelNode value2 = tableEntry.getValue();
            AbstractSchema schema = properties.get(key);
            if (schema == null) continue;
            this.visitNode(value2, schema, key);
        }
    }

    @Override
    public void visit(TomlTableArrayNode tomlTableArrayNode) {
        if (this.schema.type() != Type.ARRAY) {
            if (!tomlTableArrayNode.isMissingNode()) {
                TomlDiagnostic diagnostic = ValidationUtil.getTomlDiagnostic(tomlTableArrayNode.location(), "TVE0002", "error.invalid.type", DiagnosticSeverity.ERROR, SchemaValidator.getTypeErrorMessage(this.schema, Type.ARRAY, this.key));
                tomlTableArrayNode.addDiagnostic(diagnostic);
            }
            return;
        }
        ArraySchema arraySchema = (ArraySchema)this.schema;
        AbstractSchema memberSchema = arraySchema.items();
        List<TomlTableNode> children2 = tomlTableArrayNode.children();
        for (TomlTableNode child : children2) {
            this.visitNode(child, memberSchema);
        }
    }

    @Override
    public void visit(TomlKeyValueNode keyValue) {
        TomlValueNode value2 = keyValue.value();
        if (this.isCompositeType()) {
            CompositionSchema schema = (CompositionSchema)this.schema;
            value2.addDiagnostics(schema.validate(value2, this.key));
            return;
        }
        this.visitNode(value2);
    }

    private boolean isCompositeType() {
        return this.schema.type() == Type.ANY_OF || this.schema.type() == Type.ALL_OF || this.schema.type() == Type.ONE_OF || this.schema.type() == Type.NOT;
    }

    @Override
    public void visit(TomlValueNode tomlValue) {
        this.visitNode(tomlValue);
    }

    public static String getTypeErrorMessage(AbstractSchema schema, Type found, String key) {
        Map<String, String> message2 = schema.message();
        String typeCustomMessage = message2.get("type");
        if (typeCustomMessage == null) {
            return String.format("incompatible type for key '%s': expected '%s', found '%s'", new Object[]{key, schema.type(), found});
        }
        return typeCustomMessage;
    }

    @Override
    public void visit(TomlStringValueNode tomlStringValueNode) {
        List<Diagnostic> diagnosticForString = this.getDiagnosticForString(tomlStringValueNode);
        tomlStringValueNode.addDiagnostics(diagnosticForString);
    }

    private List<Diagnostic> getDiagnosticForString(TomlStringValueNode tomlStringValueNode) {
        if (this.schema.type() != Type.STRING) {
            if (!tomlStringValueNode.isMissingNode()) {
                TomlDiagnostic diagnostic = ValidationUtil.getTomlDiagnostic(tomlStringValueNode.location(), "TVE0002", "error.invalid.type", DiagnosticSeverity.ERROR, SchemaValidator.getTypeErrorMessage(this.schema, Type.STRING, this.key));
                return Collections.singletonList(diagnostic);
            }
            return Collections.emptyList();
        }
        StringSchema stringSchema = (StringSchema)this.schema;
        return stringSchema.validate(tomlStringValueNode, this.key);
    }

    @Override
    public void visit(TomlDoubleValueNodeNode tomlDoubleValueNodeNode) {
        if (this.schema.type() != Type.NUMBER) {
            if (!tomlDoubleValueNodeNode.isMissingNode()) {
                TomlDiagnostic diagnostic = ValidationUtil.getTomlDiagnostic(tomlDoubleValueNodeNode.location(), "TVE0002", "error.invalid.type", DiagnosticSeverity.ERROR, SchemaValidator.getTypeErrorMessage(this.schema, Type.NUMBER, this.key));
                tomlDoubleValueNodeNode.addDiagnostic(diagnostic);
            }
            return;
        }
        tomlDoubleValueNodeNode.addDiagnostics(this.schema.validate(tomlDoubleValueNodeNode, this.key));
    }

    @Override
    public void visit(TomlLongValueNode tomlLongValueNode) {
        if (this.schema.type() != Type.INTEGER) {
            if (!tomlLongValueNode.isMissingNode()) {
                TomlDiagnostic diagnostic = ValidationUtil.getTomlDiagnostic(tomlLongValueNode.location(), "TVE0002", "error.invalid.type", DiagnosticSeverity.ERROR, SchemaValidator.getTypeErrorMessage(this.schema, Type.INTEGER, this.key));
                tomlLongValueNode.addDiagnostic(diagnostic);
            }
            return;
        }
        tomlLongValueNode.addDiagnostics(this.schema.validate(tomlLongValueNode, this.key));
    }

    @Override
    public void visit(TomlArrayValueNode tomlArrayValueNode) {
        if (this.schema.type() != Type.ARRAY) {
            if (!tomlArrayValueNode.isMissingNode()) {
                TomlDiagnostic diagnostic = ValidationUtil.getTomlDiagnostic(tomlArrayValueNode.location(), "TVE0002", "error.invalid.type", DiagnosticSeverity.ERROR, SchemaValidator.getTypeErrorMessage(this.schema, Type.ARRAY, this.key));
                tomlArrayValueNode.addDiagnostic(diagnostic);
            }
            return;
        }
        ArraySchema arraySchema = (ArraySchema)this.schema;
        tomlArrayValueNode.addDiagnostics(arraySchema.validate(tomlArrayValueNode, this.key));
        AbstractSchema items = arraySchema.items();
        for (TomlValueNode valueNode : tomlArrayValueNode.elements()) {
            this.visitNode(valueNode, items);
        }
    }

    @Override
    public void visit(TomlBooleanValueNode tomlBooleanValueNode) {
        if (this.schema.type() != Type.BOOLEAN) {
            if (!tomlBooleanValueNode.isMissingNode()) {
                TomlDiagnostic diagnostic = ValidationUtil.getTomlDiagnostic(tomlBooleanValueNode.location(), "TVE0002", "error.invalid.type", DiagnosticSeverity.ERROR, SchemaValidator.getTypeErrorMessage(this.schema, Type.BOOLEAN, this.key));
                tomlBooleanValueNode.addDiagnostic(diagnostic);
            }
            return;
        }
        BooleanSchema schema = (BooleanSchema)this.schema;
        tomlBooleanValueNode.addDiagnostics(schema.validate(tomlBooleanValueNode, this.key));
    }

    @Override
    public void visit(TomlInlineTableValueNode tomlInlineTableValueNode) {
        if (this.schema.type() != Type.OBJECT) {
            if (!tomlInlineTableValueNode.isMissingNode()) {
                TomlDiagnostic diagnostic = ValidationUtil.getTomlDiagnostic(tomlInlineTableValueNode.location(), "TVE0002", "error.invalid.type", DiagnosticSeverity.ERROR, SchemaValidator.getTypeErrorMessage(this.schema, Type.OBJECT, this.key));
                tomlInlineTableValueNode.addDiagnostic(diagnostic);
            }
            return;
        }
        Schema schema = (Schema)this.schema;
        tomlInlineTableValueNode.addDiagnostics(schema.validate(tomlInlineTableValueNode, this.key));
        Map<String, AbstractSchema> properties = schema.properties();
        for (TopLevelNode topLevelNode : tomlInlineTableValueNode.elements()) {
            String key = topLevelNode.key().name();
            AbstractSchema abstractSchema = properties.get(key);
            if (abstractSchema == null) continue;
            this.visitNode(topLevelNode, abstractSchema, key);
        }
    }

    private void visitNode(TomlNode node) {
        AbstractSchema previousSchema = this.schema;
        String previousKey = this.key;
        node.accept(this);
        this.schema = previousSchema;
        this.key = previousKey;
    }

    private void visitNode(TomlNode node, AbstractSchema schema) {
        AbstractSchema previousSchema = this.schema;
        this.schema = schema;
        node.accept(this);
        this.schema = previousSchema;
    }

    private void visitNode(TomlNode node, AbstractSchema schema, String key) {
        AbstractSchema previousSchema = this.schema;
        String previousKey = this.key;
        this.schema = schema;
        this.key = key;
        node.accept(this);
        this.schema = previousSchema;
        this.key = previousKey;
    }
}

