/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.validator.schema;

import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlNode;
import io.ballerina.toml.semantic.ast.TomlStringValueNode;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.validator.ValidationUtil;
import io.ballerina.toml.validator.schema.CompositionSchema;
import io.ballerina.toml.validator.schema.PrimitiveValueSchema;
import io.ballerina.toml.validator.schema.SchemaVisitor;
import io.ballerina.toml.validator.schema.Type;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public class StringSchema
extends PrimitiveValueSchema<String> {
    private final String pattern;
    private final Integer minLength;
    private final Integer maxLength;

    public StringSchema(Type type, Map<String, String> message2, String pattern, String defaultValue, Integer minLength, Integer maxLength, CompositionSchema compositionSchemas, String description) {
        super(type, message2, defaultValue, compositionSchemas, description);
        this.pattern = pattern;
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    public Optional<String> pattern() {
        return Optional.ofNullable(this.pattern);
    }

    public Optional<Integer> minLength() {
        return Optional.ofNullable(this.minLength);
    }

    public Optional<Integer> maxLength() {
        return Optional.ofNullable(this.maxLength);
    }

    @Override
    public void accept(SchemaVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T extends TomlNode> List<Diagnostic> validate(T givenValueNode, String key) {
        TomlDiagnostic diagnostic;
        String value2;
        String pattern;
        if (givenValueNode.kind() != TomlType.STRING) {
            if (!givenValueNode.isMissingNode()) {
                TomlDiagnostic diagnostic2 = ValidationUtil.getTomlDiagnostic(givenValueNode.location(), "TVE0002", "error.invalid.type", DiagnosticSeverity.ERROR, ValidationUtil.getTypeErrorMessage(this, givenValueNode.kind(), key));
                return Collections.singletonList(diagnostic2);
            }
            return Collections.emptyList();
        }
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        TomlStringValueNode stringValueNode = (TomlStringValueNode)givenValueNode;
        if (this.pattern().isPresent() && !Pattern.compile(pattern = this.pattern().get()).matcher((CharSequence)stringValueNode.getValue()).matches()) {
            TomlDiagnostic diagnostic3 = ValidationUtil.getTomlDiagnostic(givenValueNode.location(), "TVE0003", "error.regex.mismatch", DiagnosticSeverity.ERROR, this.getPatternErrorMessage(pattern, key));
            diagnostics.add(diagnostic3);
        }
        if (this.maxLength().isPresent()) {
            int maxLength = this.maxLength().get();
            value2 = (String)stringValueNode.getValue();
            if (value2.length() > maxLength) {
                diagnostic = ValidationUtil.getTomlDiagnostic(stringValueNode.location(), "TVE0007", "error.maxlen.exceeded", DiagnosticSeverity.ERROR, this.getMaxLengthErrorMessage(maxLength, key));
                diagnostics.add(diagnostic);
            }
        }
        if (this.minLength().isPresent()) {
            int minLength = this.minLength().get();
            value2 = (String)stringValueNode.getValue();
            if (value2.length() < minLength) {
                diagnostic = ValidationUtil.getTomlDiagnostic(stringValueNode.location(), "TVE0008", "error.minlen.deceed", DiagnosticSeverity.ERROR, this.getMinLengthErrorMessage(minLength, key));
                diagnostics.add(diagnostic);
            }
        }
        diagnostics.addAll(super.validate(givenValueNode, key));
        return diagnostics;
    }

    private String getPatternErrorMessage(String pattern, String key) {
        Map<String, String> message2 = this.message();
        String typeCustomMessage = message2.get("pattern");
        if (typeCustomMessage == null) {
            return String.format("value for key '%s' expected to match the regex: %s", key, pattern);
        }
        return typeCustomMessage;
    }

    private String getMaxLengthErrorMessage(int maxLength, String key) {
        Map<String, String> message2 = this.message();
        String typeCustomMessage = message2.get("maxLength");
        if (typeCustomMessage == null) {
            return String.format("length of the value for key '%s' is greater than defined max length %s", key, maxLength);
        }
        return typeCustomMessage;
    }

    private String getMinLengthErrorMessage(int maxLength, String key) {
        Map<String, String> message2 = this.message();
        String typeCustomMessage = message2.get("minLength");
        if (typeCustomMessage == null) {
            return String.format("length of the value for key '%s' is lower than defined min length %s", key, maxLength);
        }
        return typeCustomMessage;
    }
}

