/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.tools.diagnostics;

import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.text.MessageFormat;
import java.util.List;

class DefaultDiagnostic
extends Diagnostic {
    private final DiagnosticInfo diagnosticInfo;
    private final Location location;
    private final List<DiagnosticProperty<?>> properties;
    private final String message;

    DefaultDiagnostic(DiagnosticInfo diagnosticInfo, Location location, List<DiagnosticProperty<?>> properties, Object[] args2) {
        this.diagnosticInfo = diagnosticInfo;
        this.location = location;
        this.properties = properties;
        this.message = MessageFormat.format(diagnosticInfo.messageFormat(), args2);
    }

    @Override
    public Location location() {
        return this.location;
    }

    @Override
    public DiagnosticInfo diagnosticInfo() {
        return this.diagnosticInfo;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public List<DiagnosticProperty<?>> properties() {
        return this.properties;
    }

    @Override
    public String toString() {
        LineRange lineRange = this.location.lineRange();
        String filePath = lineRange.fileName();
        LineRange oneBasedLineRange = LineRange.from(filePath, LinePosition.from(lineRange.startLine().line() + 1, lineRange.startLine().offset() + 1), LinePosition.from(lineRange.endLine().line() + 1, lineRange.endLine().offset() + 1));
        return this.diagnosticInfo().severity().toString() + " [" + filePath + ":" + String.valueOf(oneBasedLineRange) + "] " + this.message();
    }
}

