/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.tools.text;

import io.ballerina.tools.text.TextDocument;
import java.util.Arrays;

public class CharReader {
    private final char[] charBuffer;
    private int offset = 0;
    private final int charBufferLength;
    private int lexemeStartPos;

    private CharReader(char[] buffer) {
        this.charBuffer = buffer;
        this.charBufferLength = buffer.length;
    }

    public static CharReader from(TextDocument textDocument) {
        return new CharReader(textDocument.toCharArray());
    }

    public static CharReader from(String text2) {
        return new CharReader(text2.toCharArray());
    }

    public void reset(int offset) {
        this.offset = offset;
    }

    public char peek() {
        if (this.offset < this.charBufferLength) {
            return this.charBuffer[this.offset];
        }
        return '\uffff';
    }

    public char peek(int k) {
        int n = this.offset + k;
        if (n < this.charBufferLength) {
            return this.charBuffer[n];
        }
        return '\uffff';
    }

    public void advance() {
        ++this.offset;
    }

    public void advance(int k) {
        this.offset += k;
    }

    public void mark() {
        this.lexemeStartPos = this.offset;
    }

    public String getMarkedChars() {
        return new String(Arrays.copyOfRange(this.charBuffer, this.lexemeStartPos, this.offset));
    }

    public boolean isEOF() {
        return this.offset >= this.charBufferLength;
    }
}

