/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types;

import io.ballerina.types.BasicSubtype;
import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.CellSemType;
import io.ballerina.types.ComplexSemTypeImpl;
import io.ballerina.types.ProperSubtypeData;
import io.ballerina.types.SemType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public interface ComplexSemType
extends SemType {
    public static ComplexSemType createComplexSemType(int allBitset, BasicSubtype ... subtypeList) {
        return ComplexSemType.createComplexSemType(allBitset, Arrays.asList(subtypeList));
    }

    public static ComplexSemType createComplexSemType(int allBitset, int someBitset, ProperSubtypeData[] subtypeData) {
        if (allBitset == 0 && someBitset == 1 << BasicTypeCode.BT_CELL.code) {
            return CellSemType.from(subtypeData);
        }
        return new ComplexSemTypeImpl(allBitset, someBitset, subtypeData);
    }

    public static ComplexSemType createComplexSemType(int allBitset, List<BasicSubtype> subtypeList) {
        int some2 = 0;
        ArrayList<ProperSubtypeData> dataList = new ArrayList<ProperSubtypeData>();
        for (BasicSubtype basicSubtype : subtypeList) {
            dataList.add(basicSubtype.subtypeData);
            int c = basicSubtype.basicTypeCode.code;
            some2 |= 1 << c;
        }
        return ComplexSemType.createComplexSemType(allBitset, some2, (ProperSubtypeData[])dataList.toArray(ProperSubtypeData[]::new));
    }

    @Override
    public int all();

    public int some();

    public ProperSubtypeData[] subtypeDataList();
}

