/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types;

import io.ballerina.types.Atom;
import io.ballerina.types.BasicSubtype;
import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.Bdd;
import io.ballerina.types.CellAtomicType;
import io.ballerina.types.CellSemType;
import io.ballerina.types.CombinedRange;
import io.ballerina.types.Common;
import io.ballerina.types.ComplexSemType;
import io.ballerina.types.Context;
import io.ballerina.types.EnumerableDecimal;
import io.ballerina.types.EnumerableFloat;
import io.ballerina.types.Env;
import io.ballerina.types.ListAtomicType;
import io.ballerina.types.ListMemberTypes;
import io.ballerina.types.MappingAtomicType;
import io.ballerina.types.OpsTable;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.ProperSubtypeData;
import io.ballerina.types.SemType;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.TypeAtom;
import io.ballerina.types.Value;
import io.ballerina.types.definition.Field;
import io.ballerina.types.definition.ListDefinition;
import io.ballerina.types.definition.MappingDefinition;
import io.ballerina.types.definition.ObjectDefinition;
import io.ballerina.types.definition.ObjectQualifiers;
import io.ballerina.types.subtypedata.AllOrNothingSubtype;
import io.ballerina.types.subtypedata.BddAllOrNothing;
import io.ballerina.types.subtypedata.BddNode;
import io.ballerina.types.subtypedata.BddNodeImpl;
import io.ballerina.types.subtypedata.BddNodeSimple;
import io.ballerina.types.subtypedata.BooleanSubtype;
import io.ballerina.types.subtypedata.CellSubtype;
import io.ballerina.types.subtypedata.DecimalSubtype;
import io.ballerina.types.subtypedata.FloatSubtype;
import io.ballerina.types.subtypedata.IntSubtype;
import io.ballerina.types.subtypedata.Range;
import io.ballerina.types.subtypedata.StringSubtype;
import io.ballerina.types.subtypedata.TableSubtype;
import io.ballerina.types.typeops.CellOps;
import io.ballerina.types.typeops.ListOps;
import io.ballerina.types.typeops.MappingOps;
import io.ballerina.types.typeops.SubtypePair;
import io.ballerina.types.typeops.SubtypePairs;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class Core {
    static final ListMemberTypes LIST_MEMBER_TYPES_ALL = ListMemberTypes.from(List.of(Range.from(0L, Long.MAX_VALUE)), List.of(PredefinedType.VAL));
    static final ListMemberTypes LIST_MEMBER_TYPES_NONE = ListMemberTypes.from(List.of(), List.of());

    public static CellAtomicType cellAtomType(Atom atom) {
        return (CellAtomicType)((TypeAtom)atom).atomicType();
    }

    public static SemType diff(SemType t110, SemType t22) {
        int some1;
        int all1;
        int some2;
        int all2;
        if (t110 instanceof BasicTypeBitSet) {
            BasicTypeBitSet b1 = (BasicTypeBitSet)t110;
            if (t22 instanceof BasicTypeBitSet) {
                BasicTypeBitSet b2 = (BasicTypeBitSet)t22;
                return BasicTypeBitSet.from(b1.bitset & ~b2.bitset);
            }
            if (b1.bitset == 0) {
                return t110;
            }
            ComplexSemType c2 = (ComplexSemType)t22;
            all2 = c2.all();
            some2 = c2.some();
            all1 = b1.bitset;
            some1 = 0;
        } else {
            ComplexSemType c1 = (ComplexSemType)t110;
            all1 = c1.all();
            some1 = c1.some();
            if (t22 instanceof BasicTypeBitSet) {
                BasicTypeBitSet b2 = (BasicTypeBitSet)t22;
                if (b2.bitset == BasicTypeCode.VT_MASK) {
                    return BasicTypeBitSet.from(0);
                }
                all2 = b2.bitset;
                some2 = 0;
            } else {
                ComplexSemType c2 = (ComplexSemType)t22;
                all2 = c2.all();
                some2 = c2.some();
            }
        }
        BasicTypeBitSet all = BasicTypeBitSet.from(all1 & ~(all2 | some2));
        int someBitset = (all1 | some1) & ~all2;
        BasicTypeBitSet some3 = BasicTypeBitSet.from(someBitset &= ~all.bitset);
        if (some3.bitset == 0) {
            return PredefinedType.basicTypeUnion(all.bitset);
        }
        ArrayList<BasicSubtype> subtypes = new ArrayList<BasicSubtype>();
        for (SubtypePair pair : new SubtypePairs(t110, t22, some3)) {
            BasicTypeCode code = pair.basicTypeCode;
            ProperSubtypeData data1 = pair.subtypeData1;
            ProperSubtypeData data2 = pair.subtypeData2;
            SubtypeData data3 = data1 == null ? OpsTable.OPS[code.code].complement(data2) : (data2 == null ? data1 : OpsTable.OPS[code.code].diff(data1, data2));
            if (!(data3 instanceof AllOrNothingSubtype)) {
                subtypes.add(BasicSubtype.from(code, data3));
                continue;
            }
            AllOrNothingSubtype allOrNothingSubtype = (AllOrNothingSubtype)data3;
            if (!allOrNothingSubtype.isAllSubtype()) continue;
            int c = code.code;
            all = BasicTypeBitSet.from(all.bitset | 1 << c);
        }
        if (subtypes.isEmpty()) {
            return all;
        }
        return ComplexSemType.createComplexSemType(all.bitset, subtypes);
    }

    public static List<BasicSubtype> unpackComplexSemType(ComplexSemType t) {
        int some2 = t.some();
        ArrayList<BasicSubtype> subtypeList = new ArrayList<BasicSubtype>();
        for (ProperSubtypeData data2 : t.subtypeDataList()) {
            BasicTypeCode code = BasicTypeCode.from(Integer.numberOfTrailingZeros(some2));
            subtypeList.add(BasicSubtype.from(code, data2));
            int c = code.code;
            some2 ^= 1 << c;
        }
        return subtypeList;
    }

    public static SubtypeData getComplexSubtypeData(ComplexSemType t, BasicTypeCode code) {
        int c = code.code;
        c = 1 << c;
        if ((t.all() & c) != 0) {
            return AllOrNothingSubtype.createAll();
        }
        if ((t.some() & c) == 0) {
            return AllOrNothingSubtype.createNothing();
        }
        int loBits = t.some() & c - 1;
        return t.subtypeDataList()[loBits == 0 ? 0 : Integer.bitCount(loBits)];
    }

    public static SemType union(SemType t110, SemType t22) {
        int some1;
        int all1;
        int some2;
        int all2;
        assert (t110 != null && t22 != null);
        if (t110 instanceof BasicTypeBitSet) {
            BasicTypeBitSet b1 = (BasicTypeBitSet)t110;
            if (t22 instanceof BasicTypeBitSet) {
                BasicTypeBitSet b2 = (BasicTypeBitSet)t22;
                return BasicTypeBitSet.from(b1.bitset | b2.bitset);
            }
            ComplexSemType complexT2 = (ComplexSemType)t22;
            all2 = complexT2.all();
            some2 = complexT2.some();
            all1 = b1.bitset;
            some1 = 0;
        } else {
            ComplexSemType complexT1 = (ComplexSemType)t110;
            all1 = complexT1.all();
            some1 = complexT1.some();
            if (t22 instanceof BasicTypeBitSet) {
                BasicTypeBitSet b2 = (BasicTypeBitSet)t22;
                all2 = b2.bitset;
                some2 = 0;
            } else {
                ComplexSemType complexT2 = (ComplexSemType)t22;
                all2 = complexT2.all();
                some2 = complexT2.some();
            }
        }
        BasicTypeBitSet all = BasicTypeBitSet.from(all1 | all2);
        BasicTypeBitSet some3 = BasicTypeBitSet.from((some1 | some2) & ~all.bitset);
        if (some3.bitset == 0) {
            return PredefinedType.basicTypeUnion(all.bitset);
        }
        ArrayList<BasicSubtype> subtypes = new ArrayList<BasicSubtype>();
        for (SubtypePair pair : new SubtypePairs(t110, t22, some3)) {
            AllOrNothingSubtype allOrNothingSubtype;
            BasicTypeCode code = pair.basicTypeCode;
            ProperSubtypeData data1 = pair.subtypeData1;
            ProperSubtypeData data2 = pair.subtypeData2;
            SubtypeData data3 = data1 == null ? data2 : (data2 == null ? data1 : OpsTable.OPS[code.code].union(data1, data2));
            if (data3 instanceof AllOrNothingSubtype && (allOrNothingSubtype = (AllOrNothingSubtype)data3).isAllSubtype()) {
                int c = code.code;
                all = BasicTypeBitSet.from(all.bitset | 1 << c);
                continue;
            }
            subtypes.add(BasicSubtype.from(code, data3));
        }
        if (subtypes.isEmpty()) {
            return all;
        }
        return ComplexSemType.createComplexSemType(all.bitset, subtypes);
    }

    public static SemType intersect(SemType t110, SemType t22) {
        int some1;
        int all1;
        int some2;
        int all2;
        if (t110 instanceof BasicTypeBitSet) {
            BasicTypeBitSet b1 = (BasicTypeBitSet)t110;
            if (t22 instanceof BasicTypeBitSet) {
                BasicTypeBitSet b2 = (BasicTypeBitSet)t22;
                return BasicTypeBitSet.from(b1.bitset & b2.bitset);
            }
            if (b1.bitset == 0) {
                return t110;
            }
            if (b1.bitset == BasicTypeCode.VT_MASK) {
                return t22;
            }
            ComplexSemType complexT2 = (ComplexSemType)t22;
            all2 = complexT2.all();
            some2 = complexT2.some();
            all1 = b1.bitset;
            some1 = 0;
        } else {
            ComplexSemType complexT1 = (ComplexSemType)t110;
            all1 = complexT1.all();
            some1 = complexT1.some();
            if (t22 instanceof BasicTypeBitSet) {
                BasicTypeBitSet b2 = (BasicTypeBitSet)t22;
                if (b2.bitset == 0) {
                    return t22;
                }
                if (b2.bitset == BasicTypeCode.VT_MASK) {
                    return t110;
                }
                all2 = b2.bitset;
                some2 = 0;
            } else {
                ComplexSemType complexT2 = (ComplexSemType)t22;
                all2 = complexT2.all();
                some2 = complexT2.some();
            }
        }
        BasicTypeBitSet all = BasicTypeBitSet.from(all1 & all2);
        BasicTypeBitSet some3 = BasicTypeBitSet.from((some1 | all1) & (some2 | all2));
        some3 = BasicTypeBitSet.from(some3.bitset & ~all.bitset);
        if (some3.bitset == 0) {
            return PredefinedType.basicTypeUnion(all.bitset);
        }
        ArrayList<BasicSubtype> subtypes = new ArrayList<BasicSubtype>();
        for (SubtypePair pair : new SubtypePairs(t110, t22, some3)) {
            AllOrNothingSubtype allOrNothingSubtype;
            BasicTypeCode code = pair.basicTypeCode;
            ProperSubtypeData data1 = pair.subtypeData1;
            ProperSubtypeData data2 = pair.subtypeData2;
            SubtypeData data3 = data1 == null ? data2 : (data2 == null ? data1 : OpsTable.OPS[code.code].intersect(data1, data2));
            if (data3 instanceof AllOrNothingSubtype && !(allOrNothingSubtype = (AllOrNothingSubtype)data3).isAllSubtype()) continue;
            subtypes.add(BasicSubtype.from(code, data3));
        }
        if (subtypes.isEmpty()) {
            return all;
        }
        return ComplexSemType.createComplexSemType(all.bitset, subtypes);
    }

    public static CellSemType intersectMemberSemTypes(Env env, CellSemType t110, CellSemType t22) {
        CellAtomicType c1 = Core.cellAtomicType(t110);
        CellAtomicType c2 = Core.cellAtomicType(t22);
        assert (c1 != null && c2 != null);
        CellAtomicType atomicType = CellOps.intersectCellAtomicType(c1, c2);
        return CellSubtype.cellContaining(env, atomicType.ty(), PredefinedType.UNDEF.equals(atomicType.ty()) ? CellAtomicType.CellMutability.CELL_MUT_NONE : atomicType.mut());
    }

    public static SemType complement(SemType t) {
        return Core.diff(PredefinedType.VAL, t);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNever(SemType t) {
        if (!(t instanceof BasicTypeBitSet)) return false;
        BasicTypeBitSet b = (BasicTypeBitSet)t;
        if (b.bitset != 0) return false;
        return true;
    }

    public static boolean isEmpty(Context cx, SemType t) {
        assert (t != null && cx != null);
        if (t instanceof BasicTypeBitSet) {
            BasicTypeBitSet b = (BasicTypeBitSet)t;
            return b.bitset == 0;
        }
        ComplexSemType ct = (ComplexSemType)t;
        if (ct.all() != 0) {
            return false;
        }
        for (BasicSubtype st : Core.unpackComplexSemType(ct)) {
            if (OpsTable.OPS[st.basicTypeCode.code].isEmpty(cx, st.subtypeData)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubtype(Context cx, SemType t110, SemType t22) {
        return Core.isEmpty(cx, Core.diff(t110, t22));
    }

    public static boolean isSubtypeSimple(SemType t110, BasicTypeBitSet t22) {
        int bits;
        if (t110 instanceof BasicTypeBitSet) {
            BasicTypeBitSet b1 = (BasicTypeBitSet)t110;
            bits = b1.bitset;
        } else {
            ComplexSemType complexT1 = (ComplexSemType)t110;
            bits = complexT1.all() | complexT1.some();
        }
        return (bits & ~t22.bitset) == 0;
    }

    public static boolean isSameType(Context context, SemType t110, SemType t22) {
        return Core.isSubtype(context, t110, t22) && Core.isSubtype(context, t22, t110);
    }

    public static BasicTypeBitSet widenToBasicTypes(SemType t) {
        if (t instanceof BasicTypeBitSet) {
            BasicTypeBitSet b = (BasicTypeBitSet)t;
            return b;
        }
        ComplexSemType complexSemType = (ComplexSemType)t;
        return BasicTypeBitSet.from(complexSemType.all() | complexSemType.some());
    }

    public static SemType wideUnsigned(SemType t) {
        if (t instanceof BasicTypeBitSet) {
            return t;
        }
        if (!Core.isSubtypeSimple(t, PredefinedType.INT)) {
            return t;
        }
        SubtypeData data2 = IntSubtype.intSubtypeWidenUnsigned(Core.subtypeData(t, BasicTypeCode.BT_INT));
        if (data2 instanceof AllOrNothingSubtype) {
            return PredefinedType.INT;
        }
        return PredefinedType.basicSubtype(BasicTypeCode.BT_INT, (ProperSubtypeData)data2);
    }

    public static SubtypeData booleanSubtype(SemType t) {
        return Core.subtypeData(t, BasicTypeCode.BT_BOOLEAN);
    }

    public static SubtypeData intSubtype(SemType t) {
        return Core.subtypeData(t, BasicTypeCode.BT_INT);
    }

    public static SubtypeData floatSubtype(SemType t) {
        return Core.subtypeData(t, BasicTypeCode.BT_FLOAT);
    }

    public static SubtypeData decimalSubtype(SemType t) {
        return Core.subtypeData(t, BasicTypeCode.BT_DECIMAL);
    }

    public static SubtypeData stringSubtype(SemType t) {
        return Core.subtypeData(t, BasicTypeCode.BT_STRING);
    }

    public static SemType listMemberTypeInnerVal(Context cx, SemType t, SemType k) {
        if (t instanceof BasicTypeBitSet) {
            BasicTypeBitSet b = (BasicTypeBitSet)t;
            return (b.bitset & PredefinedType.LIST.bitset) != 0 ? PredefinedType.VAL : PredefinedType.NEVER;
        }
        SubtypeData keyData = Core.intSubtype(k);
        if (Common.isNothingSubtype(keyData)) {
            return PredefinedType.NEVER;
        }
        return ListOps.bddListMemberTypeInnerVal(cx, (Bdd)Core.getComplexSubtypeData((ComplexSemType)t, BasicTypeCode.BT_LIST), keyData, PredefinedType.VAL);
    }

    public static ListMemberTypes listAllMemberTypesInner(Context cx, SemType t) {
        Range[] allRanges;
        if (t instanceof BasicTypeBitSet) {
            BasicTypeBitSet b = (BasicTypeBitSet)t;
            return (b.bitset & PredefinedType.LIST.bitset) != 0 ? LIST_MEMBER_TYPES_ALL : LIST_MEMBER_TYPES_NONE;
        }
        ComplexSemType ct = (ComplexSemType)t;
        ArrayList<Range> ranges = new ArrayList<Range>();
        ArrayList<SemType> types2 = new ArrayList<SemType>();
        for (Range r2 : allRanges = Core.bddListAllRanges(cx, (Bdd)Core.getComplexSubtypeData(ct, BasicTypeCode.BT_LIST), new Range[0])) {
            SemType m = Core.listMemberTypeInnerVal(cx, t, IntSubtype.intConst(r2.min));
            if (PredefinedType.NEVER.equals(m)) continue;
            ranges.add(r2);
            types2.add(m);
        }
        return ListMemberTypes.from(ranges, types2);
    }

    static Range[] bddListAllRanges(Context cx, Bdd b, Range[] accum) {
        if (b instanceof BddAllOrNothing) {
            BddAllOrNothing allOrNothing = (BddAllOrNothing)b;
            return allOrNothing.isAll() ? accum : new Range[]{};
        }
        BddNode bddNode = (BddNode)b;
        ListMemberTypes listMemberTypes = Core.listAtomicTypeAllMemberTypesInnerVal(cx.listAtomType(bddNode.atom()));
        return Core.distinctRanges(Core.bddListAllRanges(cx, bddNode.left(), Core.distinctRanges((Range[])listMemberTypes.ranges().toArray(Range[]::new), accum)), Core.distinctRanges(Core.bddListAllRanges(cx, bddNode.middle(), accum), Core.bddListAllRanges(cx, bddNode.right(), accum)));
    }

    static Range[] distinctRanges(Range[] range1, Range[] range2) {
        CombinedRange[] combined = Core.combineRanges(range1, range2);
        Range[] range3 = new Range[combined.length];
        for (int i = 0; i < combined.length; ++i) {
            range3[i] = combined[i].range();
        }
        return range3;
    }

    public static CombinedRange[] combineRanges(Range[] ranges1, Range[] ranges2) {
        ArrayList<CombinedRange> combined = new ArrayList<CombinedRange>();
        int i1 = 0;
        int i2 = 0;
        int len1 = ranges1.length;
        int len2 = ranges2.length;
        long cur = Long.MIN_VALUE;
        while (true) {
            if (i1 < len1 && cur > ranges1[i1].max) {
                ++i1;
                continue;
            }
            while (i2 < len2 && cur > ranges2[i2].max) {
                ++i2;
            }
            Long next2 = null;
            if (i1 < len1) {
                next2 = Core.nextBoundary(cur, ranges1[i1], next2);
            }
            if (i2 < len2) {
                next2 = Core.nextBoundary(cur, ranges2[i2], next2);
            }
            long max2 = next2 == null ? Long.MAX_VALUE : next2 - 1L;
            Long in1 = null;
            if (i1 < len1) {
                Range r2 = ranges1[i1];
                if (cur >= r2.min && max2 <= r2.max) {
                    in1 = i1;
                }
            }
            Long in2 = null;
            if (i2 < len2) {
                Range r3 = ranges2[i2];
                if (cur >= r3.min && max2 <= r3.max) {
                    in2 = i2;
                }
            }
            if (in1 != null || in2 != null) {
                combined.add(CombinedRange.from(Range.from(cur, max2), in1, in2));
            }
            if (next2 == null) break;
            cur = next2;
        }
        return (CombinedRange[])combined.toArray(CombinedRange[]::new);
    }

    static Long nextBoundary(long cur, Range r2, Long next2) {
        long i;
        if (r2.min > cur && (next2 == null || r2.min < next2)) {
            return r2.min;
        }
        if (r2.max != Long.MAX_VALUE && (i = r2.max + 1L) > cur && (next2 == null || i < next2)) {
            return i;
        }
        return next2;
    }

    public static ListMemberTypes listAtomicTypeAllMemberTypesInnerVal(ListAtomicType atomicType) {
        SemType rest;
        ArrayList<Range> ranges = new ArrayList<Range>();
        ArrayList<SemType> types2 = new ArrayList<SemType>();
        List<CellSemType> cellInitial = atomicType.members().initial();
        int initialLength = cellInitial.size();
        ArrayList<SemType> initial = new ArrayList<SemType>(initialLength);
        for (CellSemType c : cellInitial) {
            initial.add(Core.cellInnerVal(c));
        }
        int fixedLength = atomicType.members().fixedLength();
        if (initialLength != 0) {
            types2.addAll(initial);
            for (int i = 0; i < initialLength; ++i) {
                ranges.add(Range.from(i, i));
            }
            if (initialLength < fixedLength) {
                ranges.set(initialLength - 1, Range.from(initialLength - 1, fixedLength - 1));
            }
        }
        if (!Core.isNever(rest = Core.cellInnerVal(atomicType.rest()))) {
            types2.add(rest);
            ranges.add(Range.from(fixedLength, Long.MAX_VALUE));
        }
        return ListMemberTypes.from(ranges, types2);
    }

    public static MappingAtomicType mappingAtomicType(Context cx, SemType t) {
        MappingAtomicType mappingAtomicInner = PredefinedType.MAPPING_ATOMIC_INNER;
        if (t instanceof BasicTypeBitSet) {
            BasicTypeBitSet b = (BasicTypeBitSet)t;
            return b.bitset == PredefinedType.MAPPING.bitset ? mappingAtomicInner : null;
        }
        Env env = cx.env;
        if (!Core.isSubtypeSimple(t, PredefinedType.MAPPING)) {
            return null;
        }
        return Core.bddMappingAtomicType(env, (Bdd)Core.getComplexSubtypeData((ComplexSemType)t, BasicTypeCode.BT_MAPPING), mappingAtomicInner);
    }

    private static MappingAtomicType bddMappingAtomicType(Env env, Bdd bdd, MappingAtomicType top) {
        if (bdd instanceof BddAllOrNothing) {
            BddAllOrNothing allOrNothing = (BddAllOrNothing)bdd;
            if (allOrNothing.isAll()) {
                return top;
            }
            return null;
        }
        BddNode bddNode = (BddNode)bdd;
        if (bddNode instanceof BddNodeSimple) {
            BddNodeSimple bddNodeSimple = (BddNodeSimple)bddNode;
            return env.mappingAtomType(bddNodeSimple.atom());
        }
        return null;
    }

    public static SemType mappingMemberTypeInnerVal(Context cx, SemType t, SemType k) {
        return Core.diff(Core.mappingMemberTypeInner(cx, t, k), PredefinedType.UNDEF);
    }

    public static SemType mappingMemberTypeInner(Context cx, SemType t, SemType k) {
        if (t instanceof BasicTypeBitSet) {
            BasicTypeBitSet b = (BasicTypeBitSet)t;
            return (b.bitset & PredefinedType.MAPPING.bitset) != 0 ? PredefinedType.VAL : PredefinedType.UNDEF;
        }
        SubtypeData keyData = Core.stringSubtype(k);
        if (Common.isNothingSubtype(keyData)) {
            return PredefinedType.UNDEF;
        }
        return MappingOps.bddMappingMemberTypeInner(cx, (Bdd)Core.getComplexSubtypeData((ComplexSemType)t, BasicTypeCode.BT_MAPPING), keyData, PredefinedType.INNER);
    }

    public static ListAtomicType listAtomicType(Context cx, SemType t) {
        ListAtomicType listAtomicInner = PredefinedType.LIST_ATOMIC_INNER;
        if (t instanceof BasicTypeBitSet) {
            BasicTypeBitSet b = (BasicTypeBitSet)t;
            return b.bitset == PredefinedType.LIST.bitset ? listAtomicInner : null;
        }
        Env env = cx.env;
        if (!Core.isSubtypeSimple(t, PredefinedType.LIST)) {
            return null;
        }
        return Core.bddListAtomicType(env, (Bdd)Core.getComplexSubtypeData((ComplexSemType)t, BasicTypeCode.BT_LIST), listAtomicInner);
    }

    private static ListAtomicType bddListAtomicType(Env env, Bdd bdd, ListAtomicType top) {
        if (bdd instanceof BddAllOrNothing) {
            BddAllOrNothing allOrNothing = (BddAllOrNothing)bdd;
            if (allOrNothing.isAll()) {
                return top;
            }
            return null;
        }
        BddNode bddNode = (BddNode)bdd;
        if (bddNode instanceof BddNodeSimple) {
            BddNodeSimple bddNodeSimple = (BddNodeSimple)bddNode;
            return env.listAtomType(bddNodeSimple.atom());
        }
        return null;
    }

    public static SemType cellInnerVal(CellSemType t) {
        return Core.diff(Core.cellInner(t), PredefinedType.UNDEF);
    }

    public static SemType cellInner(CellSemType t) {
        CellAtomicType cat = Core.cellAtomicType(t);
        assert (cat != null);
        return cat.ty();
    }

    public static CellSemType cellContainingInnerVal(Env env, CellSemType t) {
        CellAtomicType cat = Core.cellAtomicType(t);
        assert (cat != null);
        return CellSubtype.cellContaining(env, Core.diff(cat.ty(), PredefinedType.UNDEF), cat.mut());
    }

    public static CellAtomicType cellAtomicType(SemType t) {
        if (t instanceof BasicTypeBitSet) {
            return PredefinedType.CELL.equals(t) ? PredefinedType.CELL_ATOMIC_VAL : null;
        }
        if (!Core.isSubtypeSimple(t, PredefinedType.CELL)) {
            return null;
        }
        return Core.bddCellAtomicType((Bdd)Core.getComplexSubtypeData((ComplexSemType)t, BasicTypeCode.BT_CELL), PredefinedType.CELL_ATOMIC_VAL);
    }

    static CellAtomicType bddCellAtomicType(Bdd bdd, CellAtomicType top) {
        if (bdd instanceof BddAllOrNothing) {
            BddAllOrNothing allOrNothing = (BddAllOrNothing)bdd;
            if (allOrNothing.isAll()) {
                return top;
            }
            return null;
        }
        BddNode bddNode = (BddNode)bdd;
        if (bddNode.left().equals(BddAllOrNothing.bddAll()) && bddNode.middle().equals(BddAllOrNothing.bddNothing()) && bddNode.right().equals(BddAllOrNothing.bddNothing())) {
            return Core.cellAtomType(bddNode.atom());
        }
        return null;
    }

    public static Optional<Value> singleShape(SemType t) {
        if (PredefinedType.NIL.equals(t)) {
            return Optional.of(Value.from(null));
        }
        if (t instanceof BasicTypeBitSet) {
            return Optional.empty();
        }
        if (Core.isSubtypeSimple(t, PredefinedType.INT)) {
            SubtypeData sd = Core.getComplexSubtypeData((ComplexSemType)t, BasicTypeCode.BT_INT);
            Optional<Long> value2 = IntSubtype.intSubtypeSingleValue(sd);
            return value2.isEmpty() ? Optional.empty() : Optional.of(Value.from(value2.get()));
        }
        if (Core.isSubtypeSimple(t, PredefinedType.FLOAT)) {
            SubtypeData sd = Core.getComplexSubtypeData((ComplexSemType)t, BasicTypeCode.BT_FLOAT);
            Optional<Double> value3 = FloatSubtype.floatSubtypeSingleValue(sd);
            return value3.isEmpty() ? Optional.empty() : Optional.of(Value.from(value3.get()));
        }
        if (Core.isSubtypeSimple(t, PredefinedType.STRING)) {
            SubtypeData sd = Core.getComplexSubtypeData((ComplexSemType)t, BasicTypeCode.BT_STRING);
            Optional<String> value4 = StringSubtype.stringSubtypeSingleValue(sd);
            return value4.isEmpty() ? Optional.empty() : Optional.of(Value.from(value4.get()));
        }
        if (Core.isSubtypeSimple(t, PredefinedType.BOOLEAN)) {
            SubtypeData sd = Core.getComplexSubtypeData((ComplexSemType)t, BasicTypeCode.BT_BOOLEAN);
            Optional<Boolean> value5 = BooleanSubtype.booleanSubtypeSingleValue(sd);
            return value5.isEmpty() ? Optional.empty() : Optional.of(Value.from(value5.get()));
        }
        if (Core.isSubtypeSimple(t, PredefinedType.DECIMAL)) {
            SubtypeData sd = Core.getComplexSubtypeData((ComplexSemType)t, BasicTypeCode.BT_DECIMAL);
            Optional<BigDecimal> value6 = DecimalSubtype.decimalSubtypeSingleValue(sd);
            return value6.isEmpty() ? Optional.empty() : Optional.of(Value.from(value6.get().toString()));
        }
        return Optional.empty();
    }

    public static SemType singleton(Object v) {
        if (v == null) {
            return PredefinedType.NIL;
        }
        if (v instanceof Long) {
            Long lng = (Long)v;
            return IntSubtype.intConst(lng);
        }
        if (v instanceof Double) {
            Double d = (Double)v;
            return FloatSubtype.floatConst(d);
        }
        if (v instanceof String) {
            String s = (String)v;
            return StringSubtype.stringConst(s);
        }
        if (v instanceof Boolean) {
            Boolean b = (Boolean)v;
            return BooleanSubtype.booleanConst(b);
        }
        throw new IllegalStateException("Unsupported type: " + v.getClass().getName());
    }

    public static boolean containsConst(SemType t, Object v) {
        if (v == null) {
            return Core.containsNil(t);
        }
        if (v instanceof Long) {
            Long lng = (Long)v;
            return Core.containsConstInt(t, lng);
        }
        if (v instanceof Double) {
            Double d = (Double)v;
            return Core.containsConstFloat(t, d);
        }
        if (v instanceof String) {
            String s = (String)v;
            return Core.containsConstString(t, s);
        }
        if (v instanceof Boolean) {
            Boolean b = (Boolean)v;
            return Core.containsConstBoolean(t, b);
        }
        return Core.containsConstDecimal(t, (BigDecimal)v);
    }

    public static boolean containsNil(SemType t) {
        if (t instanceof BasicTypeBitSet) {
            BasicTypeBitSet b = (BasicTypeBitSet)t;
            return (b.bitset & 1 << BasicTypeCode.BT_NIL.code) != 0;
        }
        AllOrNothingSubtype complexSubtypeData = (AllOrNothingSubtype)Core.getComplexSubtypeData((ComplexSemType)t, BasicTypeCode.BT_NIL);
        return complexSubtypeData.isAllSubtype();
    }

    public static boolean containsConstString(SemType t, String s) {
        if (t instanceof BasicTypeBitSet) {
            BasicTypeBitSet b = (BasicTypeBitSet)t;
            return (b.bitset & 1 << BasicTypeCode.BT_STRING.code) != 0;
        }
        return StringSubtype.stringSubtypeContains(Core.getComplexSubtypeData((ComplexSemType)t, BasicTypeCode.BT_STRING), s);
    }

    public static boolean containsConstInt(SemType t, long n) {
        if (t instanceof BasicTypeBitSet) {
            BasicTypeBitSet b = (BasicTypeBitSet)t;
            return (b.bitset & 1 << BasicTypeCode.BT_INT.code) != 0;
        }
        return IntSubtype.intSubtypeContains(Core.getComplexSubtypeData((ComplexSemType)t, BasicTypeCode.BT_INT), n);
    }

    public static boolean containsConstFloat(SemType t, double n) {
        if (t instanceof BasicTypeBitSet) {
            BasicTypeBitSet b = (BasicTypeBitSet)t;
            return (b.bitset & 1 << BasicTypeCode.BT_FLOAT.code) != 0;
        }
        return FloatSubtype.floatSubtypeContains(Core.getComplexSubtypeData((ComplexSemType)t, BasicTypeCode.BT_FLOAT), EnumerableFloat.from(n));
    }

    public static boolean containsConstDecimal(SemType t, BigDecimal n) {
        if (t instanceof BasicTypeBitSet) {
            BasicTypeBitSet b = (BasicTypeBitSet)t;
            return (b.bitset & 1 << BasicTypeCode.BT_DECIMAL.code) != 0;
        }
        return DecimalSubtype.decimalSubtypeContains(Core.getComplexSubtypeData((ComplexSemType)t, BasicTypeCode.BT_DECIMAL), EnumerableDecimal.from(n));
    }

    public static boolean containsConstBoolean(SemType t, boolean bool) {
        if (t instanceof BasicTypeBitSet) {
            BasicTypeBitSet b = (BasicTypeBitSet)t;
            return (b.bitset & 1 << BasicTypeCode.BT_BOOLEAN.code) != 0;
        }
        return BooleanSubtype.booleanSubtypeContains(Core.getComplexSubtypeData((ComplexSemType)t, BasicTypeCode.BT_BOOLEAN), bool);
    }

    public static Optional<BasicTypeBitSet> singleNumericType(SemType semType) {
        SemType numType = Core.intersect(semType, PredefinedType.NUMBER);
        if (numType instanceof BasicTypeBitSet) {
            BasicTypeBitSet b = (BasicTypeBitSet)numType;
            if (b.bitset == PredefinedType.NEVER.bitset) {
                return Optional.empty();
            }
        }
        if (Core.isSubtypeSimple(numType, PredefinedType.INT)) {
            return Optional.of(PredefinedType.INT);
        }
        if (Core.isSubtypeSimple(numType, PredefinedType.FLOAT)) {
            return Optional.of(PredefinedType.FLOAT);
        }
        if (Core.isSubtypeSimple(numType, PredefinedType.DECIMAL)) {
            return Optional.of(PredefinedType.DECIMAL);
        }
        return Optional.empty();
    }

    public static SubtypeData subtypeData(SemType s, BasicTypeCode code) {
        if (s instanceof BasicTypeBitSet) {
            BasicTypeBitSet b = (BasicTypeBitSet)s;
            if ((b.bitset & 1 << code.code) != 0) {
                return AllOrNothingSubtype.createAll();
            }
            return AllOrNothingSubtype.createNothing();
        }
        return Core.getComplexSubtypeData((ComplexSemType)s, code);
    }

    public static Context typeCheckContext(Env env) {
        return Context.from(env);
    }

    public static SemType createJson(Context context) {
        SemType memo = context.jsonMemo;
        Env env = context.env;
        if (memo != null) {
            return memo;
        }
        ListDefinition listDef = new ListDefinition();
        MappingDefinition mapDef = new MappingDefinition();
        SemType j = Core.union(PredefinedType.SIMPLE_OR_STRING, Core.union(listDef.getSemType(env), mapDef.getSemType(env)));
        listDef.defineListTypeWrapped(env, j);
        mapDef.defineMappingTypeWrapped(env, new ArrayList<Field>(), j);
        context.jsonMemo = j;
        return j;
    }

    public static SemType createAnydata(Context context) {
        SemType memo = context.anydataMemo;
        Env env = context.env;
        if (memo != null) {
            return memo;
        }
        ListDefinition listDef = new ListDefinition();
        MappingDefinition mapDef = new MappingDefinition();
        SemType tableTy = TableSubtype.tableContaining(env, mapDef.getSemType(env));
        SemType ad = Core.union(Core.union(PredefinedType.SIMPLE_OR_STRING, Core.union(PredefinedType.XML, Core.union(PredefinedType.REGEXP, tableTy))), Core.union(listDef.getSemType(env), mapDef.getSemType(env)));
        listDef.defineListTypeWrapped(env, ad);
        mapDef.defineMappingTypeWrapped(env, new ArrayList<Field>(), ad);
        context.anydataMemo = ad;
        return ad;
    }

    public static SemType createCloneable(Context context) {
        SemType memo = context.cloneableMemo;
        Env env = context.env;
        if (memo != null) {
            return memo;
        }
        ListDefinition listDef = new ListDefinition();
        MappingDefinition mapDef = new MappingDefinition();
        SemType tableTy = TableSubtype.tableContaining(env, mapDef.getSemType(env));
        SemType ad = Core.union(PredefinedType.VAL_READONLY, Core.union(PredefinedType.XML, Core.union(listDef.getSemType(env), Core.union(tableTy, mapDef.getSemType(env)))));
        listDef.defineListTypeWrapped(env, ad);
        mapDef.defineMappingTypeWrapped(env, new ArrayList<Field>(), ad);
        context.cloneableMemo = ad;
        return ad;
    }

    public static SemType createIsolatedObject(Context context) {
        SemType isolatedObj;
        SemType memo = context.isolatedObjectMemo;
        if (memo != null) {
            return memo;
        }
        ObjectQualifiers quals = new ObjectQualifiers(true, false, ObjectQualifiers.NetworkQualifier.None);
        context.isolatedObjectMemo = isolatedObj = new ObjectDefinition().define(context.env, quals, Collections.emptyList());
        return isolatedObj;
    }

    public static SemType createServiceObject(Context context) {
        SemType serviceObj;
        SemType memo = context.serviceObjectMemo;
        if (memo != null) {
            return memo;
        }
        ObjectQualifiers quals = new ObjectQualifiers(false, false, ObjectQualifiers.NetworkQualifier.Service);
        context.serviceObjectMemo = serviceObj = new ObjectDefinition().define(context.env, quals, Collections.emptyList());
        return serviceObj;
    }

    public static SemType createBasicSemType(BasicTypeCode typeCode, SubtypeData subtypeData) {
        if (subtypeData instanceof AllOrNothingSubtype) {
            if (Common.isAllSubtype(subtypeData)) {
                return BasicTypeBitSet.from(1 << typeCode.code);
            }
            return BasicTypeBitSet.from(0);
        }
        return ComplexSemType.createComplexSemType(0, BasicSubtype.from(typeCode, (ProperSubtypeData)subtypeData));
    }

    public static Optional<List<MappingAtomicType>> mappingAtomicTypesInUnion(Context cx, SemType t) {
        ArrayList<MappingAtomicType> matList = new ArrayList<MappingAtomicType>();
        MappingAtomicType mappingAtomicInner = PredefinedType.MAPPING_ATOMIC_INNER;
        if (t instanceof BasicTypeBitSet) {
            BasicTypeBitSet b = (BasicTypeBitSet)t;
            if (b.bitset == PredefinedType.MAPPING.bitset) {
                matList.add(mappingAtomicInner);
                return Optional.of(matList);
            }
            return Optional.empty();
        }
        Env env = cx.env;
        if (!Core.isSubtypeSimple(t, PredefinedType.MAPPING)) {
            return Optional.empty();
        }
        return Core.collectBddMappingAtomicTypesInUnion(env, (Bdd)Core.getComplexSubtypeData((ComplexSemType)t, BasicTypeCode.BT_MAPPING), mappingAtomicInner, matList) ? Optional.of(matList) : Optional.empty();
    }

    private static boolean collectBddMappingAtomicTypesInUnion(Env env, Bdd bdd, MappingAtomicType top, List<MappingAtomicType> matList) {
        BddAllOrNothing rightNode;
        BddAllOrNothing leftNode;
        if (bdd instanceof BddAllOrNothing) {
            BddAllOrNothing allOrNothing = (BddAllOrNothing)bdd;
            if (allOrNothing.isAll()) {
                matList.add(top);
                return true;
            }
            return false;
        }
        BddNode bddNode = (BddNode)bdd;
        if (bddNode instanceof BddNodeSimple) {
            BddNodeSimple bddNodeSimple = (BddNodeSimple)bddNode;
            matList.add(env.mappingAtomType(bddNodeSimple.atom()));
            return true;
        }
        BddNodeImpl bddNodeImpl = (BddNodeImpl)bddNode;
        Bdd bdd2 = bddNodeImpl.left();
        if (bdd2 instanceof BddAllOrNothing && (leftNode = (BddAllOrNothing)bdd2).isAll() && (bdd2 = bddNodeImpl.right()) instanceof BddAllOrNothing && (rightNode = (BddAllOrNothing)bdd2).isNothing()) {
            matList.add(env.mappingAtomType(bddNodeImpl.atom()));
            return Core.collectBddMappingAtomicTypesInUnion(env, bddNodeImpl.middle(), top, matList);
        }
        return false;
    }
}

