/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types;

import io.ballerina.types.Atom;
import io.ballerina.types.AtomicType;
import io.ballerina.types.CellAtomicType;
import io.ballerina.types.FunctionAtomicType;
import io.ballerina.types.ListAtomicType;
import io.ballerina.types.MappingAtomicType;
import io.ballerina.types.PredefinedTypeEnv;
import io.ballerina.types.RecAtom;
import io.ballerina.types.SemType;
import io.ballerina.types.TypeAtom;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class Env {
    private static final int COMPACT_INDEX = 3;
    final List<ListAtomicType> recListAtoms;
    final List<MappingAtomicType> recMappingAtoms;
    final List<FunctionAtomicType> recFunctionAtoms;
    private final AtomicInteger distinctAtomCount;
    private final Map<AtomicType, Reference<TypeAtom>> atomTable = new WeakHashMap<AtomicType, Reference<TypeAtom>>();
    private final LinkedHashMap<String, SemType> types;
    private CompactionData compactionData = null;

    public Env() {
        this.recListAtoms = new ArrayList<ListAtomicType>();
        this.recMappingAtoms = new ArrayList<MappingAtomicType>();
        this.recFunctionAtoms = new ArrayList<FunctionAtomicType>();
        this.types = new LinkedHashMap();
        this.distinctAtomCount = new AtomicInteger(0);
        PredefinedTypeEnv.getInstance().initializeEnv(this);
    }

    public int recListAtomCount() {
        return this.recListAtoms.size();
    }

    public int recMappingAtomCount() {
        return this.recMappingAtoms.size();
    }

    public int recFunctionAtomCount() {
        return this.recFunctionAtoms.size();
    }

    public int distinctAtomCount() {
        return this.distinctAtomCount.get();
    }

    public int distinctAtomCountGetAndIncrement() {
        return this.distinctAtomCount.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecAtom recFunctionAtom() {
        List<FunctionAtomicType> list = this.recFunctionAtoms;
        synchronized (list) {
            int result = this.recFunctionAtoms.size();
            this.recFunctionAtoms.add(null);
            return RecAtom.createRecAtom(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecFunctionAtomType(RecAtom ra, FunctionAtomicType atomicType) {
        List<FunctionAtomicType> list = this.recFunctionAtoms;
        synchronized (list) {
            ra.setKind(Atom.Kind.FUNCTION_ATOM);
            this.recFunctionAtoms.set(ra.index, atomicType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionAtomicType getRecFunctionAtomType(RecAtom ra) {
        List<FunctionAtomicType> list = this.recFunctionAtoms;
        synchronized (list) {
            return this.recFunctionAtoms.get(ra.index);
        }
    }

    public TypeAtom listAtom(ListAtomicType atomicType) {
        return this.typeAtom(atomicType);
    }

    public TypeAtom mappingAtom(MappingAtomicType atomicType) {
        return this.typeAtom(atomicType);
    }

    public TypeAtom functionAtom(FunctionAtomicType atomicType) {
        return this.typeAtom(atomicType);
    }

    public TypeAtom cellAtom(CellAtomicType atomicType) {
        return this.typeAtom(atomicType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeAtom typeAtom(AtomicType atomicType) {
        Map<AtomicType, Reference<TypeAtom>> map2 = this.atomTable;
        synchronized (map2) {
            TypeAtom ta;
            Reference<TypeAtom> ref = this.atomTable.get(atomicType);
            if (ref != null && (ta = ref.get()) != null) {
                return ta;
            }
            TypeAtom result = TypeAtom.createTypeAtom(this.atomTable.size(), atomicType);
            this.atomTable.put(result.atomicType(), new WeakReference<TypeAtom>(result));
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserializeTypeAtom(TypeAtom typeAtom) {
        Map<AtomicType, Reference<TypeAtom>> map2 = this.atomTable;
        synchronized (map2) {
            this.atomTable.put(typeAtom.atomicType(), new WeakReference<TypeAtom>(typeAtom));
        }
    }

    public void insertRecAtomAtIndex(int index, AtomicType atomicType) {
        if (atomicType instanceof MappingAtomicType) {
            MappingAtomicType mappingAtomicType = (MappingAtomicType)atomicType;
            this.insertAtomAtIndexInner(index, this.recMappingAtoms, mappingAtomicType);
        } else if (atomicType instanceof ListAtomicType) {
            ListAtomicType listAtomicType = (ListAtomicType)atomicType;
            this.insertAtomAtIndexInner(index, this.recListAtoms, listAtomicType);
        } else if (atomicType instanceof FunctionAtomicType) {
            FunctionAtomicType functionAtomicType = (FunctionAtomicType)atomicType;
            this.insertAtomAtIndexInner(index, this.recFunctionAtoms, functionAtomicType);
        } else {
            throw new UnsupportedOperationException("Unknown atomic type " + String.valueOf(atomicType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends AtomicType> void insertAtomAtIndexInner(int index, List<E> atoms, E atomicType) {
        List<Object> list = atoms;
        synchronized (list) {
            if (atoms.size() > index && atoms.get(index) != null) {
                return;
            }
            while (atoms.size() < index + 1) {
                atoms.add(null);
            }
            atoms.set(index, atomicType);
        }
    }

    public ListAtomicType listAtomType(Atom atom) {
        if (atom instanceof RecAtom) {
            RecAtom recAtom = (RecAtom)atom;
            return this.getRecListAtomType(recAtom);
        }
        return (ListAtomicType)((TypeAtom)atom).atomicType();
    }

    public FunctionAtomicType functionAtomType(Atom atom) {
        if (atom instanceof RecAtom) {
            RecAtom recAtom = (RecAtom)atom;
            return this.getRecFunctionAtomType(recAtom);
        }
        return (FunctionAtomicType)((TypeAtom)atom).atomicType();
    }

    public MappingAtomicType mappingAtomType(Atom atom) {
        if (atom instanceof RecAtom) {
            RecAtom recAtom = (RecAtom)atom;
            return this.getRecMappingAtomType(recAtom);
        }
        return (MappingAtomicType)((TypeAtom)atom).atomicType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecAtom recListAtom() {
        List<ListAtomicType> list = this.recListAtoms;
        synchronized (list) {
            int result = this.recListAtoms.size();
            this.recListAtoms.add(null);
            return RecAtom.createRecAtom(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecAtom recMappingAtom() {
        List<MappingAtomicType> list = this.recMappingAtoms;
        synchronized (list) {
            int result = this.recMappingAtoms.size();
            this.recMappingAtoms.add(null);
            return RecAtom.createRecAtom(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecListAtomType(RecAtom ra, ListAtomicType atomicType) {
        List<ListAtomicType> list = this.recListAtoms;
        synchronized (list) {
            ra.setKind(Atom.Kind.LIST_ATOM);
            this.recListAtoms.set(ra.index, atomicType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecMappingAtomType(RecAtom ra, MappingAtomicType atomicType) {
        List<ListAtomicType> list = this.recListAtoms;
        synchronized (list) {
            ra.setKind(Atom.Kind.MAPPING_ATOM);
            this.recMappingAtoms.set(ra.index, atomicType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListAtomicType getRecListAtomType(RecAtom ra) {
        List<ListAtomicType> list = this.recListAtoms;
        synchronized (list) {
            return this.recListAtoms.get(ra.index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappingAtomicType getRecMappingAtomType(RecAtom ra) {
        List<MappingAtomicType> list = this.recMappingAtoms;
        synchronized (list) {
            return this.recMappingAtoms.get(ra.index);
        }
    }

    public static CellAtomicType cellAtomType(Atom atom) {
        return (CellAtomicType)((TypeAtom)atom).atomicType();
    }

    public void addTypeDef(String typeName, SemType semType) {
        this.types.put(typeName, semType);
    }

    public Map<String, SemType> getTypeNameSemTypeMap() {
        return new LinkedHashMap<String, SemType>(this.types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int atomCount() {
        Map<AtomicType, Reference<TypeAtom>> map2 = this.atomTable;
        synchronized (map2) {
            return this.atomTable.size();
        }
    }

    public synchronized int compactRecIndex(RecAtom recAtom) {
        if (this.compactionData == null || !this.compactionData.state().equals(EnvState.from(this))) {
            this.compactionData = this.compaction();
        }
        if (recAtom.index < 3) {
            return recAtom.index;
        }
        return switch (recAtom.kind()) {
            default -> throw new MatchException(null, null);
            case Atom.Kind.LIST_ATOM -> this.compactionData.listMap().get(recAtom.index());
            case Atom.Kind.MAPPING_ATOM -> this.compactionData.mapMap().get(recAtom.index());
            case Atom.Kind.FUNCTION_ATOM -> this.compactionData.funcMap().get(recAtom.index());
            case Atom.Kind.CELL_ATOM, Atom.Kind.XML_ATOM, Atom.Kind.DISTINCT_ATOM -> recAtom.index;
        };
    }

    private CompactionData compaction() {
        EnvState state = EnvState.from(this);
        Map<Integer, Integer> listMap = this.recListCompaction(this.recListAtoms);
        Map<Integer, Integer> mapMap = this.recListCompaction(this.recMappingAtoms);
        Map<Integer, Integer> funcMap = this.recListCompaction(this.recFunctionAtoms);
        return new CompactionData(state, listMap, mapMap, funcMap);
    }

    private <E extends AtomicType> Map<Integer, Integer> recListCompaction(List<E> recAtomList) {
        HashMap<Integer, Integer> map2 = new HashMap<Integer, Integer>();
        int compactIndex = 3;
        for (int i = 3; i < recAtomList.size(); ++i) {
            if (recAtomList.get(i) == null) continue;
            map2.put(i, compactIndex);
            ++compactIndex;
        }
        return map2;
    }

    private record CompactionData(EnvState state, Map<Integer, Integer> listMap, Map<Integer, Integer> mapMap, Map<Integer, Integer> funcMap) {
    }

    record EnvState(int recListAtomCount, int recMappingAtomCount, int recFunctionAtomCount) {
        public static EnvState from(Env env) {
            return new EnvState(env.recListAtomCount(), env.recMappingAtomCount(), env.recFunctionAtomCount());
        }
    }
}

