/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types;

import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.Bdd;
import io.ballerina.types.Core;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.RecAtom;
import io.ballerina.types.SemType;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.AllOrNothingSubtype;
import io.ballerina.types.subtypedata.BddNode;
import io.ballerina.types.typeops.BddCommonOps;

public class Error {
    public static SemType errorDetail(SemType detail2) {
        SubtypeData mappingSd = Core.subtypeData(detail2, BasicTypeCode.BT_MAPPING);
        if (mappingSd instanceof AllOrNothingSubtype) {
            AllOrNothingSubtype allOrNothingSubtype = (AllOrNothingSubtype)mappingSd;
            if (allOrNothingSubtype.isAllSubtype()) {
                return PredefinedType.ERROR;
            }
            return PredefinedType.NEVER;
        }
        Bdd sd = BddCommonOps.bddIntersect((Bdd)mappingSd, PredefinedType.BDD_SUBTYPE_RO);
        if (sd.equals(PredefinedType.BDD_SUBTYPE_RO)) {
            return PredefinedType.ERROR;
        }
        return PredefinedType.basicSubtype(BasicTypeCode.BT_ERROR, sd);
    }

    public static SemType errorDistinct(int distinctId) {
        assert (distinctId >= 0);
        BddNode bdd = BddCommonOps.bddAtom(RecAtom.createDistinctRecAtom(-distinctId - 1));
        return PredefinedType.basicSubtype(BasicTypeCode.BT_ERROR, bdd);
    }
}

