/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types;

import io.ballerina.types.Atom;
import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.Bdd;
import io.ballerina.types.BddPath;
import io.ballerina.types.ComplexSemType;
import io.ballerina.types.Context;
import io.ballerina.types.Core;
import io.ballerina.types.MappingAtomicType;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import java.util.ArrayList;
import java.util.List;

public class MappingAlternative {
    SemType semType;
    MappingAtomicType[] pos;
    MappingAtomicType[] neg;

    private MappingAlternative(SemType semType, MappingAtomicType[] pos, MappingAtomicType[] neg) {
        this.semType = semType;
        this.pos = pos;
        this.neg = neg;
    }

    public MappingAlternative[] mappingAlternatives(Context cx, SemType t) {
        if (t instanceof BasicTypeBitSet) {
            BasicTypeBitSet b = (BasicTypeBitSet)t;
            if ((b.bitset & PredefinedType.MAPPING.bitset) == 0) {
                return new MappingAlternative[0];
            }
            return new MappingAlternative[]{this.from(cx, PredefinedType.MAPPING, List.of(), List.of())};
        }
        ArrayList<BddPath> paths = new ArrayList<BddPath>();
        BddPath.bddPaths((Bdd)Core.getComplexSubtypeData((ComplexSemType)t, BasicTypeCode.BT_MAPPING), paths, BddPath.from());
        ArrayList<MappingAlternative> alts = new ArrayList<MappingAlternative>();
        for (BddPath bddPath : paths) {
            SemType semType = Core.createBasicSemType(BasicTypeCode.BT_MAPPING, bddPath.bdd);
            if (Core.isNever(semType)) continue;
            alts.add(this.from(cx, semType, bddPath.pos, bddPath.neg));
        }
        return alts.toArray(new MappingAlternative[0]);
    }

    public MappingAlternative from(Context cx, SemType semType, List<Atom> pos, List<Atom> neg) {
        int i;
        MappingAtomicType[] p = new MappingAtomicType[pos.size()];
        MappingAtomicType[] n = new MappingAtomicType[neg.size()];
        for (i = 0; i < pos.size(); ++i) {
            p[i] = cx.mappingAtomType(pos.get(i));
        }
        for (i = 0; i < neg.size(); ++i) {
            n[i] = cx.mappingAtomType(neg.get(i));
        }
        return new MappingAlternative(semType, p, n);
    }
}

