/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types;

import io.ballerina.types.BasicSubtype;
import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.CellAtomicType;
import io.ballerina.types.CellSemType;
import io.ballerina.types.ComplexSemType;
import io.ballerina.types.Core;
import io.ballerina.types.FixedLengthArray;
import io.ballerina.types.ListAtomicType;
import io.ballerina.types.MappingAtomicType;
import io.ballerina.types.PredefinedTypeEnv;
import io.ballerina.types.ProperSubtypeData;
import io.ballerina.types.RecAtom;
import io.ballerina.types.SemType;
import io.ballerina.types.TypeAtom;
import io.ballerina.types.subtypedata.BddNode;
import io.ballerina.types.subtypedata.IntSubtype;
import io.ballerina.types.subtypedata.StringSubtype;
import io.ballerina.types.subtypedata.XmlSubtype;
import io.ballerina.types.typeops.BddCommonOps;
import io.ballerina.types.typeops.XmlOps;
import java.util.StringJoiner;

public final class PredefinedType {
    private static final PredefinedTypeEnv predefinedTypeEnv = PredefinedTypeEnv.getInstance();
    public static final BasicTypeBitSet NEVER = PredefinedType.basicTypeUnion(0);
    public static final BasicTypeBitSet NIL = PredefinedType.basicType(BasicTypeCode.BT_NIL);
    public static final BasicTypeBitSet BOOLEAN = PredefinedType.basicType(BasicTypeCode.BT_BOOLEAN);
    public static final BasicTypeBitSet INT = PredefinedType.basicType(BasicTypeCode.BT_INT);
    public static final BasicTypeBitSet FLOAT = PredefinedType.basicType(BasicTypeCode.BT_FLOAT);
    public static final BasicTypeBitSet DECIMAL = PredefinedType.basicType(BasicTypeCode.BT_DECIMAL);
    public static final BasicTypeBitSet STRING = PredefinedType.basicType(BasicTypeCode.BT_STRING);
    public static final BasicTypeBitSet ERROR = PredefinedType.basicType(BasicTypeCode.BT_ERROR);
    public static final BasicTypeBitSet LIST = PredefinedType.basicType(BasicTypeCode.BT_LIST);
    public static final BasicTypeBitSet MAPPING = PredefinedType.basicType(BasicTypeCode.BT_MAPPING);
    public static final BasicTypeBitSet TABLE = PredefinedType.basicType(BasicTypeCode.BT_TABLE);
    public static final BasicTypeBitSet CELL = PredefinedType.basicType(BasicTypeCode.BT_CELL);
    public static final BasicTypeBitSet UNDEF = PredefinedType.basicType(BasicTypeCode.BT_UNDEF);
    public static final BasicTypeBitSet REGEXP = PredefinedType.basicType(BasicTypeCode.BT_REGEXP);
    public static final BasicTypeBitSet FUNCTION = PredefinedType.basicType(BasicTypeCode.BT_FUNCTION);
    public static final BasicTypeBitSet TYPEDESC = PredefinedType.basicType(BasicTypeCode.BT_TYPEDESC);
    public static final BasicTypeBitSet HANDLE = PredefinedType.basicType(BasicTypeCode.BT_HANDLE);
    public static final BasicTypeBitSet XML = PredefinedType.basicType(BasicTypeCode.BT_XML);
    public static final BasicTypeBitSet OBJECT = PredefinedType.basicType(BasicTypeCode.BT_OBJECT);
    public static final BasicTypeBitSet STREAM = PredefinedType.basicType(BasicTypeCode.BT_STREAM);
    public static final BasicTypeBitSet FUTURE = PredefinedType.basicType(BasicTypeCode.BT_FUTURE);
    public static final BasicTypeBitSet VAL = PredefinedType.basicTypeUnion(BasicTypeCode.VT_MASK);
    public static final BasicTypeBitSet INNER = BasicTypeBitSet.from(PredefinedType.VAL.bitset | PredefinedType.UNDEF.bitset);
    public static final BasicTypeBitSet ANY = PredefinedType.basicTypeUnion(BasicTypeCode.VT_MASK & ~(1 << BasicTypeCode.BT_ERROR.code));
    public static final BasicTypeBitSet SIMPLE_OR_STRING = PredefinedType.basicTypeUnion(1 << BasicTypeCode.BT_NIL.code | 1 << BasicTypeCode.BT_BOOLEAN.code | 1 << BasicTypeCode.BT_INT.code | 1 << BasicTypeCode.BT_FLOAT.code | 1 << BasicTypeCode.BT_DECIMAL.code | 1 << BasicTypeCode.BT_STRING.code);
    public static final BasicTypeBitSet NUMBER = PredefinedType.basicTypeUnion(1 << BasicTypeCode.BT_INT.code | 1 << BasicTypeCode.BT_FLOAT.code | 1 << BasicTypeCode.BT_DECIMAL.code);
    public static final SemType BYTE = IntSubtype.intWidthUnsigned(8);
    public static final SemType STRING_CHAR = StringSubtype.stringChar();
    public static final SemType XML_ELEMENT = XmlSubtype.xmlSingleton(36);
    public static final SemType XML_COMMENT = XmlSubtype.xmlSingleton(144);
    public static final SemType XML_TEXT = XmlSubtype.xmlSequence(XmlSubtype.xmlSingleton(2));
    public static final SemType XML_PI = XmlSubtype.xmlSingleton(72);
    public static final int BDD_REC_ATOM_READONLY = 0;
    public static final BddNode BDD_SUBTYPE_RO = BddCommonOps.bddAtom(RecAtom.createRecAtom(0));
    public static final ComplexSemType MAPPING_RO = PredefinedType.basicSubtype(BasicTypeCode.BT_MAPPING, BDD_SUBTYPE_RO);
    public static final CellAtomicType CELL_ATOMIC_VAL = predefinedTypeEnv.cellAtomicVal();
    public static final TypeAtom ATOM_CELL_VAL = predefinedTypeEnv.atomCellVal();
    public static final CellAtomicType CELL_ATOMIC_NEVER = predefinedTypeEnv.cellAtomicNever();
    public static final TypeAtom ATOM_CELL_NEVER = predefinedTypeEnv.atomCellNever();
    public static final CellAtomicType CELL_ATOMIC_INNER = predefinedTypeEnv.cellAtomicInner();
    public static final TypeAtom ATOM_CELL_INNER = predefinedTypeEnv.atomCellInner();
    public static final CellAtomicType CELL_ATOMIC_UNDEF = predefinedTypeEnv.cellAtomicUndef();
    public static final TypeAtom ATOM_CELL_UNDEF = predefinedTypeEnv.atomCellUndef();
    static final CellSemType CELL_SEMTYPE_INNER = (CellSemType)PredefinedType.basicSubtype(BasicTypeCode.BT_CELL, BddCommonOps.bddAtom(ATOM_CELL_INNER));
    public static final MappingAtomicType MAPPING_ATOMIC_INNER = MappingAtomicType.from(new String[0], new CellSemType[0], CELL_SEMTYPE_INNER);
    public static final ListAtomicType LIST_ATOMIC_INNER = ListAtomicType.from(FixedLengthArray.empty(), CELL_SEMTYPE_INNER);
    public static final CellAtomicType CELL_ATOMIC_INNER_MAPPING = predefinedTypeEnv.cellAtomicInnerMapping();
    public static final TypeAtom ATOM_CELL_INNER_MAPPING = predefinedTypeEnv.atomCellInnerMapping();
    public static final CellSemType CELL_SEMTYPE_INNER_MAPPING = (CellSemType)PredefinedType.basicSubtype(BasicTypeCode.BT_CELL, BddCommonOps.bddAtom(ATOM_CELL_INNER_MAPPING));
    public static final ListAtomicType LIST_ATOMIC_MAPPING = predefinedTypeEnv.listAtomicMapping();
    static final TypeAtom ATOM_LIST_MAPPING = predefinedTypeEnv.atomListMapping();
    public static final BddNode LIST_SUBTYPE_MAPPING = BddCommonOps.bddAtom(ATOM_LIST_MAPPING);
    public static final CellAtomicType CELL_ATOMIC_INNER_MAPPING_RO = predefinedTypeEnv.cellAtomicInnerMappingRO();
    public static final TypeAtom ATOM_CELL_INNER_MAPPING_RO = predefinedTypeEnv.atomCellInnerMappingRO();
    public static final CellSemType CELL_SEMTYPE_INNER_MAPPING_RO = (CellSemType)PredefinedType.basicSubtype(BasicTypeCode.BT_CELL, BddCommonOps.bddAtom(ATOM_CELL_INNER_MAPPING_RO));
    public static final ListAtomicType LIST_ATOMIC_MAPPING_RO = predefinedTypeEnv.listAtomicMappingRO();
    static final TypeAtom ATOM_LIST_MAPPING_RO = predefinedTypeEnv.atomListMappingRO();
    static final BddNode LIST_SUBTYPE_MAPPING_RO = BddCommonOps.bddAtom(ATOM_LIST_MAPPING_RO);
    static final CellSemType CELL_SEMTYPE_VAL = (CellSemType)PredefinedType.basicSubtype(BasicTypeCode.BT_CELL, BddCommonOps.bddAtom(ATOM_CELL_VAL));
    static final CellSemType CELL_SEMTYPE_UNDEF = (CellSemType)PredefinedType.basicSubtype(BasicTypeCode.BT_CELL, BddCommonOps.bddAtom(ATOM_CELL_UNDEF));
    private static final TypeAtom ATOM_CELL_OBJECT_MEMBER_KIND = predefinedTypeEnv.atomCellObjectMemberKind();
    static final CellSemType CELL_SEMTYPE_OBJECT_MEMBER_KIND = (CellSemType)PredefinedType.basicSubtype(BasicTypeCode.BT_CELL, BddCommonOps.bddAtom(ATOM_CELL_OBJECT_MEMBER_KIND));
    private static final TypeAtom ATOM_CELL_OBJECT_MEMBER_VISIBILITY = predefinedTypeEnv.atomCellObjectMemberVisibility();
    static final CellSemType CELL_SEMTYPE_OBJECT_MEMBER_VISIBILITY = (CellSemType)PredefinedType.basicSubtype(BasicTypeCode.BT_CELL, BddCommonOps.bddAtom(ATOM_CELL_OBJECT_MEMBER_VISIBILITY));
    public static final TypeAtom ATOM_MAPPING_OBJECT_MEMBER = predefinedTypeEnv.atomMappingObjectMember();
    static final ComplexSemType MAPPING_SEMTYPE_OBJECT_MEMBER = PredefinedType.basicSubtype(BasicTypeCode.BT_MAPPING, BddCommonOps.bddAtom(ATOM_MAPPING_OBJECT_MEMBER));
    public static final TypeAtom ATOM_CELL_OBJECT_MEMBER = predefinedTypeEnv.atomCellObjectMember();
    static final CellSemType CELL_SEMTYPE_OBJECT_MEMBER = (CellSemType)PredefinedType.basicSubtype(BasicTypeCode.BT_CELL, BddCommonOps.bddAtom(ATOM_CELL_OBJECT_MEMBER));
    static final CellSemType CELL_SEMTYPE_OBJECT_QUALIFIER = CELL_SEMTYPE_VAL;
    public static final TypeAtom ATOM_MAPPING_OBJECT = predefinedTypeEnv.atomMappingObject();
    public static final BddNode MAPPING_SUBTYPE_OBJECT = BddCommonOps.bddAtom(ATOM_MAPPING_OBJECT);
    private static final int BDD_REC_ATOM_OBJECT_READONLY = 1;
    private static final RecAtom OBJECT_RO_REC_ATOM = RecAtom.createRecAtom(1);
    public static final BddNode MAPPING_SUBTYPE_OBJECT_RO = BddCommonOps.bddAtom(OBJECT_RO_REC_ATOM);
    public static final ComplexSemType MAPPING_ARRAY_RO = PredefinedType.basicSubtype(BasicTypeCode.BT_LIST, LIST_SUBTYPE_MAPPING_RO);
    public static final TypeAtom ATOM_CELL_MAPPING_ARRAY_RO = predefinedTypeEnv.atomCellMappingArrayRO();
    public static final CellSemType CELL_SEMTYPE_LIST_SUBTYPE_MAPPING_RO = (CellSemType)PredefinedType.basicSubtype(BasicTypeCode.BT_CELL, BddCommonOps.bddAtom(ATOM_CELL_MAPPING_ARRAY_RO));
    static final TypeAtom ATOM_LIST_THREE_ELEMENT_RO = predefinedTypeEnv.atomListThreeElementRO();
    public static final BddNode LIST_SUBTYPE_THREE_ELEMENT_RO = BddCommonOps.bddAtom(ATOM_LIST_THREE_ELEMENT_RO);
    public static final SemType VAL_READONLY = ComplexSemType.createComplexSemType(BasicTypeCode.VT_INHERENTLY_IMMUTABLE, BasicSubtype.from(BasicTypeCode.BT_LIST, BDD_SUBTYPE_RO), BasicSubtype.from(BasicTypeCode.BT_MAPPING, BDD_SUBTYPE_RO), BasicSubtype.from(BasicTypeCode.BT_TABLE, LIST_SUBTYPE_THREE_ELEMENT_RO), BasicSubtype.from(BasicTypeCode.BT_XML, XmlOps.XML_SUBTYPE_RO), BasicSubtype.from(BasicTypeCode.BT_OBJECT, MAPPING_SUBTYPE_OBJECT_RO));
    public static final SemType INNER_READONLY = Core.union(VAL_READONLY, UNDEF);
    public static final CellAtomicType CELL_ATOMIC_INNER_RO = predefinedTypeEnv.cellAtomicInnerRO();
    public static final TypeAtom ATOM_CELL_INNER_RO = predefinedTypeEnv.atomCellInnerRO();
    public static final CellSemType CELL_SEMTYPE_INNER_RO = (CellSemType)PredefinedType.basicSubtype(BasicTypeCode.BT_CELL, BddCommonOps.bddAtom(ATOM_CELL_INNER_RO));
    public static final TypeAtom ATOM_CELL_VAL_RO = predefinedTypeEnv.atomCellValRO();
    static final CellSemType CELL_SEMTYPE_VAL_RO = (CellSemType)PredefinedType.basicSubtype(BasicTypeCode.BT_CELL, BddCommonOps.bddAtom(ATOM_CELL_VAL_RO));
    public static final TypeAtom ATOM_MAPPING_OBJECT_MEMBER_RO = predefinedTypeEnv.atomMappingObjectMemberRO();
    static final ComplexSemType MAPPING_SEMTYPE_OBJECT_MEMBER_RO = PredefinedType.basicSubtype(BasicTypeCode.BT_MAPPING, BddCommonOps.bddAtom(ATOM_MAPPING_OBJECT_MEMBER_RO));
    private static final TypeAtom ATOM_CELL_OBJECT_MEMBER_RO = predefinedTypeEnv.atomCellObjectMemberRO();
    static final CellSemType CELL_SEMTYPE_OBJECT_MEMBER_RO = (CellSemType)PredefinedType.basicSubtype(BasicTypeCode.BT_CELL, BddCommonOps.bddAtom(ATOM_CELL_OBJECT_MEMBER_RO));
    public static final ListAtomicType LIST_ATOMIC_TWO_ELEMENT = predefinedTypeEnv.listAtomicTwoElement();
    static final TypeAtom ATOM_LIST_TWO_ELEMENT = predefinedTypeEnv.atomListTwoElement();
    public static final BddNode LIST_SUBTYPE_TWO_ELEMENT = BddCommonOps.bddAtom(ATOM_LIST_TWO_ELEMENT);
    public static final ComplexSemType MAPPING_ARRAY = PredefinedType.basicSubtype(BasicTypeCode.BT_LIST, LIST_SUBTYPE_MAPPING);
    public static final TypeAtom ATOM_CELL_MAPPING_ARRAY = predefinedTypeEnv.atomCellMappingArray();
    public static final CellSemType CELL_SEMTYPE_LIST_SUBTYPE_MAPPING = (CellSemType)PredefinedType.basicSubtype(BasicTypeCode.BT_CELL, BddCommonOps.bddAtom(ATOM_CELL_MAPPING_ARRAY));
    static final TypeAtom ATOM_LIST_THREE_ELEMENT = predefinedTypeEnv.atomListThreeElement();
    public static final BddNode LIST_SUBTYPE_THREE_ELEMENT = BddCommonOps.bddAtom(ATOM_LIST_THREE_ELEMENT);
    public static final MappingAtomicType MAPPING_ATOMIC_RO = predefinedTypeEnv.mappingAtomicRO();
    public static final MappingAtomicType MAPPING_ATOMIC_OBJECT_RO = predefinedTypeEnv.getMappingAtomicObjectRO();
    public static final ListAtomicType LIST_ATOMIC_RO = predefinedTypeEnv.listAtomicRO();

    private PredefinedType() {
    }

    static BasicTypeBitSet basicTypeUnion(int bitset) {
        return BasicTypeBitSet.from(bitset);
    }

    public static BasicTypeBitSet basicType(BasicTypeCode code) {
        return BasicTypeBitSet.from(1 << code.code);
    }

    public static ComplexSemType basicSubtype(BasicTypeCode code, ProperSubtypeData data2) {
        if (code.equals(BasicTypeCode.BT_CELL)) {
            return CellSemType.from(new ProperSubtypeData[]{data2});
        }
        return ComplexSemType.createComplexSemType(0, BasicSubtype.from(code, data2));
    }

    static String toString(int bitset) {
        StringJoiner sj = new StringJoiner("|", Integer.toBinaryString(bitset) + "[", "]");
        PredefinedType.addIfBitSet(sj, bitset, PredefinedType.NEVER.bitset, "never");
        PredefinedType.addIfBitSet(sj, bitset, PredefinedType.NIL.bitset, "nil");
        PredefinedType.addIfBitSet(sj, bitset, PredefinedType.BOOLEAN.bitset, "boolean");
        PredefinedType.addIfBitSet(sj, bitset, PredefinedType.INT.bitset, "int");
        PredefinedType.addIfBitSet(sj, bitset, PredefinedType.FLOAT.bitset, "float");
        PredefinedType.addIfBitSet(sj, bitset, PredefinedType.DECIMAL.bitset, "decimal");
        PredefinedType.addIfBitSet(sj, bitset, PredefinedType.STRING.bitset, "string");
        PredefinedType.addIfBitSet(sj, bitset, PredefinedType.ERROR.bitset, "error");
        PredefinedType.addIfBitSet(sj, bitset, PredefinedType.TYPEDESC.bitset, "typedesc");
        PredefinedType.addIfBitSet(sj, bitset, PredefinedType.HANDLE.bitset, "handle");
        PredefinedType.addIfBitSet(sj, bitset, PredefinedType.FUNCTION.bitset, "function");
        PredefinedType.addIfBitSet(sj, bitset, PredefinedType.REGEXP.bitset, "regexp");
        PredefinedType.addIfBitSet(sj, bitset, PredefinedType.FUTURE.bitset, "future");
        PredefinedType.addIfBitSet(sj, bitset, PredefinedType.STREAM.bitset, "stream");
        PredefinedType.addIfBitSet(sj, bitset, PredefinedType.LIST.bitset, "list");
        PredefinedType.addIfBitSet(sj, bitset, PredefinedType.MAPPING.bitset, "map");
        PredefinedType.addIfBitSet(sj, bitset, PredefinedType.TABLE.bitset, "table");
        PredefinedType.addIfBitSet(sj, bitset, PredefinedType.XML.bitset, "xml");
        PredefinedType.addIfBitSet(sj, bitset, PredefinedType.OBJECT.bitset, "object");
        PredefinedType.addIfBitSet(sj, bitset, PredefinedType.CELL.bitset, "cell");
        PredefinedType.addIfBitSet(sj, bitset, PredefinedType.UNDEF.bitset, "undef");
        return sj.toString();
    }

    private static void addIfBitSet(StringJoiner sj, int bitset, int bitToBeCheck, String strToBeAdded) {
        if ((bitset & bitToBeCheck) != 0) {
            sj.add(strToBeAdded);
        }
    }
}

