/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.definition;

import io.ballerina.types.Atom;
import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.ComplexSemType;
import io.ballerina.types.Definition;
import io.ballerina.types.Env;
import io.ballerina.types.FunctionAtomicType;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.RecAtom;
import io.ballerina.types.SemType;
import io.ballerina.types.definition.FunctionQualifiers;
import io.ballerina.types.subtypedata.BddNode;
import io.ballerina.types.typeops.BddCommonOps;

public final class FunctionDefinition
implements Definition {
    private RecAtom rec;
    private SemType semType;

    @Override
    public SemType getSemType(Env env) {
        RecAtom rec;
        if (this.semType != null) {
            return this.semType;
        }
        this.rec = rec = env.recFunctionAtom();
        return this.createSemType(rec);
    }

    private SemType createSemType(Atom rec) {
        BddNode bdd = BddCommonOps.bddAtom(rec);
        ComplexSemType s = PredefinedType.basicSubtype(BasicTypeCode.BT_FUNCTION, bdd);
        this.semType = s;
        return s;
    }

    public SemType define(Env env, SemType args2, SemType ret, FunctionQualifiers qualifiers) {
        FunctionAtomicType atomicType = FunctionAtomicType.from(args2, ret, qualifiers.semType());
        return this.defineInternal(env, atomicType);
    }

    public SemType defineGeneric(Env env, SemType args2, SemType ret, FunctionQualifiers qualifiers) {
        FunctionAtomicType atomicType = FunctionAtomicType.genericFrom(args2, ret, qualifiers.semType());
        return this.defineInternal(env, atomicType);
    }

    private SemType defineInternal(Env env, FunctionAtomicType atomicType) {
        Atom atom;
        RecAtom rec = this.rec;
        if (rec != null) {
            atom = rec;
            env.setRecFunctionAtomType(rec, atomicType);
        } else {
            atom = env.functionAtom(atomicType);
        }
        return this.createSemType(atom);
    }
}

