/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.definition;

import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import io.ballerina.types.definition.Field;

public record Member(String name, SemType valueTy, Kind kind, Visibility visibility, boolean immutable) {
    public Member {
        assert (name != null && valueTy != null && kind != null && visibility != null);
    }

    public static enum Kind implements MemberTag
    {
        Field,
        Method;

        private static final Field FIELD;
        private static final Field METHOD;

        @Override
        public Field field() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> FIELD;
                case 1 -> METHOD;
            };
        }

        static {
            FIELD = new Field("kind", SemTypes.stringConst("field"), true, false);
            METHOD = new Field("kind", SemTypes.stringConst("method"), true, false);
        }
    }

    public static enum Visibility implements MemberTag
    {
        Public,
        Private;

        private static final SemType PUBLIC_TAG;
        private static final Field PUBLIC;
        private static final SemType PRIVATE_TAG;
        private static final Field PRIVATE;
        static final Field ALL;

        @Override
        public Field field() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> PUBLIC;
                case 1 -> PRIVATE;
            };
        }

        static {
            PUBLIC_TAG = SemTypes.stringConst("public");
            PUBLIC = new Field("visibility", PUBLIC_TAG, true, false);
            PRIVATE_TAG = SemTypes.stringConst("private");
            PRIVATE = new Field("visibility", PRIVATE_TAG, true, false);
            ALL = new Field("visibility", SemTypes.union(PRIVATE_TAG, PUBLIC_TAG), true, false);
        }
    }

    @FunctionalInterface
    static interface MemberTag {
        public Field field();
    }
}

