/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.typeops;

import io.ballerina.types.BasicTypeOps;
import io.ballerina.types.Common;
import io.ballerina.types.Context;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.AllOrNothingSubtype;
import io.ballerina.types.subtypedata.BooleanSubtype;

public class BooleanOps
implements BasicTypeOps {
    @Override
    public SubtypeData union(SubtypeData d1, SubtypeData d2) {
        BooleanSubtype v1 = (BooleanSubtype)d1;
        BooleanSubtype v2 = (BooleanSubtype)d2;
        return v1.value == v2.value ? v1 : AllOrNothingSubtype.createAll();
    }

    @Override
    public SubtypeData intersect(SubtypeData d1, SubtypeData d2) {
        BooleanSubtype v1 = (BooleanSubtype)d1;
        BooleanSubtype v2 = (BooleanSubtype)d2;
        return v1.value == v2.value ? v1 : AllOrNothingSubtype.createNothing();
    }

    @Override
    public SubtypeData diff(SubtypeData d1, SubtypeData d2) {
        BooleanSubtype v1 = (BooleanSubtype)d1;
        BooleanSubtype v2 = (BooleanSubtype)d2;
        return v1.value == v2.value ? AllOrNothingSubtype.createNothing() : v1;
    }

    @Override
    public SubtypeData complement(SubtypeData d) {
        BooleanSubtype v = (BooleanSubtype)d;
        BooleanSubtype t = BooleanSubtype.from(!v.value);
        return t;
    }

    @Override
    public boolean isEmpty(Context cx, SubtypeData t) {
        return Common.notIsEmpty(cx, t);
    }
}

