/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.typeops;

import io.ballerina.types.BasicTypeOps;
import io.ballerina.types.Bdd;
import io.ballerina.types.Common;
import io.ballerina.types.Conjunction;
import io.ballerina.types.Context;
import io.ballerina.types.Core;
import io.ballerina.types.FunctionAtomicType;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.typeops.CommonOps;
import java.io.PrintStream;

public class FunctionOps
extends CommonOps
implements BasicTypeOps {
    private static final PrintStream console = System.out;

    @Override
    public boolean isEmpty(Context cx, SubtypeData t) {
        return Common.memoSubtypeIsEmpty(cx, cx.functionMemo, (context, bdd) -> Common.bddEvery(context, bdd, null, null, FunctionOps::functionFormulaIsEmpty), (Bdd)t);
    }

    private static boolean functionFormulaIsEmpty(Context cx, Conjunction pos, Conjunction neg) {
        return FunctionOps.functionPathIsEmpty(cx, FunctionOps.functionIntersectRet(cx, pos), FunctionOps.functionUnionParams(cx, pos), FunctionOps.functionUnionQualifiers(cx, pos), pos, neg);
    }

    private static boolean functionPathIsEmpty(Context cx, SemType rets, SemType params, SemType qualifiers, Conjunction pos, Conjunction neg) {
        if (neg == null) {
            return false;
        }
        FunctionAtomicType t = cx.functionAtomType(neg.atom);
        SemType t02 = t.paramType();
        SemType t110 = t.retType();
        SemType t22 = t.qualifiers();
        if (t.isGeneric()) {
            return Core.isSubtype(cx, qualifiers, t22) && Core.isSubtype(cx, params, t02) && Core.isSubtype(cx, rets, t110) || FunctionOps.functionPathIsEmpty(cx, rets, params, qualifiers, pos, neg.next);
        }
        return Core.isSubtype(cx, qualifiers, t22) && Core.isSubtype(cx, t02, params) && FunctionOps.functionPhi(cx, t02, Core.complement(t110), pos) || FunctionOps.functionPathIsEmpty(cx, rets, params, qualifiers, pos, neg.next);
    }

    private static boolean functionPhi(Context cx, SemType t02, SemType t110, Conjunction pos) {
        if (pos == null) {
            return !Core.isNever(t02) && (Core.isEmpty(cx, t02) || Core.isEmpty(cx, t110));
        }
        return FunctionOps.functionPhiInner(cx, t02, t110, pos);
    }

    private static boolean functionPhiInner(Context cx, SemType t02, SemType t110, Conjunction pos) {
        if (pos == null) {
            return Core.isEmpty(cx, t02) || Core.isEmpty(cx, t110);
        }
        FunctionAtomicType s = cx.functionAtomType(pos.atom);
        SemType s02 = s.paramType();
        SemType s110 = s.retType();
        return (Core.isSubtype(cx, t02, s02) || Core.isSubtype(cx, FunctionOps.functionIntersectRet(cx, pos.next), Core.complement(t110))) && FunctionOps.functionPhiInner(cx, t02, Core.intersect(t110, s110), pos.next) && FunctionOps.functionPhiInner(cx, Core.diff(t02, s02), t110, pos.next);
    }

    private static SemType functionUnionParams(Context cx, Conjunction pos) {
        if (pos == null) {
            return PredefinedType.NEVER;
        }
        return Core.union(cx.functionAtomType(pos.atom).paramType(), FunctionOps.functionUnionParams(cx, pos.next));
    }

    private static SemType functionUnionQualifiers(Context cx, Conjunction pos) {
        if (pos == null) {
            return PredefinedType.NEVER;
        }
        return Core.union(cx.functionAtomType(pos.atom).qualifiers(), FunctionOps.functionUnionQualifiers(cx, pos.next));
    }

    private static SemType functionIntersectRet(Context cx, Conjunction pos) {
        if (pos == null) {
            return PredefinedType.VAL;
        }
        return Core.intersect(cx.functionAtomType(pos.atom).retType(), FunctionOps.functionIntersectRet(cx, pos.next));
    }

    private boolean functionTheta(Context cx, SemType t02, SemType t110, Conjunction pos) {
        if (pos == null) {
            return Core.isEmpty(cx, t02) || Core.isEmpty(cx, t110);
        }
        FunctionAtomicType s = cx.functionAtomType(pos.atom);
        SemType s02 = s.paramType();
        SemType s110 = s.retType();
        return !(!Core.isSubtype(cx, t02, s02) && !this.functionTheta(cx, Core.diff(s02, t02), s110, pos.next) || !Core.isSubtype(cx, t110, Core.complement(s110)) && !this.functionTheta(cx, s02, Core.intersect(s110, t110), pos.next));
    }
}

