/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.typeops;

import io.ballerina.types.BasicTypeOps;
import io.ballerina.types.Bdd;
import io.ballerina.types.CellSemType;
import io.ballerina.types.Common;
import io.ballerina.types.Conjunction;
import io.ballerina.types.Context;
import io.ballerina.types.Core;
import io.ballerina.types.Env;
import io.ballerina.types.MappingAtomicType;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.BddAllOrNothing;
import io.ballerina.types.subtypedata.BddNode;
import io.ballerina.types.subtypedata.StringSubtype;
import io.ballerina.types.typeops.CommonOps;
import io.ballerina.types.typeops.FieldPair;
import io.ballerina.types.typeops.FieldPairs;
import io.ballerina.types.typeops.StringOps;
import java.util.ArrayList;
import java.util.List;

public class MappingOps
extends CommonOps
implements BasicTypeOps {
    static boolean mappingFormulaIsEmpty(Context cx, Conjunction posList, Conjunction negList) {
        MappingAtomicType combined;
        if (posList == null) {
            combined = PredefinedType.MAPPING_ATOMIC_INNER;
        } else {
            combined = cx.mappingAtomType(posList.atom);
            Conjunction p = posList.next;
            while (p != null) {
                MappingAtomicType m = MappingOps.intersectMapping(cx.env, combined, cx.mappingAtomType(p.atom));
                if (m == null) {
                    return true;
                }
                combined = m;
                p = p.next;
            }
            for (CellSemType t : combined.types()) {
                if (!Core.isEmpty(cx, t)) continue;
                return true;
            }
        }
        if (!MappingOps.mappingInhabitedFast(cx, combined, negList)) {
            assert (!MappingOps.mappingInhabited(cx, combined, negList));
            return true;
        }
        return !MappingOps.mappingInhabited(cx, combined, negList);
    }

    private static boolean mappingInhabitedFast(Context cx, MappingAtomicType pos, Conjunction negList) {
        if (negList == null) {
            return true;
        }
        MappingAtomicType neg = cx.mappingAtomType(negList.atom);
        FieldPairs pairing = new FieldPairs(pos, neg);
        if (!Core.isEmpty(cx, Core.diff(pos.rest(), neg.rest()))) {
            return MappingOps.mappingInhabitedFast(cx, pos, negList.next);
        }
        for (FieldPair fieldPair : pairing) {
            SemType intersect = Core.intersect(fieldPair.type1(), fieldPair.type2());
            if (Core.isEmpty(cx, intersect)) {
                return MappingOps.mappingInhabitedFast(cx, pos, negList.next);
            }
            CellSemType d = (CellSemType)Core.diff(fieldPair.type1(), fieldPair.type2());
            if (Core.isEmpty(cx, d)) continue;
            return MappingOps.mappingInhabitedFast(cx, pos, negList.next);
        }
        return false;
    }

    private static boolean mappingInhabited(Context cx, MappingAtomicType pos, Conjunction negList) {
        if (negList == null) {
            return true;
        }
        MappingAtomicType neg = cx.mappingAtomType(negList.atom);
        FieldPairs pairing = new FieldPairs(pos, neg);
        if (!Core.isEmpty(cx, Core.diff(pos.rest(), neg.rest()))) {
            return MappingOps.mappingInhabited(cx, pos, negList.next);
        }
        for (FieldPair fieldPair : pairing) {
            MappingAtomicType mt;
            SemType intersect = Core.intersect(fieldPair.type1(), fieldPair.type2());
            if (Core.isEmpty(cx, intersect)) {
                return MappingOps.mappingInhabited(cx, pos, negList.next);
            }
            CellSemType d = (CellSemType)Core.diff(fieldPair.type1(), fieldPair.type2());
            if (Core.isEmpty(cx, d)) continue;
            if (fieldPair.index1() == null) {
                mt = MappingOps.insertField(pos, fieldPair.name(), d);
            } else {
                CellSemType[] posTypes = pos.types();
                posTypes[fieldPair.index1().intValue()] = d;
                mt = MappingAtomicType.from(pos.names(), posTypes, pos.rest());
            }
            if (!MappingOps.mappingInhabited(cx, mt, negList.next)) continue;
            return true;
        }
        return false;
    }

    private static MappingAtomicType insertField(MappingAtomicType m, String name, CellSemType t) {
        String[] orgNames = m.names();
        String[] names = Common.shallowCopyStrings(orgNames, orgNames.length + 1);
        CellSemType[] orgTypes = m.types();
        CellSemType[] types2 = Common.shallowCopyCellTypes(orgTypes, orgTypes.length + 1);
        int i = orgNames.length;
        while (true) {
            if (i == 0 || Common.codePointCompare(names[i - 1], name)) break;
            names[i] = names[i - 1];
            types2[i] = types2[i - 1];
            --i;
        }
        names[i] = name;
        types2[i] = t;
        return MappingAtomicType.from(names, types2, m.rest());
    }

    private static MappingAtomicType intersectMapping(Env env, MappingAtomicType m12, MappingAtomicType m22) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<CellSemType> types2 = new ArrayList<CellSemType>();
        FieldPairs pairing = new FieldPairs(m12, m22);
        for (FieldPair fieldPair : pairing) {
            names.add(fieldPair.name());
            CellSemType t = Core.intersectMemberSemTypes(env, fieldPair.type1(), fieldPair.type2());
            if (Core.isNever(Core.cellInner(fieldPair.type1()))) {
                return null;
            }
            types2.add(t);
        }
        CellSemType rest = Core.intersectMemberSemTypes(env, m12.rest(), m22.rest());
        return MappingAtomicType.from(names.toArray(new String[0]), types2.toArray(new CellSemType[0]), rest);
    }

    public static boolean mappingSubtypeIsEmpty(Context cx, SubtypeData t) {
        return Common.memoSubtypeIsEmpty(cx, cx.mappingMemo, (context, bdd) -> Common.bddEvery(context, bdd, null, null, MappingOps::mappingFormulaIsEmpty), (Bdd)t);
    }

    public static SemType bddMappingMemberTypeInner(Context cx, Bdd b, SubtypeData key, SemType accum) {
        if (b instanceof BddAllOrNothing) {
            BddAllOrNothing allOrNothing = (BddAllOrNothing)b;
            return allOrNothing.isAll() ? accum : PredefinedType.NEVER;
        }
        BddNode bdd = (BddNode)b;
        return Core.union(MappingOps.bddMappingMemberTypeInner(cx, bdd.left(), key, Core.intersect(MappingOps.mappingAtomicMemberTypeInner(cx.mappingAtomType(bdd.atom()), key), accum)), Core.union(MappingOps.bddMappingMemberTypeInner(cx, bdd.middle(), key, accum), MappingOps.bddMappingMemberTypeInner(cx, bdd.right(), key, accum)));
    }

    static SemType mappingAtomicMemberTypeInner(MappingAtomicType atomic, SubtypeData key) {
        SemType memberType = null;
        for (SemType ty : MappingOps.mappingAtomicApplicableMemberTypesInner(atomic, key)) {
            if (memberType == null) {
                memberType = ty;
                continue;
            }
            memberType = Core.union(memberType, ty);
        }
        return memberType == null ? PredefinedType.UNDEF : memberType;
    }

    static List<SemType> mappingAtomicApplicableMemberTypesInner(MappingAtomicType atomic, SubtypeData key) {
        ArrayList<SemType> types2 = new ArrayList<SemType>(atomic.types().length);
        for (CellSemType t : atomic.types()) {
            types2.add(Core.cellInner(t));
        }
        ArrayList<SemType> memberTypes = new ArrayList<SemType>();
        SemType rest = Core.cellInner(atomic.rest());
        if (Common.isAllSubtype(key)) {
            memberTypes.addAll(types2);
            memberTypes.add(rest);
        } else {
            StringSubtype.StringSubtypeListCoverage coverage = StringOps.stringSubtypeListCoverage((StringSubtype)key, atomic.names());
            for (int index : coverage.indices) {
                memberTypes.add((SemType)types2.get(index));
            }
            if (!coverage.isSubtype) {
                memberTypes.add(rest);
            }
        }
        return memberTypes;
    }

    @Override
    public SubtypeData union(SubtypeData d1, SubtypeData d2) {
        return Common.bddSubtypeUnion(d1, d2);
    }

    @Override
    public SubtypeData intersect(SubtypeData d1, SubtypeData d2) {
        return Common.bddSubtypeIntersect(d1, d2);
    }

    @Override
    public SubtypeData diff(SubtypeData d1, SubtypeData d2) {
        return Common.bddSubtypeDiff(d1, d2);
    }

    @Override
    public SubtypeData complement(SubtypeData d) {
        return Common.bddSubtypeComplement(d);
    }

    @Override
    public boolean isEmpty(Context cx, SubtypeData d) {
        return MappingOps.mappingSubtypeIsEmpty(cx, d);
    }
}

