/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.typeops;

import io.ballerina.types.BasicTypeOps;
import io.ballerina.types.Bdd;
import io.ballerina.types.Common;
import io.ballerina.types.Conjunction;
import io.ballerina.types.Context;
import io.ballerina.types.RecAtom;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.BddAllOrNothing;
import io.ballerina.types.subtypedata.XmlSubtype;
import io.ballerina.types.typeops.BddCommonOps;

public class XmlOps
implements BasicTypeOps {
    public static final XmlSubtype XML_SUBTYPE_RO = XmlSubtype.from(31, BddCommonOps.bddAtom(RecAtom.createXMLRecAtom(30)));
    public static final XmlSubtype XML_SUBTYPE_TOP = XmlSubtype.from(255, BddAllOrNothing.bddAll());

    @Override
    public SubtypeData union(SubtypeData d1, SubtypeData d2) {
        XmlSubtype v1 = (XmlSubtype)d1;
        XmlSubtype v2 = (XmlSubtype)d2;
        int primitives = v1.primitives | v2.primitives;
        return XmlSubtype.createXmlSubtype(primitives, BddCommonOps.bddUnion(v1.sequence, v2.sequence));
    }

    @Override
    public SubtypeData intersect(SubtypeData d1, SubtypeData d2) {
        XmlSubtype v1 = (XmlSubtype)d1;
        XmlSubtype v2 = (XmlSubtype)d2;
        int primitives = v1.primitives & v2.primitives;
        return XmlSubtype.createXmlSubtypeOrEmpty(primitives, BddCommonOps.bddIntersect(v1.sequence, v2.sequence));
    }

    @Override
    public SubtypeData diff(SubtypeData d1, SubtypeData d2) {
        XmlSubtype v1 = (XmlSubtype)d1;
        XmlSubtype v2 = (XmlSubtype)d2;
        int primitives = v1.primitives & ~v2.primitives;
        return XmlSubtype.createXmlSubtypeOrEmpty(primitives, BddCommonOps.bddDiff(v1.sequence, v2.sequence));
    }

    @Override
    public SubtypeData complement(SubtypeData d) {
        return this.diff(XML_SUBTYPE_TOP, d);
    }

    @Override
    public boolean isEmpty(Context cx, SubtypeData t) {
        XmlSubtype sd = (XmlSubtype)t;
        if (sd.primitives != 0) {
            return false;
        }
        return this.xmlBddEmpty(cx, sd.sequence);
    }

    boolean xmlBddEmpty(Context cx, Bdd bdd) {
        return Common.bddEvery(cx, bdd, null, null, XmlOps::xmlFormulaIsEmpty);
    }

    private static boolean xmlFormulaIsEmpty(Context cx, Conjunction pos, Conjunction neg) {
        int allPosBits = XmlOps.collectAllPrimitives(pos) & 0xFF;
        return XmlOps.xmlHasTotalNegative(allPosBits, neg);
    }

    public static int collectAllPrimitives(Conjunction con) {
        int bits = 0;
        Conjunction current = con;
        while (current != null) {
            bits &= XmlOps.getIndex(current);
            current = current.next;
        }
        return bits;
    }

    public static boolean xmlHasTotalNegative(int allBits, Conjunction con) {
        if (allBits == 0) {
            return true;
        }
        Conjunction n = con;
        while (n != null) {
            if ((allBits & ~XmlOps.getIndex(con)) == 0) {
                return true;
            }
            n = n.next;
        }
        return false;
    }

    private static int getIndex(Conjunction con) {
        return ((RecAtom)con.atom).index;
    }
}

