/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.c14n.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class UtfHelper {
    static final void writeByte(String str, OutputStream out, Map cache) throws IOException {
        byte[] result = (byte[])cache.get(str);
        if (result == null) {
            result = UtfHelper.getStringInUtf8(str);
            cache.put(str, result);
        }
        out.write(result);
    }

    static final void writeCharToUtf8(char c, OutputStream out) throws IOException {
        int bias;
        int write;
        char ch;
        if (c < '\u0080') {
            out.write(c);
            return;
        }
        if (c >= '\ud800' && c <= '\udbff' || c >= '\udc00' && c <= '\udfff') {
            out.write(63);
            return;
        }
        if (c > '\u07ff') {
            ch = (char)(c >>> 12);
            write = 224;
            if (ch > '\u0000') {
                write |= ch & 0xF;
            }
            out.write(write);
            write = 128;
            bias = 63;
        } else {
            write = 192;
            bias = 31;
        }
        ch = (char)(c >>> 6);
        if (ch > '\u0000') {
            write |= ch & bias;
        }
        out.write(write);
        out.write(0x80 | c & 0x3F);
    }

    static final void writeStringToUtf8(String str, OutputStream out) throws IOException {
        int length2 = str.length();
        int i = 0;
        while (i < length2) {
            int bias;
            int write;
            char ch;
            char c;
            if ((c = str.charAt(i++)) < '\u0080') {
                out.write(c);
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff' || c >= '\udc00' && c <= '\udfff') {
                out.write(63);
                continue;
            }
            if (c > '\u07ff') {
                ch = (char)(c >>> 12);
                write = 224;
                if (ch > '\u0000') {
                    write |= ch & 0xF;
                }
                out.write(write);
                write = 128;
                bias = 63;
            } else {
                write = 192;
                bias = 31;
            }
            ch = (char)(c >>> 6);
            if (ch > '\u0000') {
                write |= ch & bias;
            }
            out.write(write);
            out.write(0x80 | c & 0x3F);
        }
    }

    public static final byte[] getStringInUtf8(String str) {
        int length2 = str.length();
        boolean expanded = false;
        byte[] result = new byte[length2];
        int i = 0;
        int out = 0;
        while (i < length2) {
            int bias;
            int write;
            char c;
            if ((c = str.charAt(i++)) < '\u0080') {
                result[out++] = (byte)c;
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff' || c >= '\udc00' && c <= '\udfff') {
                result[out++] = 63;
                continue;
            }
            if (!expanded) {
                byte[] newResult = new byte[3 * length2];
                System.arraycopy(result, 0, newResult, 0, out);
                result = newResult;
                expanded = true;
            }
            if (c > '\u07ff') {
                char ch = (char)(c >>> 12);
                write = -32;
                if (ch > '\u0000') {
                    write = (byte)(write | ch & 0xF);
                }
                result[out++] = write;
                write = -128;
                bias = 63;
            } else {
                write = -64;
                bias = 31;
            }
            char ch = (char)(c >>> 6);
            if (ch > '\u0000') {
                write = (byte)(write | ch & bias);
            }
            result[out++] = write;
            result[out++] = (byte)(0x80 | c & 0x3F);
        }
        if (expanded) {
            byte[] newResult = new byte[out];
            System.arraycopy(result, 0, newResult, 0, out);
            result = newResult;
        }
        return result;
    }
}

