/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.impl.builder;

import org.apache.axiom.core.Builder;
import org.apache.axiom.core.CoreCDATASection;
import org.apache.axiom.core.CoreCharacterDataNode;
import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreComment;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreDocumentTypeDeclaration;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreEntityReference;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreModelStreamException;
import org.apache.axiom.core.CoreNSAwareAttribute;
import org.apache.axiom.core.CoreNSAwareElement;
import org.apache.axiom.core.CoreNSUnawareAttribute;
import org.apache.axiom.core.CoreNamespaceDeclaration;
import org.apache.axiom.core.CoreParentNode;
import org.apache.axiom.core.CoreProcessingInstruction;
import org.apache.axiom.core.InputContext;
import org.apache.axiom.core.impl.builder.BuilderHandler;
import org.apache.axiom.core.impl.builder.Context;
import org.apache.axiom.core.stream.NullXmlHandler;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;

final class BuildableContext
extends Context
implements InputContext {
    private final Context parentContext;
    private CoreParentNode target;
    private Object pendingCharacterData;
    private XmlHandler passThroughHandler;
    private int passThroughDepth;

    BuildableContext(BuilderHandler builderHandler, Context parentContext, int depth) {
        super(builderHandler, depth);
        this.parentContext = parentContext;
    }

    void init(CoreParentNode target) {
        this.target = target;
    }

    @Override
    public Builder getBuilder() {
        return this.builderHandler.builder;
    }

    @Override
    public void setPassThroughHandler(XmlHandler passThroughHandler) {
        if (this.passThroughHandler != null) {
            throw new IllegalStateException("A pass-through handler has already been set for this context");
        }
        this.target.coreSetState(3);
        this.passThroughHandler = passThroughHandler;
        if (passThroughHandler == NullXmlHandler.INSTANCE) {
            this.builderHandler.decrementActiveContextCount();
        }
    }

    @Override
    public void setTarget(CoreParentNode target) {
        this.target = target;
    }

    @Override
    public void discard() {
        this.target.coreSetState(3);
        this.passThroughHandler = NullXmlHandler.INSTANCE;
        this.builderHandler.decrementActiveContextCount();
    }

    private Context endContext() throws StreamException {
        this.target.coreSetInputContext(null);
        if (this.pendingCharacterData != null) {
            try {
                this.target.coreSetCharacterData(this.pendingCharacterData, null);
            }
            catch (CoreModelException ex) {
                throw new CoreModelStreamException(ex);
            }
            this.pendingCharacterData = null;
        }
        this.target = null;
        this.builderHandler.decrementActiveContextCount();
        return this.parentContext;
    }

    private Context decrementPassThroughDepth() {
        if (this.passThroughDepth == 0) {
            if (this.passThroughHandler != NullXmlHandler.INSTANCE) {
                this.builderHandler.decrementActiveContextCount();
            }
            this.target.coreSetInputContext(null);
            this.passThroughHandler = null;
            this.target = null;
            return this.parentContext;
        }
        --this.passThroughDepth;
        return this;
    }

    private void addChild(CoreChildNode node) {
        if (this.pendingCharacterData != null) {
            CoreCharacterDataNode cdataNode = this.builderHandler.nodeFactory.createCharacterDataNode();
            cdataNode.coreSetCharacterData(this.pendingCharacterData);
            this.target.internalAppendChildWithoutBuild(cdataNode);
            this.pendingCharacterData = null;
        }
        this.target.internalAppendChildWithoutBuild(node);
        if (!(node instanceof CoreCharacterDataNode)) {
            this.builderHandler.nodeAdded(node);
        }
    }

    @Override
    void startDocument(String inputEncoding, String xmlVersion, String xmlEncoding, Boolean standalone) {
        CoreDocument document = this.builderHandler.model.createDocument();
        if (document == null) {
            document = this.builderHandler.nodeFactory.createDocument();
        }
        document.coreSetInputEncoding(inputEncoding);
        document.coreSetXmlVersion(xmlVersion);
        document.coreSetXmlEncoding(xmlEncoding);
        document.coreSetStandalone(standalone);
        document.coreSetInputContext(this);
        this.builderHandler.nodeAdded(document);
        this.target = document;
    }

    @Override
    void startFragment() {
        this.startDocument(null, "1.0", null, true);
    }

    @Override
    void processDocumentTypeDeclaration(String rootName, String publicId, String systemId, String internalSubset) throws StreamException {
        if (this.passThroughHandler != null) {
            this.passThroughHandler.processDocumentTypeDeclaration(rootName, publicId, systemId, internalSubset);
        } else {
            CoreDocumentTypeDeclaration node = this.builderHandler.nodeFactory.createDocumentTypeDeclaration();
            node.coreSetRootName(rootName);
            node.coreSetPublicId(publicId);
            node.coreSetSystemId(systemId);
            node.coreSetInternalSubset(internalSubset);
            this.addChild(node);
        }
    }

    @Override
    Context startElement(String namespaceURI, String localName, String prefix) throws StreamException {
        if (this.passThroughHandler != null) {
            ++this.passThroughDepth;
            this.passThroughHandler.startElement(namespaceURI, localName, prefix);
            return this;
        }
        CoreNSAwareElement element = this.builderHandler.model.createElement(this.target, this.depth + 1, namespaceURI, localName);
        if (element == null) {
            element = this.builderHandler.nodeFactory.createNSAwareElement();
        }
        element.coreSetState(1);
        element.initName(namespaceURI, localName, prefix, this.builderHandler.namespaceHelper);
        this.addChild(element);
        return this.newContext(element);
    }

    @Override
    Context endElement() throws StreamException {
        if (this.passThroughHandler != null) {
            this.passThroughHandler.endElement();
            return this.decrementPassThroughDepth();
        }
        return this.endContext();
    }

    @Override
    void processAttribute(String namespaceURI, String localName, String prefix, String value2, String type, boolean specified) throws StreamException {
        if (this.passThroughHandler != null) {
            this.passThroughHandler.processAttribute(namespaceURI, localName, prefix, value2, type, specified);
        } else {
            CoreNSAwareAttribute attr = this.builderHandler.nodeFactory.createNSAwareAttribute();
            attr.initName(namespaceURI, localName, prefix, this.builderHandler.namespaceHelper);
            try {
                attr.coreSetCharacterData(value2, null);
            }
            catch (CoreModelException ex) {
                throw new CoreModelStreamException(ex);
            }
            attr.coreSetType(type);
            attr.coreSetSpecified(specified);
            ((CoreElement)this.target).coreAppendAttribute(attr);
        }
    }

    @Override
    void processAttribute(String name, String value2, String type, boolean specified) throws StreamException {
        if (this.passThroughHandler != null) {
            this.passThroughHandler.processAttribute(name, value2, type, specified);
        } else {
            CoreNSUnawareAttribute attr = this.builderHandler.nodeFactory.createNSUnawareAttribute();
            attr.coreSetName(name);
            try {
                attr.coreSetCharacterData(value2, null);
            }
            catch (CoreModelException ex) {
                throw new CoreModelStreamException(ex);
            }
            attr.coreSetType(type);
            attr.coreSetSpecified(specified);
            ((CoreElement)this.target).coreAppendAttribute(attr);
        }
    }

    @Override
    void processNamespaceDeclaration(String prefix, String namespaceURI) throws StreamException {
        if (this.passThroughHandler != null) {
            this.passThroughHandler.processNamespaceDeclaration(prefix, namespaceURI);
        } else {
            CoreNamespaceDeclaration decl = this.builderHandler.nodeFactory.createNamespaceDeclaration();
            decl.init(prefix, namespaceURI, this.builderHandler.namespaceHelper);
            ((CoreElement)this.target).coreAppendAttribute(decl);
        }
    }

    @Override
    void attributesCompleted() throws StreamException {
        if (this.passThroughHandler != null) {
            this.passThroughHandler.attributesCompleted();
        } else {
            this.target.coreSetState(2);
        }
    }

    @Override
    void processCharacterData(Object data2, boolean ignorable) throws StreamException {
        if (this.passThroughHandler != null) {
            this.passThroughHandler.processCharacterData(data2, ignorable);
        } else if (!ignorable && this.pendingCharacterData == null && this.target.coreGetFirstChildIfAvailable() == null) {
            this.pendingCharacterData = data2;
        } else {
            CoreCharacterDataNode node = this.builderHandler.nodeFactory.createCharacterDataNode();
            node.coreSetCharacterData(data2);
            node.coreSetIgnorable(ignorable);
            this.addChild(node);
        }
    }

    @Override
    Context startProcessingInstruction(String piTarget) throws StreamException {
        if (this.passThroughHandler != null) {
            ++this.passThroughDepth;
            this.passThroughHandler.startProcessingInstruction(piTarget);
            return this;
        }
        CoreProcessingInstruction node = this.builderHandler.nodeFactory.createProcessingInstruction();
        node.coreSetTarget(piTarget);
        this.addChild(node);
        return this.newContext(node);
    }

    @Override
    Context endProcessingInstruction() throws StreamException {
        if (this.passThroughHandler != null) {
            this.passThroughHandler.endProcessingInstruction();
            return this.decrementPassThroughDepth();
        }
        return this.endContext();
    }

    @Override
    Context startComment() throws StreamException {
        if (this.passThroughHandler != null) {
            ++this.passThroughDepth;
            this.passThroughHandler.startComment();
            return this;
        }
        CoreComment node = this.builderHandler.nodeFactory.createComment();
        this.addChild(node);
        return this.newContext(node);
    }

    @Override
    Context endComment() throws StreamException {
        if (this.passThroughHandler != null) {
            this.passThroughHandler.endComment();
            return this.decrementPassThroughDepth();
        }
        return this.endContext();
    }

    @Override
    Context startCDATASection() throws StreamException {
        if (this.passThroughHandler != null) {
            ++this.passThroughDepth;
            this.passThroughHandler.startCDATASection();
            return this;
        }
        CoreCDATASection node = this.builderHandler.nodeFactory.createCDATASection();
        this.addChild(node);
        return this.newContext(node);
    }

    @Override
    Context endCDATASection() throws StreamException {
        if (this.passThroughHandler != null) {
            this.passThroughHandler.endCDATASection();
            return this.decrementPassThroughDepth();
        }
        return this.endContext();
    }

    @Override
    void processEntityReference(String name, String replacementText) throws StreamException {
        if (this.passThroughHandler != null) {
            this.passThroughHandler.processEntityReference(name, replacementText);
        } else {
            CoreEntityReference node = this.builderHandler.nodeFactory.createEntityReference();
            node.coreSetName(name);
            node.coreSetReplacementText(replacementText);
            this.addChild(node);
        }
    }

    @Override
    void completed() throws StreamException {
        if (this.passThroughHandler != null) {
            this.passThroughHandler.completed();
            this.decrementPassThroughDepth();
        } else {
            if (this.depth != 0) {
                throw new IllegalStateException();
            }
            if (this.target != null) {
                this.target.coreSetState(0);
                this.target.coreSetInputContext(null);
            }
            this.target = null;
        }
    }
}

