/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.impl.mixin;

import java.util.Iterator;
import org.apache.axiom.core.AttributeMatcher;
import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNamespaceDeclaration;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.Mapper;
import org.apache.axiom.core.Semantics;
import org.apache.axiom.core.impl.AttributeIterator;
import org.apache.axiom.weaver.annotation.Mixin;

@Mixin
public abstract class CoreElementMixin
implements CoreElement {
    private CoreAttribute firstAttribute;

    @Override
    public final CoreAttribute coreGetFirstAttribute() {
        this.forceExpand();
        return this.firstAttribute;
    }

    @Override
    public final void internalSetFirstAttribute(CoreAttribute firstAttribute) {
        this.firstAttribute = firstAttribute;
    }

    @Override
    public final CoreAttribute coreGetLastAttribute() {
        CoreAttribute previousAttribute = null;
        for (CoreAttribute attribute = this.firstAttribute; attribute != null; attribute = attribute.coreGetNextAttribute()) {
            previousAttribute = attribute;
        }
        return previousAttribute;
    }

    @Override
    public final CoreAttribute coreGetAttribute(AttributeMatcher matcher, String namespaceURI, String name) {
        CoreAttribute attr;
        for (attr = this.coreGetFirstAttribute(); attr != null && !matcher.matches(attr, namespaceURI, name); attr = attr.coreGetNextAttribute()) {
        }
        return attr;
    }

    @Override
    public final void coreAppendAttribute(CoreAttribute attr) {
        attr.internalRemove(null, this);
        CoreAttribute lastAttribute = this.coreGetLastAttribute();
        if (lastAttribute == null) {
            this.firstAttribute = attr;
        } else {
            lastAttribute.internalSetNextAttribute(attr);
        }
    }

    @Override
    public final void coreSetAttribute(AttributeMatcher matcher, String namespaceURI, String name, String prefix, String value2) throws CoreModelException {
        CoreAttribute attr;
        CoreAttribute previousAttr = null;
        for (attr = this.firstAttribute; attr != null && !matcher.matches(attr, namespaceURI, name); attr = attr.coreGetNextAttribute()) {
            previousAttr = attr;
        }
        if (attr == null) {
            CoreAttribute newAttr = matcher.createAttribute(this.coreGetNodeFactory().getFactory2(), namespaceURI, name, prefix, value2);
            if (previousAttr == null) {
                this.coreAppendAttribute(newAttr);
            } else {
                previousAttr.internalInsertAttributeAfter(newAttr);
            }
        } else {
            matcher.update(attr, prefix, value2);
        }
    }

    @Override
    public final CoreAttribute coreSetAttribute(AttributeMatcher matcher, CoreAttribute attr, Semantics semantics) {
        CoreAttribute existingAttr;
        if (attr.coreGetOwnerElement() == this) {
            return attr;
        }
        attr.internalRemove(null, this);
        String namespaceURI = matcher.getNamespaceURI(attr);
        String name = matcher.getName(attr);
        CoreAttribute previousAttr = null;
        for (existingAttr = this.coreGetFirstAttribute(); existingAttr != null && !matcher.matches(existingAttr, namespaceURI, name); existingAttr = existingAttr.coreGetNextAttribute()) {
            previousAttr = existingAttr;
        }
        if (existingAttr == null) {
            if (previousAttr == null) {
                this.firstAttribute = attr;
            } else {
                previousAttr.internalSetNextAttribute(attr);
            }
        } else {
            if (previousAttr == null) {
                this.firstAttribute = attr;
            } else {
                previousAttr.internalSetNextAttribute(attr);
            }
            existingAttr.internalUnsetOwnerElement(semantics.getDetachPolicy().getNewOwnerDocument(this));
            attr.internalSetNextAttribute(existingAttr.coreGetNextAttribute());
            existingAttr.internalSetNextAttribute(null);
        }
        return existingAttr;
    }

    @Override
    public final boolean coreRemoveAttribute(AttributeMatcher matcher, String namespaceURI, String name, Semantics semantics) {
        CoreAttribute att = this.coreGetAttribute(matcher, namespaceURI, name);
        if (att != null) {
            att.coreRemove(semantics);
            return true;
        }
        return false;
    }

    @Override
    public final <T extends CoreAttribute, S> Iterator<S> coreGetAttributesByType(Class<T> type, Mapper<S, ? super T> mapper, Semantics semantics) {
        return AttributeIterator.create(this, type, mapper, semantics);
    }

    @Override
    public final String coreLookupNamespaceURI(String prefix, Semantics semantics) throws CoreModelException {
        String namespaceURI;
        if (!semantics.isUseStrictNamespaceLookup() && (namespaceURI = this.getImplicitNamespaceURI(prefix)) != null) {
            return namespaceURI;
        }
        for (CoreAttribute attr = this.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
            CoreNamespaceDeclaration decl;
            if (!(attr instanceof CoreNamespaceDeclaration) || !prefix.equals((decl = (CoreNamespaceDeclaration)attr).coreGetDeclaredPrefix())) continue;
            return decl.coreGetCharacterData().toString();
        }
        CoreElement parentElement = this.coreGetParentElement();
        if (parentElement != null) {
            return parentElement.coreLookupNamespaceURI(prefix, semantics);
        }
        if (prefix.length() == 0) {
            return "";
        }
        return null;
    }

    @Override
    public final String coreLookupPrefix(String namespaceURI, Semantics semantics) throws CoreModelException {
        String prefix;
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI must not be null");
        }
        if (!semantics.isUseStrictNamespaceLookup() && (prefix = this.getImplicitPrefix(namespaceURI)) != null) {
            return prefix;
        }
        for (CoreAttribute attr = this.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
            CoreNamespaceDeclaration decl;
            if (!(attr instanceof CoreNamespaceDeclaration) || !(decl = (CoreNamespaceDeclaration)attr).coreGetCharacterData().toString().equals(namespaceURI)) continue;
            return decl.coreGetDeclaredPrefix();
        }
        CoreElement parentElement = this.coreGetParentElement();
        if (parentElement != null) {
            String prefix2 = parentElement.coreLookupPrefix(namespaceURI, semantics);
            if (!semantics.isUseStrictNamespaceLookup() && this.getImplicitNamespaceURI(prefix2) != null) {
                return null;
            }
            for (CoreAttribute attr = this.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
                CoreNamespaceDeclaration decl;
                if (!(attr instanceof CoreNamespaceDeclaration) || !(decl = (CoreNamespaceDeclaration)attr).coreGetDeclaredPrefix().equals(prefix2)) continue;
                return null;
            }
            return prefix2;
        }
        return null;
    }

    @Override
    public final <T> void init(ClonePolicy<T> policy, T options, CoreNode other) throws CoreModelException {
        CoreElement o = (CoreElement)other;
        this.initSource(policy, options, o);
        this.initName(o);
        if (this.isExpanded()) {
            for (CoreAttribute attr = o.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
                this.coreAppendAttribute((CoreAttribute)attr.coreClone(policy, options));
            }
        }
    }

    public <T> void initSource(ClonePolicy<T> policy, T options, CoreElement other) {
    }

    @Override
    public final void corePromote(CoreElement newElement, Semantics semantics) throws CoreModelException {
        newElement.initName(this);
        newElement.internalSetFirstAttribute(this.firstAttribute);
        for (CoreAttribute attr = this.firstAttribute; attr != null; attr = attr.coreGetNextAttribute()) {
            attr.internalSetOwnerElement(newElement);
        }
        this.firstAttribute = null;
        newElement.coreMoveChildrenFrom(this, semantics);
        this.coreReplaceWith(newElement, semantics);
    }
}

