/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.stream.serializer.writer;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.axiom.core.stream.serializer.writer.XmlWriter;
import org.apache.axiom.util.base64.AbstractBase64EncodingOutputStream;

abstract class ASCIICompatibleXmlWriter
extends XmlWriter {
    private final OutputStream out;
    final byte[] buffer = new byte[4096];
    int bufferPosition;
    private char highSurrogate;

    ASCIICompatibleXmlWriter(OutputStream out) {
        this.out = out;
    }

    protected abstract void writeNonASCIICharacter(int var1) throws IOException;

    protected final void writeByte(byte b) throws IOException {
        if (this.bufferPosition == this.buffer.length) {
            this.flushBuffer();
        }
        this.buffer[this.bufferPosition++] = b;
    }

    @Override
    public final void write(char c) throws IOException {
        if (c < '\u0080' && this.highSurrogate == '\u0000') {
            if (this.bufferPosition == this.buffer.length) {
                this.flushBuffer();
            }
            this.buffer[this.bufferPosition++] = (byte)c;
        } else {
            this.internalWrite(c);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void internalWrite(char c) throws IOException {
        if (this.highSurrogate != '\u0000') {
            if (!Character.isLowSurrogate(c)) throw new IOException("Invalid surrogate pair");
            int codePoint = Character.toCodePoint(this.highSurrogate, c);
            this.highSurrogate = '\u0000';
            this.writeNonASCIICharacter(codePoint);
            return;
        } else if (Character.isHighSurrogate(c)) {
            this.highSurrogate = c;
            return;
        } else {
            if (Character.isLowSurrogate(c)) {
                throw new IOException("Invalid surrogate pair");
            }
            this.writeNonASCIICharacter(c);
        }
    }

    @Override
    public final void write(String s) throws IOException {
        byte[] buffer = this.buffer;
        int bufferLength = buffer.length;
        int bufferPosition = this.bufferPosition;
        char highSurrogate = this.highSurrogate;
        int length2 = s.length();
        for (int i = 0; i < length2; ++i) {
            char c = s.charAt(i);
            if (c < '\u0080' && highSurrogate == '\u0000') {
                if (bufferPosition == bufferLength) {
                    this.out.write(buffer, 0, bufferLength);
                    bufferPosition = 0;
                }
                buffer[bufferPosition++] = (byte)c;
                continue;
            }
            this.bufferPosition = bufferPosition;
            this.internalWrite(c);
            bufferPosition = this.bufferPosition;
            highSurrogate = this.highSurrogate;
        }
        this.bufferPosition = bufferPosition;
    }

    @Override
    public final void write(char[] chars, int start, int length2) throws IOException {
        byte[] buffer = this.buffer;
        int bufferLength = buffer.length;
        int bufferPosition = this.bufferPosition;
        char highSurrogate = this.highSurrogate;
        for (int i = 0; i < length2; ++i) {
            char c = chars[start + i];
            if (c < '\u0080' && highSurrogate == '\u0000') {
                if (bufferPosition == bufferLength) {
                    this.out.write(buffer, 0, bufferLength);
                    bufferPosition = 0;
                }
                buffer[bufferPosition++] = (byte)c;
                continue;
            }
            this.bufferPosition = bufferPosition;
            this.internalWrite(c);
            bufferPosition = this.bufferPosition;
            highSurrogate = this.highSurrogate;
        }
        this.bufferPosition = bufferPosition;
    }

    @Override
    public AbstractBase64EncodingOutputStream getBase64EncodingOutputStream() {
        return new AbstractBase64EncodingOutputStream(){

            @Override
            protected void doWrite(byte[] b) throws IOException {
                if (ASCIICompatibleXmlWriter.this.buffer.length - ASCIICompatibleXmlWriter.this.bufferPosition < 4) {
                    ASCIICompatibleXmlWriter.this.flushBuffer();
                }
                System.arraycopy(b, 0, ASCIICompatibleXmlWriter.this.buffer, ASCIICompatibleXmlWriter.this.bufferPosition, 4);
                ASCIICompatibleXmlWriter.this.bufferPosition += 4;
            }

            @Override
            protected void flushBuffer() throws IOException {
            }

            @Override
            protected void doFlush() throws IOException {
            }

            @Override
            protected void doClose() throws IOException {
            }
        };
    }

    @Override
    public final void flushBuffer() throws IOException {
        this.out.write(this.buffer, 0, this.bufferPosition);
        this.bufferPosition = 0;
    }
}

