/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.dom;

import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreTypedAttribute;
import org.apache.axiom.dom.DOMElement;
import org.apache.axiom.dom.DOMExceptionUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class AttributesNamedNodeMap
implements NamedNodeMap {
    private final DOMElement element;

    public AttributesNamedNodeMap(DOMElement element) {
        this.element = element;
    }

    @Override
    public int getLength() {
        int length2 = 0;
        CoreAttribute attr = this.element.coreGetFirstAttribute();
        while (attr != null) {
            attr = attr.coreGetNextAttribute();
            ++length2;
        }
        return length2;
    }

    @Override
    public Node item(int index) {
        CoreAttribute attr = this.element.coreGetFirstAttribute();
        for (int i = 0; i < index && attr != null; attr = attr.coreGetNextAttribute(), ++i) {
        }
        return (Node)((Object)attr);
    }

    @Override
    public Node getNamedItem(String name) {
        return this.element.getAttributeNode(name);
    }

    @Override
    public Node getNamedItemNS(String namespaceURI, String localName) throws DOMException {
        return this.element.getAttributeNodeNS(namespaceURI, localName);
    }

    @Override
    public Node setNamedItem(Node arg) throws DOMException {
        if (arg instanceof CoreTypedAttribute) {
            return this.element.setAttributeNode((Attr)arg);
        }
        throw DOMExceptionUtil.newDOMException((short)3);
    }

    @Override
    public Node setNamedItemNS(Node arg) throws DOMException {
        if (arg instanceof CoreTypedAttribute) {
            return this.element.setAttributeNodeNS((Attr)arg);
        }
        throw DOMExceptionUtil.newDOMException((short)3);
    }

    @Override
    public Node removeNamedItem(String name) throws DOMException {
        Attr attr = this.element.getAttributeNode(name);
        if (attr != null) {
            this.element.removeAttributeNode(attr);
            return attr;
        }
        throw DOMExceptionUtil.newDOMException((short)8);
    }

    @Override
    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        Attr attr = this.element.getAttributeNodeNS(namespaceURI, localName);
        if (attr != null) {
            this.element.removeAttributeNode(attr);
            return attr;
        }
        throw DOMExceptionUtil.newDOMException((short)8);
    }
}

