/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.dom.impl.mixin;

import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.dom.DOMCharacterData;
import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.dom.DOMSemantics;
import org.apache.axiom.weaver.annotation.Mixin;

@Mixin
public abstract class DOMCharacterDataMixin
implements DOMCharacterData {
    @Override
    public final String getData() {
        try {
            return this.coreGetCharacterData().toString();
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final void setData(String data2) {
        try {
            this.coreSetCharacterData(data2, DOMSemantics.INSTANCE);
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final String getNodeValue() {
        return this.getData();
    }

    @Override
    public final void setNodeValue(String nodeValue) {
        this.setData(nodeValue);
    }

    @Override
    public final int getLength() {
        String data2 = this.getData();
        return data2 != null ? data2.length() : 0;
    }

    @Override
    public final void appendData(String arg) {
        this.setData(this.getData() + arg);
    }

    @Override
    public final void deleteData(int offset, int count2) {
        this.replaceData(offset, count2, null);
    }

    @Override
    public final void replaceData(int offset, int count2, String arg) {
        String data2 = this.getData();
        int length2 = data2.length();
        if (offset < 0 || offset > length2 || count2 < 0) {
            throw DOMExceptionUtil.newDOMException((short)1);
        }
        int end = Math.min(count2 + offset, length2);
        if (arg == null) {
            this.setData(new StringBuilder(data2).delete(offset, end).toString());
        } else {
            this.setData(new StringBuilder(data2).replace(offset, end, arg).toString());
        }
    }

    @Override
    public final void insertData(int offset, String arg) {
        String data2 = this.getData();
        if (offset < 0 || offset > data2.length()) {
            throw DOMExceptionUtil.newDOMException((short)1);
        }
        this.setData(new StringBuilder(data2).insert(offset, arg).toString());
    }

    @Override
    public final String substringData(int offset, int count2) {
        String data2 = this.getData();
        int length2 = data2.length();
        if (offset < 0 || offset > length2 || count2 < 0) {
            throw DOMExceptionUtil.newDOMException((short)1);
        }
        return data2.substring(offset, Math.min(count2 + offset, length2));
    }
}

