/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.dom.impl.mixin;

import java.util.Hashtable;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.dom.DOMDocument;
import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.dom.DOMNode;
import org.apache.axiom.dom.DOMSemantics;
import org.apache.axiom.weaver.annotation.Mixin;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;

@Mixin
public abstract class DOMNodeMixin
implements DOMNode {
    private Hashtable userData;

    @Override
    public final boolean isSupported(String feature, String version) {
        return this.getDOMNodeFactory().hasFeature(feature, version);
    }

    @Override
    public final String lookupNamespaceURI(String prefix) {
        try {
            CoreElement context = this.getNamespaceContext();
            if (context == null) {
                return null;
            }
            if (prefix == null) {
                prefix = "";
            } else if (prefix.length() == 0) {
                return null;
            }
            String namespaceURI = context.coreLookupNamespaceURI(prefix, DOMSemantics.INSTANCE);
            return namespaceURI == null || namespaceURI.length() == 0 ? null : namespaceURI;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final String lookupPrefix(String namespaceURI) {
        try {
            CoreElement context = this.getNamespaceContext();
            if (context == null) {
                return null;
            }
            if (namespaceURI == null) {
                return null;
            }
            String prefix = context.coreLookupPrefix(namespaceURI, DOMSemantics.INSTANCE);
            return prefix == null || prefix.length() == 0 ? null : prefix;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final boolean isDefaultNamespace(String namespaceURI) {
        try {
            CoreElement context = this.getNamespaceContext();
            if (context == null) {
                return false;
            }
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            return namespaceURI.equals(context.coreLookupNamespaceURI("", DOMSemantics.INSTANCE));
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final Node cloneNode(boolean deep) {
        try {
            DOMNode clone2 = (DOMNode)this.coreClone(deep ? DOMSemantics.DEEP_CLONE : DOMSemantics.SHALLOW_CLONE, null);
            if (!(clone2 instanceof DOMDocument)) {
                clone2.coreSetOwnerDocument(this.coreGetOwnerDocument(true));
            }
            return clone2;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public void normalize() {
    }

    @Override
    public String getBaseURI() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        throw DOMExceptionUtil.newDOMException((short)9);
    }

    @Override
    public boolean isSameNode(Node node) {
        return this == node;
    }

    @Override
    public boolean isEqualNode(Node node) {
        boolean equal = true;
        boolean notEqual = false;
        if (this.getNodeType() != node.getNodeType()) {
            return false;
        }
        if (this.checkStringAttributeEquality(node)) {
            if (!this.checkNamedNodeMapEquality(node)) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean checkStringAttributeEquality(Node node) {
        boolean equal = true;
        boolean notEqual = false;
        if (node.getNodeName() == null ^ this.getNodeName() == null) {
            return false;
        }
        if (node.getNodeName() != null && !node.getNodeName().equals(this.getNodeName())) {
            return false;
        }
        if (node.getLocalName() == null ^ this.getLocalName() == null) {
            return false;
        }
        if (node.getLocalName() != null && !node.getLocalName().equals(this.getLocalName())) {
            return false;
        }
        if (node.getNamespaceURI() == null ^ this.getNamespaceURI() == null) {
            return false;
        }
        if (node.getNamespaceURI() != null && !node.getNamespaceURI().equals(this.getNamespaceURI())) {
            return false;
        }
        if (node.getPrefix() == null ^ this.getPrefix() == null) {
            return false;
        }
        if (node.getPrefix() != null && !node.getPrefix().equals(this.getPrefix())) {
            return false;
        }
        if (node.getNodeValue() == null ^ this.getNodeValue() == null) {
            return false;
        }
        return node.getNodeValue() == null || node.getNodeValue().equals(this.getNodeValue());
    }

    private boolean checkNamedNodeMapEquality(Node node) {
        NamedNodeMap nodeNamedNodeMap;
        boolean equal = true;
        boolean notEqual = false;
        if (node.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        NamedNodeMap thisNamedNodeMap = this.getAttributes();
        if (thisNamedNodeMap == null ^ (nodeNamedNodeMap = node.getAttributes()) == null) {
            return false;
        }
        if (thisNamedNodeMap != null) {
            if (thisNamedNodeMap.getLength() != nodeNamedNodeMap.getLength()) {
                return false;
            }
            int itemCount = thisNamedNodeMap.getLength();
            for (int a = 0; a < itemCount; ++a) {
                DOMNode thisNode = (DOMNode)thisNamedNodeMap.item(a);
                DOMNode tmpNode = (DOMNode)nodeNamedNodeMap.getNamedItem(thisNode.getNodeName());
                if (tmpNode == null) {
                    return false;
                }
                if (thisNode.isEqualNode(tmpNode)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Object setUserData(String key, Object value2, UserDataHandler userDataHandler) {
        if (this.userData == null) {
            this.userData = new Hashtable();
        }
        return this.userData.put(key, value2);
    }

    @Override
    public Object getUserData(String key) {
        if (this.userData != null) {
            return this.userData.get(key);
        }
        return null;
    }

    final DOMDocument ownerDocument() {
        return (DOMDocument)this.coreGetOwnerDocument(true);
    }
}

