/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.dom.impl.mixin;

import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreDocumentFragment;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.dom.DOMConfigurationImpl;
import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.dom.DOMNode;
import org.apache.axiom.dom.DOMParentNode;
import org.apache.axiom.dom.DOMSemantics;
import org.apache.axiom.dom.DocumentWhitespaceFilter;
import org.apache.axiom.weaver.annotation.Mixin;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Mixin
public abstract class DOMParentNodeMixin
implements DOMParentNode {
    @Override
    public final NodeList getChildNodes() {
        return this;
    }

    @Override
    public final int getLength() {
        int count2 = 0;
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            ++count2;
        }
        return count2;
    }

    @Override
    public final Node item(int index) {
        int count2 = 0;
        Node child = this.getFirstChild();
        while (child != null) {
            if (count2 == index) {
                return child;
            }
            child = child.getNextSibling();
            ++count2;
        }
        return null;
    }

    @Override
    public final Node getFirstChild() {
        try {
            return (Node)((Object)this.coreGetFirstChild(DocumentWhitespaceFilter.INSTANCE));
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final Node getLastChild() {
        try {
            return (Node)((Object)this.coreGetLastChild(DocumentWhitespaceFilter.INSTANCE));
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final boolean hasChildNodes() {
        return this.getFirstChild() != null;
    }

    @Override
    public final Node removeChild(Node oldChild) throws DOMException {
        if (oldChild.getParentNode() == this) {
            ((CoreChildNode)((Object)oldChild)).coreDetach(DOMSemantics.INSTANCE);
            return oldChild;
        }
        throw DOMExceptionUtil.newDOMException((short)8);
    }

    @Override
    public final void normalizeRecursively(DOMConfigurationImpl config) {
        try {
            this.normalize(config);
            for (CoreChildNode child = this.coreGetFirstChild(); child != null; child = child.coreGetNextSibling()) {
                ((DOMNode)((Object)child)).normalizeRecursively(config);
            }
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    private void checkNewChild(Node newChild) {
        if (newChild instanceof DOMNode) {
            DOMNode newDomChild = (DOMNode)newChild;
            if (!this.coreHasSameOwnerDocument(newDomChild)) {
                throw DOMExceptionUtil.newDOMException((short)4);
            }
        } else {
            throw DOMExceptionUtil.newDOMException((short)4);
        }
        this.checkNewChild0((DOMNode)newChild);
    }

    void checkNewChild0(DOMNode newChild) {
    }

    @Override
    public final Node appendChild(Node newChild) {
        try {
            this.checkNewChild(newChild);
            if (newChild instanceof CoreChildNode) {
                this.coreAppendChild((CoreChildNode)((Object)newChild));
            } else if (newChild instanceof CoreDocumentFragment) {
                this.coreAppendChildren((CoreDocumentFragment)((Object)newChild));
            } else {
                throw DOMExceptionUtil.newDOMException((short)3);
            }
            return newChild;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) {
        try {
            if (refChild == null) {
                return this.appendChild(newChild);
            }
            if (!(refChild instanceof CoreChildNode) || ((CoreChildNode)((Object)refChild)).coreGetParent() != this) {
                throw DOMExceptionUtil.newDOMException((short)8);
            }
            this.checkNewChild(newChild);
            if (newChild instanceof CoreChildNode) {
                ((CoreChildNode)((Object)refChild)).coreInsertSiblingBefore((CoreChildNode)((Object)newChild));
            } else if (newChild instanceof CoreDocumentFragment) {
                ((CoreChildNode)((Object)refChild)).coreInsertSiblingsBefore((CoreDocumentFragment)((Object)newChild));
            } else {
                throw DOMExceptionUtil.newDOMException((short)3);
            }
            return newChild;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final Node replaceChild(Node newChild, Node _oldChild) {
        try {
            if (!(_oldChild instanceof CoreChildNode)) {
                throw DOMExceptionUtil.newDOMException((short)8);
            }
            CoreChildNode oldChild = (CoreChildNode)((Object)_oldChild);
            if (oldChild.coreGetParent() != this) {
                throw DOMExceptionUtil.newDOMException((short)8);
            }
            this.checkNewChild(newChild);
            if (newChild instanceof CoreChildNode) {
                oldChild.coreReplaceWith((CoreChildNode)((Object)newChild), DOMSemantics.INSTANCE);
            } else if (newChild instanceof CoreDocumentFragment) {
                CoreChildNode nextSibling = oldChild.coreGetNextSibling();
                oldChild.coreDetach(DOMSemantics.INSTANCE);
                if (nextSibling == null) {
                    this.coreAppendChildren((CoreDocumentFragment)((Object)newChild));
                } else {
                    nextSibling.coreInsertSiblingsBefore((CoreDocumentFragment)((Object)newChild));
                }
            } else {
                throw DOMExceptionUtil.newDOMException((short)3);
            }
            return _oldChild;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }
}

