/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.dom.impl.mixin;

import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.dom.DOMSemantics;
import org.apache.axiom.dom.DOMText;
import org.apache.axiom.dom.DOMTextNode;
import org.apache.axiom.weaver.annotation.Mixin;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;

@Mixin
public abstract class DOMTextNodeMixin
implements DOMTextNode {
    private DOMTextNode getWholeTextStartNode() {
        CoreChildNode sibling;
        DOMTextNode first2 = this;
        while ((sibling = first2.coreGetPreviousSibling()) instanceof DOMTextNode) {
            first2 = (DOMTextNode)sibling;
        }
        return first2;
    }

    private DOMTextNode getWholeTextEndNode() {
        try {
            CoreChildNode sibling;
            DOMTextNode last2 = this;
            while ((sibling = last2.coreGetNextSibling()) instanceof DOMTextNode) {
                last2 = (DOMTextNode)sibling;
            }
            return last2;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final String getWholeText() {
        try {
            DOMTextNode first2 = this.getWholeTextStartNode();
            DOMTextNode last2 = this.getWholeTextEndNode();
            if (first2 == last2) {
                return first2.getData();
            }
            StringBuilder buffer = new StringBuilder();
            DOMTextNode current = first2;
            while (true) {
                buffer.append(current.getData());
                if (current == last2) break;
                current = (DOMTextNode)current.coreGetNextSibling();
            }
            return buffer.toString();
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final Text replaceWholeText(String content) throws DOMException {
        try {
            DOMText newText;
            if (content.length() > 0) {
                newText = this.getDOMNodeFactory().createCharacterDataNode();
                newText.coreSetCharacterData(content);
            } else {
                newText = null;
            }
            if (this.coreHasParent()) {
                DOMTextNode next2;
                DOMTextNode first2 = this.getWholeTextStartNode();
                DOMTextNode last2 = this.getWholeTextEndNode();
                if (newText != null) {
                    first2.coreInsertSiblingBefore(newText);
                }
                DOMTextNode current = first2;
                do {
                    next2 = current == last2 ? null : (DOMTextNode)current.coreGetNextSibling();
                    current.coreDetach(DOMSemantics.INSTANCE);
                    current = next2;
                } while (next2 != null);
            }
            return newText;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final Text splitText(int offset) throws DOMException {
        try {
            String value2 = this.getData();
            if (offset < 0 || offset > value2.length()) {
                throw DOMExceptionUtil.newDOMException((short)1);
            }
            String newValue = value2.substring(offset);
            this.deleteData(offset, value2.length());
            DOMText newText = this.getDOMNodeFactory().createCharacterDataNode();
            newText.coreSetCharacterData(newValue);
            if (this.coreHasParent()) {
                this.coreInsertSiblingAfter(newText);
            } else {
                newText.coreSetOwnerDocument(this.coreGetOwnerDocument(true));
            }
            return newText;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    public String toString() {
        String value2 = this.getData();
        return value2 != null ? value2 : "";
    }
}

