/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om;

import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.mime.ContentType;
import org.apache.axiom.mime.MediaType;
import org.apache.axiom.mime.MultipartBody;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttachmentAccessor;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMMetaFactorySPI;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.SOAPVersion;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class OMXMLBuilderFactory {
    private OMXMLBuilderFactory() {
    }

    public static OMXMLParserWrapper createStAXOMBuilder(XMLStreamReader parser) {
        OMMetaFactory metaFactory = OMAbstractFactory.getMetaFactory();
        return ((OMMetaFactorySPI)metaFactory).createStAXOMBuilder(parser);
    }

    public static OMXMLParserWrapper createStAXOMBuilder(OMFactory omFactory, XMLStreamReader parser) {
        return ((OMMetaFactorySPI)omFactory.getMetaFactory()).createStAXOMBuilder(parser);
    }

    public static OMXMLParserWrapper createOMBuilder(InputStream in) {
        return OMXMLBuilderFactory.createOMBuilder(StAXParserConfiguration.DEFAULT, in);
    }

    public static OMXMLParserWrapper createOMBuilder(InputStream in, String encoding) {
        return OMXMLBuilderFactory.createOMBuilder(StAXParserConfiguration.DEFAULT, in, encoding);
    }

    public static OMXMLParserWrapper createOMBuilder(StAXParserConfiguration configuration, InputStream in) {
        return OMXMLBuilderFactory.createOMBuilder(configuration, in, null);
    }

    public static OMXMLParserWrapper createOMBuilder(StAXParserConfiguration configuration, InputStream in, String encoding) {
        OMMetaFactory metaFactory = OMAbstractFactory.getMetaFactory();
        InputSource is = new InputSource(in);
        is.setEncoding(encoding);
        return ((OMMetaFactorySPI)metaFactory).createOMBuilder(configuration, is);
    }

    public static OMXMLParserWrapper createOMBuilder(OMFactory omFactory, InputStream in) {
        return OMXMLBuilderFactory.createOMBuilder(omFactory, StAXParserConfiguration.DEFAULT, in);
    }

    public static OMXMLParserWrapper createOMBuilder(OMFactory omFactory, InputStream in, String encoding) {
        return OMXMLBuilderFactory.createOMBuilder(omFactory, StAXParserConfiguration.DEFAULT, in, encoding);
    }

    public static OMXMLParserWrapper createOMBuilder(OMFactory omFactory, StAXParserConfiguration configuration, InputStream in) {
        return OMXMLBuilderFactory.createOMBuilder(omFactory, configuration, in, null);
    }

    public static OMXMLParserWrapper createOMBuilder(OMFactory omFactory, StAXParserConfiguration configuration, InputStream in, String encoding) {
        InputSource is = new InputSource(in);
        is.setEncoding(encoding);
        return ((OMMetaFactorySPI)omFactory.getMetaFactory()).createOMBuilder(configuration, is);
    }

    public static OMXMLParserWrapper createOMBuilder(Reader in) {
        return OMXMLBuilderFactory.createOMBuilder(StAXParserConfiguration.DEFAULT, in);
    }

    public static OMXMLParserWrapper createOMBuilder(StAXParserConfiguration configuration, Reader in) {
        OMMetaFactory metaFactory = OMAbstractFactory.getMetaFactory();
        return ((OMMetaFactorySPI)metaFactory).createOMBuilder(configuration, new InputSource(in));
    }

    public static OMXMLParserWrapper createOMBuilder(OMFactory omFactory, Reader in) {
        return OMXMLBuilderFactory.createOMBuilder(omFactory, StAXParserConfiguration.DEFAULT, in);
    }

    public static OMXMLParserWrapper createOMBuilder(OMFactory omFactory, StAXParserConfiguration configuration, Reader in) {
        return ((OMMetaFactorySPI)omFactory.getMetaFactory()).createOMBuilder(configuration, new InputSource(in));
    }

    public static OMXMLParserWrapper createOMBuilder(Source source) {
        OMMetaFactory metaFactory = OMAbstractFactory.getMetaFactory();
        return ((OMMetaFactorySPI)metaFactory).createOMBuilder(source);
    }

    public static OMXMLParserWrapper createOMBuilder(Node node, boolean expandEntityReferences) {
        OMMetaFactory metaFactory = OMAbstractFactory.getMetaFactory();
        return ((OMMetaFactorySPI)metaFactory).createOMBuilder(node, expandEntityReferences);
    }

    public static OMXMLParserWrapper createOMBuilder(SAXSource source, boolean expandEntityReferences) {
        OMMetaFactory metaFactory = OMAbstractFactory.getMetaFactory();
        return ((OMMetaFactorySPI)metaFactory).createOMBuilder(source, expandEntityReferences);
    }

    public static OMXMLParserWrapper createOMBuilder(OMFactory omFactory, Source source) {
        return ((OMMetaFactorySPI)omFactory.getMetaFactory()).createOMBuilder(source);
    }

    public static OMXMLParserWrapper createOMBuilder(OMFactory omFactory, Node node, boolean expandEntityReferences) {
        return ((OMMetaFactorySPI)omFactory.getMetaFactory()).createOMBuilder(node, expandEntityReferences);
    }

    public static OMXMLParserWrapper createOMBuilder(OMFactory omFactory, SAXSource source, boolean expandEntityReferences) {
        return ((OMMetaFactorySPI)omFactory.getMetaFactory()).createOMBuilder(source, expandEntityReferences);
    }

    public static OMXMLParserWrapper createOMBuilder(StAXParserConfiguration configuration, Attachments attachments) {
        return OMXMLBuilderFactory.createOMBuilder(configuration, attachments.getMultipartBody());
    }

    public static OMXMLParserWrapper createOMBuilder(StAXParserConfiguration configuration, MultipartBody message2) {
        return OMXMLBuilderFactory.createOMBuilder(OMAbstractFactory.getMetaFactory().getOMFactory(), configuration, message2);
    }

    public static OMXMLParserWrapper createOMBuilder(OMFactory omFactory, StAXParserConfiguration configuration, Attachments attachments) {
        return OMXMLBuilderFactory.createOMBuilder(omFactory, configuration, attachments.getMultipartBody());
    }

    public static OMXMLParserWrapper createOMBuilder(OMFactory omFactory, StAXParserConfiguration configuration, MultipartBody message2) {
        return ((OMMetaFactorySPI)omFactory.getMetaFactory()).createOMBuilder(configuration, message2);
    }

    public static OMXMLParserWrapper createOMBuilder(OMFactory omFactory, Source rootPart, OMAttachmentAccessor attachmentAccessor) {
        return ((OMMetaFactorySPI)omFactory.getMetaFactory()).createOMBuilder(rootPart, attachmentAccessor);
    }

    public static SOAPModelBuilder createStAXSOAPModelBuilder(OMMetaFactory metaFactory, XMLStreamReader parser) {
        return ((OMMetaFactorySPI)metaFactory).createStAXSOAPModelBuilder(parser);
    }

    public static SOAPModelBuilder createStAXSOAPModelBuilder(XMLStreamReader parser) {
        return ((OMMetaFactorySPI)OMAbstractFactory.getMetaFactory()).createStAXSOAPModelBuilder(parser);
    }

    public static SOAPModelBuilder createSOAPModelBuilder(InputStream in, String encoding) {
        return OMXMLBuilderFactory.createSOAPModelBuilder(OMAbstractFactory.getMetaFactory(), in, encoding);
    }

    public static SOAPModelBuilder createSOAPModelBuilder(OMMetaFactory metaFactory, InputStream in, String encoding) {
        InputSource is = new InputSource(in);
        is.setEncoding(encoding);
        return ((OMMetaFactorySPI)metaFactory).createSOAPModelBuilder(is);
    }

    public static SOAPModelBuilder createSOAPModelBuilder(Reader in) {
        return OMXMLBuilderFactory.createSOAPModelBuilder(OMAbstractFactory.getMetaFactory(), in);
    }

    public static SOAPModelBuilder createSOAPModelBuilder(OMMetaFactory metaFactory, Reader in) {
        return ((OMMetaFactorySPI)metaFactory).createSOAPModelBuilder(new InputSource(in));
    }

    public static SOAPModelBuilder createSOAPModelBuilder(Source source) {
        return OMXMLBuilderFactory.createSOAPModelBuilder(OMAbstractFactory.getMetaFactory(), source);
    }

    public static SOAPModelBuilder createSOAPModelBuilder(OMMetaFactory metaFactory, Source source) {
        return ((OMMetaFactorySPI)metaFactory).createSOAPModelBuilder(source);
    }

    public static SOAPModelBuilder createSOAPModelBuilder(Attachments attachments) {
        return OMXMLBuilderFactory.createSOAPModelBuilder(attachments.getMultipartBody());
    }

    public static SOAPModelBuilder createSOAPModelBuilder(MultipartBody message2) {
        return OMXMLBuilderFactory.createSOAPModelBuilder(OMAbstractFactory.getMetaFactory(), message2);
    }

    public static SOAPModelBuilder createSOAPModelBuilder(OMMetaFactory metaFactory, Attachments attachments) {
        return OMXMLBuilderFactory.createSOAPModelBuilder(metaFactory, attachments.getMultipartBody());
    }

    public static SOAPModelBuilder createSOAPModelBuilder(OMMetaFactory metaFactory, MultipartBody message2) {
        SOAPFactory soapFactory;
        MediaType type;
        try {
            type = new ContentType(message2.getRootPart().getContentType().getParameter("type")).getMediaType();
        }
        catch (ParseException ex) {
            throw new OMException("Failed to parse root part content type", ex);
        }
        if (type.equals(SOAPVersion.SOAP11.getMediaType())) {
            soapFactory = metaFactory.getSOAP11Factory();
        } else if (type.equals(SOAPVersion.SOAP12.getMediaType())) {
            soapFactory = metaFactory.getSOAP12Factory();
        } else {
            throw new OMException("Unable to determine SOAP version");
        }
        SOAPModelBuilder builder = ((OMMetaFactorySPI)metaFactory).createSOAPModelBuilder(message2);
        if (builder.getSOAPMessage().getOMFactory() != soapFactory) {
            throw new SOAPProcessingException("Invalid SOAP namespace URI. Expected " + soapFactory.getSoapVersionURI(), "Sender");
        }
        return builder;
    }

    public static SOAPModelBuilder createSOAPModelBuilder(OMMetaFactory metaFactory, Source rootPart, OMAttachmentAccessor attachmentAccessor) {
        return ((OMMetaFactorySPI)metaFactory).createSOAPModelBuilder(rootPart, attachmentAccessor);
    }
}

