/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.factory.meta;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.activation.DataHandler;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.core.stream.FilteredXmlInput;
import org.apache.axiom.core.stream.NamespaceRepairingFilter;
import org.apache.axiom.core.stream.XmlInput;
import org.apache.axiom.core.stream.dom.input.DOMInput;
import org.apache.axiom.core.stream.sax.input.SAXInput;
import org.apache.axiom.core.stream.stax.pull.input.StAXPullInput;
import org.apache.axiom.mime.MultipartBody;
import org.apache.axiom.mime.Part;
import org.apache.axiom.om.OMAttachmentAccessor;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.common.builder.Detachable;
import org.apache.axiom.om.impl.common.factory.meta.DetachableInputStream;
import org.apache.axiom.om.impl.common.factory.meta.DetachableReader;
import org.apache.axiom.om.impl.common.factory.meta.NSUnawareNodeFilter;
import org.apache.axiom.om.impl.stream.stax.pull.AxiomXMLStreamReaderHelperFactory;
import org.apache.axiom.om.impl.stream.xop.XOPDecodingFilter;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.util.stax.XMLFragmentStreamReader;
import org.apache.axiom.util.xml.stream.XMLEventUtils;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class BuilderSpec {
    private final XmlInput input;
    private final Detachable detachable;

    private BuilderSpec(XmlInput input, Detachable detachable) {
        this.input = input;
        this.detachable = detachable;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static BuilderSpec create(StAXParserConfiguration configuration, InputSource is, boolean makeDetachable) {
        try {
            void var4_23;
            InputStream closeable;
            XMLStreamReader reader;
            if (is.getByteStream() != null) {
                String systemId = is.getSystemId();
                String encoding = is.getEncoding();
                InputStream in = is.getByteStream();
                if (makeDetachable) {
                    DetachableInputStream detachableInputStream = new DetachableInputStream(in, false);
                    in = detachableInputStream;
                    DetachableInputStream detachableInputStream2 = detachableInputStream;
                } else {
                    Object var4_15 = null;
                }
                if (systemId != null) {
                    if (encoding != null) throw new UnsupportedOperationException();
                    reader = StAXUtils.createXMLStreamReader(configuration, systemId, in);
                } else {
                    reader = encoding == null ? StAXUtils.createXMLStreamReader(configuration, in) : StAXUtils.createXMLStreamReader(configuration, in, encoding);
                }
                closeable = null;
                return new BuilderSpec(new StAXPullInput(reader, AxiomXMLStreamReaderHelperFactory.INSTANCE, true, closeable), (Detachable)var4_23);
            } else if (is.getCharacterStream() != null) {
                Reader in = is.getCharacterStream();
                if (makeDetachable) {
                    DetachableReader detachableReader = new DetachableReader(in);
                    in = detachableReader;
                    DetachableReader detachableReader2 = detachableReader;
                } else {
                    Object var4_18 = null;
                }
                reader = StAXUtils.createXMLStreamReader(configuration, in);
                closeable = null;
                return new BuilderSpec(new StAXPullInput(reader, AxiomXMLStreamReaderHelperFactory.INSTANCE, true, closeable), (Detachable)var4_23);
            } else {
                String systemId = is.getSystemId();
                InputStream in = new URL(systemId).openConnection().getInputStream();
                if (makeDetachable) {
                    DetachableInputStream detachableInputStream = new DetachableInputStream(in, true);
                    in = detachableInputStream;
                    DetachableInputStream detachableInputStream3 = detachableInputStream;
                } else {
                    Object var4_21 = null;
                }
                reader = StAXUtils.createXMLStreamReader(configuration, systemId, in);
                closeable = in;
            }
            return new BuilderSpec(new StAXPullInput(reader, AxiomXMLStreamReaderHelperFactory.INSTANCE, true, closeable), (Detachable)var4_23);
        }
        catch (XMLStreamException ex) {
            throw new OMException(ex);
        }
        catch (IOException ex) {
            throw new OMException(ex);
        }
    }

    public static BuilderSpec from(XMLStreamReader reader) {
        int eventType = reader.getEventType();
        switch (eventType) {
            case 7: {
                break;
            }
            case 1: {
                reader = new XMLFragmentStreamReader(reader);
                break;
            }
            default: {
                throw new OMException("The supplied XMLStreamReader is in an unexpected state (" + XMLEventUtils.getEventTypeString(eventType) + ")");
            }
        }
        return new BuilderSpec(new FilteredXmlInput(new StAXPullInput(reader, AxiomXMLStreamReaderHelperFactory.INSTANCE, false, null), NamespaceRepairingFilter.DEFAULT), null);
    }

    public static BuilderSpec from(StAXParserConfiguration configuration, InputSource is) {
        return BuilderSpec.create(configuration, is, true);
    }

    public static BuilderSpec from(StAXParserConfiguration configuration, Source source) {
        if (source instanceof SAXSource) {
            return BuilderSpec.from((SAXSource)source, true);
        }
        if (source instanceof DOMSource) {
            return BuilderSpec.from(((DOMSource)source).getNode(), true);
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            InputSource is = new InputSource();
            is.setByteStream(streamSource.getInputStream());
            is.setCharacterStream(streamSource.getReader());
            is.setPublicId(streamSource.getPublicId());
            is.setSystemId(streamSource.getSystemId());
            return BuilderSpec.from(configuration, is);
        }
        if (source instanceof StAXSource) {
            return BuilderSpec.from(((StAXSource)source).getXMLStreamReader());
        }
        try {
            return new BuilderSpec(new FilteredXmlInput(new StAXPullInput(StAXUtils.getXMLInputFactory().createXMLStreamReader(source), AxiomXMLStreamReaderHelperFactory.INSTANCE, true, null), NamespaceRepairingFilter.DEFAULT), null);
        }
        catch (XMLStreamException ex) {
            throw new OMException(ex);
        }
    }

    public static BuilderSpec from(Node node, boolean expandEntityReferences) {
        return new BuilderSpec(new FilteredXmlInput(new FilteredXmlInput(new DOMInput(node, expandEntityReferences), NSUnawareNodeFilter.INSTANCE), NamespaceRepairingFilter.DEFAULT), null);
    }

    public static BuilderSpec from(SAXSource source, boolean expandEntityReferences) {
        return new BuilderSpec(new FilteredXmlInput(new SAXInput(source, expandEntityReferences), NamespaceRepairingFilter.DEFAULT), null);
    }

    public static BuilderSpec from(StAXParserConfiguration configuration, final MultipartBody message2) {
        Part rootPart = message2.getRootPart();
        InputSource is = new InputSource(rootPart.getInputStream(false));
        is.setEncoding(rootPart.getContentType().getParameter("charset"));
        BuilderSpec spec = BuilderSpec.create(configuration, is, false);
        return new BuilderSpec(new FilteredXmlInput(spec.getInput(), new XOPDecodingFilter(new OMAttachmentAccessor(){

            @Override
            public DataHandler getDataHandler(String contentID) {
                Part part = message2.getPart(contentID);
                return part == null ? null : part.getDataHandler();
            }
        })), new Detachable(){

            @Override
            public void detach() {
                message2.detach();
            }
        });
    }

    public static BuilderSpec from(StAXParserConfiguration configuration, Source source, OMAttachmentAccessor attachmentAccessor) {
        BuilderSpec spec = BuilderSpec.from(configuration, source);
        return new BuilderSpec(new FilteredXmlInput(spec.getInput(), new XOPDecodingFilter(attachmentAccessor)), spec.getDetachable());
    }

    XmlInput getInput() {
        return this.input;
    }

    Detachable getDetachable() {
        return this.detachable;
    }
}

