/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.util.Iterator;
import org.apache.axiom.core.AttributeMatcher;
import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.Content;
import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreCharacterDataSinkNode;
import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreDocumentFragment;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreMixedContentContainer;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNSAwareAttribute;
import org.apache.axiom.core.CoreNamespaceDeclaration;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.CoreParentNode;
import org.apache.axiom.core.CoreTypedAttribute;
import org.apache.axiom.core.DetachPolicy;
import org.apache.axiom.core.ElementAction;
import org.apache.axiom.core.Mapper;
import org.apache.axiom.core.NoParentException;
import org.apache.axiom.core.NodeConsumedException;
import org.apache.axiom.core.NodeFilter;
import org.apache.axiom.core.SelfRelationshipException;
import org.apache.axiom.core.Semantics;
import org.apache.axiom.core.impl.AttributeIterator;
import org.apache.axiom.dom.AttributesNamedNodeMap;
import org.apache.axiom.dom.DOMAttribute;
import org.apache.axiom.dom.DOMChildNode;
import org.apache.axiom.dom.DOMElement;
import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.dom.DOMNamedNode;
import org.apache.axiom.dom.DOMSemantics;
import org.apache.axiom.dom.DocumentWhitespaceFilter;
import org.apache.axiom.dom.ElementsByTagName;
import org.apache.axiom.dom.ElementsByTagNameNS;
import org.apache.axiom.dom.NSUtil;
import org.apache.axiom.om.impl.dom.DOMParentNodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public abstract class CoreElementImpl
extends DOMParentNodeImpl
implements DOMElement,
DOMNamedNode,
Element,
DOMChildNode,
CoreMixedContentContainer,
CoreCharacterDataSinkNode {
    private CoreAttribute firstAttribute;
    private CoreParentNode owner;
    CoreChildNode nextSibling;
    CoreChildNode previousSibling;

    public CoreElementImpl() {
        this.init$CoreElementMixin();
        this.init$DOMElementMixin();
        this.init$CoreChildNodeMixin();
        this.init$DOMChildNodeMixin();
        this.init$CoreMixedContentContainerMixin();
    }

    private void init$CoreElementMixin() {
    }

    private void init$DOMElementMixin() {
    }

    private void init$CoreChildNodeMixin() {
    }

    private void init$DOMChildNodeMixin() {
    }

    private void init$CoreMixedContentContainerMixin() {
    }

    @Override
    public final CoreAttribute coreGetFirstAttribute() {
        this.forceExpand();
        return this.firstAttribute;
    }

    @Override
    public final void internalSetFirstAttribute(CoreAttribute firstAttribute) {
        this.firstAttribute = firstAttribute;
    }

    @Override
    public final CoreAttribute coreGetLastAttribute() {
        CoreAttribute previousAttribute = null;
        for (CoreAttribute attribute = this.firstAttribute; attribute != null; attribute = attribute.coreGetNextAttribute()) {
            previousAttribute = attribute;
        }
        return previousAttribute;
    }

    @Override
    public final CoreAttribute coreGetAttribute(AttributeMatcher matcher, String namespaceURI, String name) {
        CoreAttribute attr;
        for (attr = this.coreGetFirstAttribute(); attr != null && !matcher.matches(attr, namespaceURI, name); attr = attr.coreGetNextAttribute()) {
        }
        return attr;
    }

    @Override
    public final void coreAppendAttribute(CoreAttribute attr) {
        attr.internalRemove(null, this);
        CoreAttribute lastAttribute = this.coreGetLastAttribute();
        if (lastAttribute == null) {
            this.firstAttribute = attr;
        } else {
            lastAttribute.internalSetNextAttribute(attr);
        }
    }

    @Override
    public final void coreSetAttribute(AttributeMatcher matcher, String namespaceURI, String name, String prefix, String value2) throws CoreModelException {
        CoreAttribute attr;
        CoreAttribute previousAttr = null;
        for (attr = this.firstAttribute; attr != null && !matcher.matches(attr, namespaceURI, name); attr = attr.coreGetNextAttribute()) {
            previousAttr = attr;
        }
        if (attr == null) {
            CoreAttribute newAttr = matcher.createAttribute(this.coreGetNodeFactory().getFactory2(), namespaceURI, name, prefix, value2);
            if (previousAttr == null) {
                this.coreAppendAttribute(newAttr);
            } else {
                previousAttr.internalInsertAttributeAfter(newAttr);
            }
        } else {
            matcher.update(attr, prefix, value2);
        }
    }

    @Override
    public final CoreAttribute coreSetAttribute(AttributeMatcher matcher, CoreAttribute attr, Semantics semantics) {
        CoreAttribute existingAttr;
        if (attr.coreGetOwnerElement() == this) {
            return attr;
        }
        attr.internalRemove(null, this);
        String namespaceURI = matcher.getNamespaceURI(attr);
        String name = matcher.getName(attr);
        CoreAttribute previousAttr = null;
        for (existingAttr = this.coreGetFirstAttribute(); existingAttr != null && !matcher.matches(existingAttr, namespaceURI, name); existingAttr = existingAttr.coreGetNextAttribute()) {
            previousAttr = existingAttr;
        }
        if (existingAttr == null) {
            if (previousAttr == null) {
                this.firstAttribute = attr;
            } else {
                previousAttr.internalSetNextAttribute(attr);
            }
        } else {
            if (previousAttr == null) {
                this.firstAttribute = attr;
            } else {
                previousAttr.internalSetNextAttribute(attr);
            }
            existingAttr.internalUnsetOwnerElement(semantics.getDetachPolicy().getNewOwnerDocument(this));
            attr.internalSetNextAttribute(existingAttr.coreGetNextAttribute());
            existingAttr.internalSetNextAttribute(null);
        }
        return existingAttr;
    }

    @Override
    public final boolean coreRemoveAttribute(AttributeMatcher matcher, String namespaceURI, String name, Semantics semantics) {
        CoreAttribute att = this.coreGetAttribute(matcher, namespaceURI, name);
        if (att != null) {
            att.coreRemove(semantics);
            return true;
        }
        return false;
    }

    @Override
    public final <T extends CoreAttribute, S> Iterator<S> coreGetAttributesByType(Class<T> type, Mapper<S, ? super T> mapper, Semantics semantics) {
        return AttributeIterator.create(this, type, mapper, semantics);
    }

    @Override
    public final String coreLookupNamespaceURI(String prefix, Semantics semantics) throws CoreModelException {
        String namespaceURI;
        if (!semantics.isUseStrictNamespaceLookup() && (namespaceURI = this.getImplicitNamespaceURI(prefix)) != null) {
            return namespaceURI;
        }
        for (CoreAttribute attr = this.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
            CoreNamespaceDeclaration decl;
            if (!(attr instanceof CoreNamespaceDeclaration) || !prefix.equals((decl = (CoreNamespaceDeclaration)attr).coreGetDeclaredPrefix())) continue;
            return decl.coreGetCharacterData().toString();
        }
        CoreElement parentElement = this.coreGetParentElement();
        if (parentElement != null) {
            return parentElement.coreLookupNamespaceURI(prefix, semantics);
        }
        if (prefix.length() == 0) {
            return "";
        }
        return null;
    }

    @Override
    public final String coreLookupPrefix(String namespaceURI, Semantics semantics) throws CoreModelException {
        String prefix;
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI must not be null");
        }
        if (!semantics.isUseStrictNamespaceLookup() && (prefix = this.getImplicitPrefix(namespaceURI)) != null) {
            return prefix;
        }
        for (CoreAttribute attr = this.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
            CoreNamespaceDeclaration decl;
            if (!(attr instanceof CoreNamespaceDeclaration) || !(decl = (CoreNamespaceDeclaration)attr).coreGetCharacterData().toString().equals(namespaceURI)) continue;
            return decl.coreGetDeclaredPrefix();
        }
        CoreElement parentElement = this.coreGetParentElement();
        if (parentElement != null) {
            String prefix2 = parentElement.coreLookupPrefix(namespaceURI, semantics);
            if (!semantics.isUseStrictNamespaceLookup() && this.getImplicitNamespaceURI(prefix2) != null) {
                return null;
            }
            for (CoreAttribute attr = this.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
                CoreNamespaceDeclaration decl;
                if (!(attr instanceof CoreNamespaceDeclaration) || !(decl = (CoreNamespaceDeclaration)attr).coreGetDeclaredPrefix().equals(prefix2)) continue;
                return null;
            }
            return prefix2;
        }
        return null;
    }

    @Override
    public final <T> void init(ClonePolicy<T> policy, T options, CoreNode other) throws CoreModelException {
        CoreElement o = (CoreElement)other;
        this.initSource(policy, options, o);
        this.initName(o);
        if (this.isExpanded()) {
            for (CoreAttribute attr = o.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
                this.coreAppendAttribute((CoreAttribute)attr.coreClone(policy, options));
            }
        }
    }

    public <T> void initSource(ClonePolicy<T> policy, T options, CoreElement other) {
    }

    @Override
    public final void corePromote(CoreElement newElement, Semantics semantics) throws CoreModelException {
        newElement.initName(this);
        newElement.internalSetFirstAttribute(this.firstAttribute);
        for (CoreAttribute attr = this.firstAttribute; attr != null; attr = attr.coreGetNextAttribute()) {
            attr.internalSetOwnerElement(newElement);
        }
        this.firstAttribute = null;
        newElement.coreMoveChildrenFrom(this, semantics);
        this.coreReplaceWith(newElement, semantics);
    }

    @Override
    public final Document getOwnerDocument() {
        return (Document)((Object)this.coreGetOwnerDocument(true));
    }

    @Override
    public final short getNodeType() {
        return 1;
    }

    @Override
    public final String getNodeName() {
        return this.getTagName();
    }

    @Override
    public final String getNodeValue() {
        return null;
    }

    @Override
    public final void setNodeValue(String nodeValue) {
    }

    @Override
    public final String getTagName() {
        return this.internalGetName();
    }

    @Override
    public final TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final CoreElement getNamespaceContext() {
        return this;
    }

    @Override
    public final boolean hasAttributes() {
        return this.coreGetFirstAttribute() != null;
    }

    @Override
    public final NamedNodeMap getAttributes() {
        return new AttributesNamedNodeMap(this);
    }

    @Override
    public final Attr getAttributeNode(String name) {
        return (DOMAttribute)this.coreGetAttribute(DOMSemantics.DOM1_ATTRIBUTE_MATCHER, null, name);
    }

    @Override
    public final Attr getAttributeNodeNS(String namespaceURI, String localName) {
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            return (DOMAttribute)this.coreGetAttribute(DOMSemantics.NAMESPACE_DECLARATION_MATCHER, null, localName.equals("xmlns") ? "" : localName);
        }
        return (DOMAttribute)this.coreGetAttribute(DOMSemantics.DOM2_ATTRIBUTE_MATCHER, namespaceURI == null ? "" : namespaceURI, localName);
    }

    @Override
    public final String getAttribute(String name) {
        Attr attr = this.getAttributeNode(name);
        return attr != null ? attr.getValue() : "";
    }

    @Override
    public final String getAttributeNS(String namespaceURI, String localName) {
        Attr attr = this.getAttributeNodeNS(namespaceURI, localName);
        return attr != null ? attr.getValue() : "";
    }

    @Override
    public final boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    @Override
    public final boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getAttributeNodeNS(namespaceURI, localName) != null;
    }

    @Override
    public final void setAttribute(String name, String value2) {
        try {
            NSUtil.validateName(name);
            this.coreSetAttribute(DOMSemantics.DOM1_ATTRIBUTE_MATCHER, null, name, null, value2);
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final void setAttributeNS(String namespaceURI, String qualifiedName, String value2) throws DOMException {
        try {
            String localName;
            String prefix;
            int i = NSUtil.validateQualifiedName(qualifiedName);
            if (i == -1) {
                prefix = "";
                localName = qualifiedName;
            } else {
                prefix = qualifiedName.substring(0, i);
                localName = qualifiedName.substring(i + 1);
            }
            if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                this.coreSetAttribute(DOMSemantics.NAMESPACE_DECLARATION_MATCHER, null, NSUtil.getDeclaredPrefix(localName, prefix), null, value2);
            } else {
                namespaceURI = NSUtil.normalizeNamespaceURI(namespaceURI);
                NSUtil.validateAttributeName(namespaceURI, localName, prefix);
                this.coreSetAttribute(DOMSemantics.DOM2_ATTRIBUTE_MATCHER, namespaceURI, localName, prefix, value2);
            }
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final Attr setAttributeNode(Attr newAttr) throws DOMException {
        return this.setAttributeNodeNS(newAttr);
    }

    @Override
    public final Attr setAttributeNodeNS(Attr _newAttr) throws DOMException {
        if (!(_newAttr instanceof DOMAttribute)) {
            throw DOMExceptionUtil.newDOMException((short)4);
        }
        DOMAttribute newAttr = (DOMAttribute)_newAttr;
        CoreElement owner = newAttr.coreGetOwnerElement();
        if (owner == this) {
            return newAttr;
        }
        if (owner != null) {
            throw DOMExceptionUtil.newDOMException((short)10);
        }
        if (!this.coreHasSameOwnerDocument(newAttr)) {
            throw DOMExceptionUtil.newDOMException((short)4);
        }
        AttributeMatcher matcher = newAttr instanceof CoreNSAwareAttribute ? DOMSemantics.DOM2_ATTRIBUTE_MATCHER : (newAttr instanceof CoreNamespaceDeclaration ? DOMSemantics.NAMESPACE_DECLARATION_MATCHER : DOMSemantics.DOM1_ATTRIBUTE_MATCHER);
        return (DOMAttribute)this.coreSetAttribute(matcher, newAttr, DOMSemantics.INSTANCE);
    }

    @Override
    public final Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        if (oldAttr instanceof DOMAttribute) {
            DOMAttribute attr = (DOMAttribute)oldAttr;
            if (attr.coreGetOwnerElement() != this) {
                throw DOMExceptionUtil.newDOMException((short)8);
            }
            attr.coreRemove(DOMSemantics.INSTANCE);
            return attr;
        }
        throw DOMExceptionUtil.newDOMException((short)8);
    }

    @Override
    public final void removeAttribute(String name) throws DOMException {
        this.coreRemoveAttribute(DOMSemantics.DOM1_ATTRIBUTE_MATCHER, null, name, DOMSemantics.INSTANCE);
    }

    @Override
    public final void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            this.coreRemoveAttribute(DOMSemantics.NAMESPACE_DECLARATION_MATCHER, null, localName.equals("xmlns") ? "" : localName, DOMSemantics.INSTANCE);
        } else {
            this.coreRemoveAttribute(DOMSemantics.DOM2_ATTRIBUTE_MATCHER, namespaceURI == null ? "" : namespaceURI, localName, DOMSemantics.INSTANCE);
        }
    }

    @Override
    public final String getTextContent() {
        try {
            return this.coreGetCharacterData(ElementAction.RECURSE).toString();
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final void setTextContent(String textContent) {
        try {
            this.coreSetCharacterData(textContent, DOMSemantics.INSTANCE);
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final NodeList getElementsByTagName(String tagname) {
        return new ElementsByTagName(this, tagname);
    }

    @Override
    public final NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return new ElementsByTagNameNS(this, namespaceURI, localName);
    }

    @Override
    public final void setIdAttribute(String name, boolean isId) throws DOMException {
        CoreAttribute attr = this.coreGetAttribute(DOMSemantics.DOM1_ATTRIBUTE_MATCHER, null, name);
        if (attr == null) {
            throw DOMExceptionUtil.newDOMException((short)8);
        }
        ((CoreTypedAttribute)attr).coreSetType(isId ? "ID" : "CDATA");
    }

    @Override
    public final void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        CoreAttribute attr = this.coreGetAttribute(DOMSemantics.DOM2_ATTRIBUTE_MATCHER, NSUtil.normalizeNamespaceURI(namespaceURI), localName);
        if (attr == null) {
            throw DOMExceptionUtil.newDOMException((short)8);
        }
        ((CoreTypedAttribute)attr).coreSetType(isId ? "ID" : "CDATA");
    }

    @Override
    public final void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        if (idAttr.getOwnerElement() != this) {
            throw DOMExceptionUtil.newDOMException((short)8);
        }
        ((CoreTypedAttribute)((Object)idAttr)).coreSetType(isId ? "ID" : "CDATA");
    }

    @Override
    public final boolean coreHasParent() {
        return this.internalGetFlag(8);
    }

    @Override
    public final CoreParentNode coreGetParent() {
        return this.internalGetFlag(8) ? this.owner : null;
    }

    @Override
    public final CoreElement coreGetParentElement() {
        return this.owner instanceof CoreElement ? (CoreElement)this.owner : null;
    }

    @Override
    public void internalSetParent(CoreParentNode parent) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        this.owner = parent;
        this.internalSetFlag(8, true);
    }

    @Override
    public final void internalUnsetParent(CoreDocument newOwnerDocument) {
        this.owner = newOwnerDocument;
        this.internalSetFlag(8, false);
    }

    @Override
    public final CoreNode getRootOrOwnerDocument() {
        if (this.owner == null) {
            return this;
        }
        return this.owner.getRootOrOwnerDocument();
    }

    @Override
    public final void coreSetOwnerDocument(CoreDocument document) {
        if (this.internalGetFlag(8)) {
            throw new IllegalStateException();
        }
        this.owner = document;
    }

    @Override
    public final CoreChildNode coreGetNextSiblingIfAvailable() {
        return this.nextSibling;
    }

    @Override
    public final void internalSetNextSibling(CoreChildNode nextSibling) {
        this.nextSibling = nextSibling;
    }

    @Override
    public final CoreChildNode coreGetPreviousSibling() {
        return this.previousSibling;
    }

    @Override
    public final CoreChildNode coreGetPreviousSibling(NodeFilter filter2) {
        CoreChildNode sibling;
        for (sibling = this.coreGetPreviousSibling(); sibling != null && !filter2.accept(sibling); sibling = sibling.coreGetPreviousSibling()) {
        }
        return sibling;
    }

    @Override
    public final void internalSetPreviousSibling(CoreChildNode previousSibling) {
        this.previousSibling = previousSibling;
    }

    @Override
    public final CoreChildNode coreGetNextSibling() throws CoreModelException {
        CoreParentNode parent;
        CoreChildNode nextSibling = this.coreGetNextSiblingIfAvailable();
        if (nextSibling == null && (parent = this.coreGetParent()) != null) {
            switch (parent.getState()) {
                case 3: 
                case 4: {
                    throw new NodeConsumedException();
                }
                case 2: {
                    if (parent.coreGetBuilder() == null) break;
                    do {
                        parent.internalBuildNext();
                    } while (parent.getState() == 2 && (nextSibling = this.coreGetNextSiblingIfAvailable()) == null);
                }
            }
        }
        return nextSibling;
    }

    @Override
    public final CoreChildNode coreGetNextSibling(NodeFilter filter2) throws CoreModelException {
        CoreChildNode sibling;
        for (sibling = this.coreGetNextSibling(); sibling != null && !filter2.accept(sibling); sibling = sibling.coreGetNextSibling()) {
        }
        return sibling;
    }

    @Override
    public final void coreInsertSiblingAfter(CoreChildNode sibling) throws CoreModelException {
        CoreParentNode parent = this.coreGetParent();
        if (parent == null) {
            throw new NoParentException("Parent can not be null");
        }
        if (this == sibling) {
            throw new SelfRelationshipException("Inserting self as the sibling is not allowed");
        }
        parent.internalCheckNewChild(sibling, null);
        sibling.internalDetach(null, parent);
        CoreChildNode nextSibling = this.coreGetNextSibling();
        sibling.internalSetPreviousSibling(this);
        if (nextSibling == null) {
            parent.internalGetContent((boolean)true).lastChild = sibling;
        } else {
            nextSibling.internalSetPreviousSibling(sibling);
        }
        sibling.internalSetNextSibling(nextSibling);
        this.nextSibling = sibling;
    }

    @Override
    public final void coreInsertSiblingBefore(CoreChildNode sibling) throws CoreModelException {
        CoreParentNode parent = this.coreGetParent();
        if (parent == null) {
            throw new NoParentException("Parent can not be null");
        }
        if (this == sibling) {
            throw new SelfRelationshipException("Inserting self as the sibling is not allowed");
        }
        parent.internalCheckNewChild(sibling, null);
        sibling.internalDetach(null, parent);
        sibling.internalSetNextSibling(this);
        if (this.previousSibling == null) {
            parent.internalGetContent((boolean)true).firstChild = sibling;
        } else {
            this.previousSibling.internalSetNextSibling(sibling);
        }
        sibling.internalSetPreviousSibling(this.previousSibling);
        this.previousSibling = sibling;
    }

    @Override
    public final void coreInsertSiblingsBefore(CoreDocumentFragment fragment) {
        Content fragmentContent = fragment.internalGetContent(false);
        if (fragmentContent == null || fragmentContent.firstChild == null) {
            return;
        }
        CoreParentNode parent = this.coreGetParent();
        for (CoreChildNode child = fragmentContent.firstChild; child != null; child = child.coreGetNextSiblingIfAvailable()) {
            child.internalSetParent(parent);
        }
        fragmentContent.lastChild.internalSetNextSibling(this);
        if (this.previousSibling == null) {
            parent.internalGetContent((boolean)true).firstChild = fragmentContent.firstChild;
        } else {
            this.previousSibling.internalSetNextSibling(fragmentContent.firstChild);
        }
        fragmentContent.firstChild.internalSetPreviousSibling(this.previousSibling);
        this.previousSibling = fragmentContent.lastChild;
        fragmentContent.firstChild = null;
        fragmentContent.lastChild = null;
    }

    @Override
    public final void coreDetach(Semantics semantics) {
        this.internalDetach(semantics.getDetachPolicy(), null);
    }

    @Override
    public final void coreDetach(CoreDocument newOwnerDocument) {
        this.internalDetach(DetachPolicy.NEW_DOCUMENT, null);
        this.owner = newOwnerDocument;
    }

    @Override
    public final void internalDetach(DetachPolicy detachPolicy, CoreParentNode newParent) {
        CoreParentNode parent = this.coreGetParent();
        if (parent != null) {
            if (this.previousSibling == null) {
                parent.internalGetContent((boolean)true).firstChild = this.nextSibling;
            } else {
                this.previousSibling.internalSetNextSibling(this.nextSibling);
            }
            if (this.nextSibling == null) {
                parent.internalGetContent((boolean)true).lastChild = this.previousSibling;
            } else {
                this.nextSibling.internalSetPreviousSibling(this.previousSibling);
            }
            this.nextSibling = null;
            this.previousSibling = null;
            if (newParent == null) {
                this.internalUnsetParent(detachPolicy.getNewOwnerDocument(parent));
            }
        }
        if (newParent != null) {
            this.internalSetParent(newParent);
        }
    }

    @Override
    public final void coreReplaceWith(CoreChildNode newNode, Semantics semantics) throws CoreModelException {
        if (newNode == this) {
            return;
        }
        CoreParentNode parent = this.coreGetParent();
        if (parent != null) {
            parent.internalCheckNewChild(newNode, this);
            newNode.internalDetach(null, parent);
            if (this.previousSibling == null) {
                parent.internalGetContent((boolean)true).firstChild = newNode;
            } else {
                this.previousSibling.internalSetNextSibling(newNode);
                newNode.internalSetPreviousSibling(this.previousSibling);
                this.previousSibling = null;
            }
            if (this.nextSibling == null) {
                parent.internalGetContent((boolean)true).lastChild = newNode;
            } else {
                this.nextSibling.internalSetPreviousSibling(newNode);
                newNode.internalSetNextSibling(this.nextSibling);
                this.nextSibling = null;
            }
            this.internalUnsetParent(semantics.getDetachPolicy().getNewOwnerDocument(parent));
        }
    }

    @Override
    public final <T> CoreNode coreClone(ClonePolicy<T> policy, T options, CoreParentNode targetParent) throws CoreModelException {
        return this.internalClone(policy, options, targetParent);
    }

    @Override
    public final Node getParentNode() {
        return (Node)((Object)this.coreGetParent());
    }

    @Override
    public final Node getNextSibling() {
        try {
            return (Node)((Object)this.coreGetNextSibling(DocumentWhitespaceFilter.INSTANCE));
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final Node getPreviousSibling() {
        return (Node)((Object)this.coreGetPreviousSibling(DocumentWhitespaceFilter.INSTANCE));
    }

    @Override
    public final Object coreGetCharacterData(ElementAction elementAction) throws CoreModelException {
        return this.internalGetCharacterData(elementAction);
    }
}

