/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.util.Hashtable;
import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.CoreParentNode;
import org.apache.axiom.core.NodeFactory;
import org.apache.axiom.dom.DOMDocument;
import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.dom.DOMNode;
import org.apache.axiom.dom.DOMNodeFactory;
import org.apache.axiom.dom.DOMSemantics;
import org.apache.axiom.om.impl.dom.factory.DOOMNodeFactory;
import org.apache.axiom.om.impl.dom.factory.DOOMNodeFactoryImpl;
import org.apache.axiom.om.impl.dom.intf.DOOMNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;

public abstract class CoreNodeImpl
implements DOOMNode {
    int flags;
    private Hashtable userData;

    public CoreNodeImpl() {
        this.init$CoreNodeMixin();
        this.init$DOMNodeMixin();
        this.init$DOOMNodeMixin();
    }

    private void init$CoreNodeMixin() {
    }

    private void init$DOMNodeMixin() {
    }

    private void init$DOOMNodeMixin() {
    }

    @Override
    public Class<? extends CoreNode> coreGetNodeClass() {
        return this.coreGetNodeType().getInterface();
    }

    @Override
    public final CoreDocument coreGetOwnerDocument(boolean create) {
        CoreNode root = this.getRootOrOwnerDocument();
        if (root instanceof CoreDocument) {
            return (CoreDocument)root;
        }
        if (create) {
            CoreDocument ownerDocument = root.coreGetNodeFactory().getFactory2().createDocument();
            root.coreSetOwnerDocument(ownerDocument);
            return ownerDocument;
        }
        return null;
    }

    @Override
    public final boolean coreHasSameOwnerDocument(CoreNode other) {
        return other.getRootOrOwnerDocument() == this.getRootOrOwnerDocument();
    }

    @Override
    public final boolean internalGetFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    @Override
    public final void internalSetFlag(int flag, boolean value2) {
        this.flags = value2 ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    @Override
    public final int internalGetFlags(int mask) {
        return this.flags & mask;
    }

    @Override
    public final void internalSetFlags(int mask, int value2) {
        this.flags = this.flags & ~mask | value2;
    }

    public final <T> CoreNode shallowClone(ClonePolicy<T> policy, T options) throws CoreModelException {
        CoreNode clone2 = this.coreGetNodeFactory().createNode(policy.getTargetNodeClass(options, this));
        clone2.init(policy, options, this);
        clone2.initAncillaryData(policy, options, this);
        return clone2;
    }

    @Override
    public final <T> CoreNode internalClone(ClonePolicy<T> policy, T options, CoreParentNode targetParent) throws CoreModelException {
        CoreNode clone2 = this.shallowClone(policy, options);
        if (targetParent != null) {
            targetParent.coreAppendChild((CoreChildNode)clone2);
        }
        policy.postProcess(options, clone2);
        this.cloneChildrenIfNecessary(policy, options, clone2);
        return clone2;
    }

    @Override
    public final <T> CoreNode coreClone(ClonePolicy<T> policy, T options) throws CoreModelException {
        return this.internalClone(policy, options, null);
    }

    @Override
    public <T> void initAncillaryData(ClonePolicy<T> policy, T options, CoreNode other) {
    }

    @Override
    public final boolean isSupported(String feature, String version) {
        return this.getDOMNodeFactory().hasFeature(feature, version);
    }

    @Override
    public final String lookupNamespaceURI(String prefix) {
        try {
            CoreElement context = this.getNamespaceContext();
            if (context == null) {
                return null;
            }
            if (prefix == null) {
                prefix = "";
            } else if (prefix.length() == 0) {
                return null;
            }
            String namespaceURI = context.coreLookupNamespaceURI(prefix, DOMSemantics.INSTANCE);
            return namespaceURI == null || namespaceURI.length() == 0 ? null : namespaceURI;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final String lookupPrefix(String namespaceURI) {
        try {
            CoreElement context = this.getNamespaceContext();
            if (context == null) {
                return null;
            }
            if (namespaceURI == null) {
                return null;
            }
            String prefix = context.coreLookupPrefix(namespaceURI, DOMSemantics.INSTANCE);
            return prefix == null || prefix.length() == 0 ? null : prefix;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final boolean isDefaultNamespace(String namespaceURI) {
        try {
            CoreElement context = this.getNamespaceContext();
            if (context == null) {
                return false;
            }
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            return namespaceURI.equals(context.coreLookupNamespaceURI("", DOMSemantics.INSTANCE));
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final Node cloneNode(boolean deep) {
        try {
            DOMNode clone2 = (DOMNode)this.coreClone(deep ? DOMSemantics.DEEP_CLONE : DOMSemantics.SHALLOW_CLONE, null);
            if (!(clone2 instanceof DOMDocument)) {
                clone2.coreSetOwnerDocument(this.coreGetOwnerDocument(true));
            }
            return clone2;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public void normalize() {
    }

    @Override
    public String getBaseURI() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        throw DOMExceptionUtil.newDOMException((short)9);
    }

    @Override
    public boolean isSameNode(Node node) {
        return this == node;
    }

    @Override
    public boolean isEqualNode(Node node) {
        boolean equal = true;
        boolean notEqual = false;
        if (this.getNodeType() != node.getNodeType()) {
            return false;
        }
        if (this.checkStringAttributeEquality(node)) {
            if (!this.checkNamedNodeMapEquality(node)) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean checkStringAttributeEquality(Node node) {
        boolean equal = true;
        boolean notEqual = false;
        if (node.getNodeName() == null ^ this.getNodeName() == null) {
            return false;
        }
        if (node.getNodeName() != null && !node.getNodeName().equals(this.getNodeName())) {
            return false;
        }
        if (node.getLocalName() == null ^ this.getLocalName() == null) {
            return false;
        }
        if (node.getLocalName() != null && !node.getLocalName().equals(this.getLocalName())) {
            return false;
        }
        if (node.getNamespaceURI() == null ^ this.getNamespaceURI() == null) {
            return false;
        }
        if (node.getNamespaceURI() != null && !node.getNamespaceURI().equals(this.getNamespaceURI())) {
            return false;
        }
        if (node.getPrefix() == null ^ this.getPrefix() == null) {
            return false;
        }
        if (node.getPrefix() != null && !node.getPrefix().equals(this.getPrefix())) {
            return false;
        }
        if (node.getNodeValue() == null ^ this.getNodeValue() == null) {
            return false;
        }
        return node.getNodeValue() == null || node.getNodeValue().equals(this.getNodeValue());
    }

    private boolean checkNamedNodeMapEquality(Node node) {
        NamedNodeMap nodeNamedNodeMap;
        boolean equal = true;
        boolean notEqual = false;
        if (node.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        NamedNodeMap thisNamedNodeMap = this.getAttributes();
        if (thisNamedNodeMap == null ^ (nodeNamedNodeMap = node.getAttributes()) == null) {
            return false;
        }
        if (thisNamedNodeMap != null) {
            if (thisNamedNodeMap.getLength() != nodeNamedNodeMap.getLength()) {
                return false;
            }
            int itemCount = thisNamedNodeMap.getLength();
            for (int a = 0; a < itemCount; ++a) {
                DOMNode thisNode = (DOMNode)thisNamedNodeMap.item(a);
                DOMNode tmpNode = (DOMNode)nodeNamedNodeMap.getNamedItem(thisNode.getNodeName());
                if (tmpNode == null) {
                    return false;
                }
                if (thisNode.isEqualNode(tmpNode)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Object setUserData(String key, Object value2, UserDataHandler userDataHandler) {
        if (this.userData == null) {
            this.userData = new Hashtable();
        }
        return this.userData.put(key, value2);
    }

    @Override
    public Object getUserData(String key) {
        if (this.userData != null) {
            return this.userData.get(key);
        }
        return null;
    }

    final DOMDocument ownerDocument() {
        return (DOMDocument)this.coreGetOwnerDocument(true);
    }

    @Override
    public final DOMNodeFactory getDOMNodeFactory() {
        return DOOMNodeFactoryImpl.INSTANCE;
    }

    @Override
    public final NodeFactory coreGetNodeFactory() {
        return DOOMNodeFactory.INSTANCE;
    }
}

