/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.io.FilterReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.core.Axis;
import org.apache.axiom.core.Builder;
import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNamedNode;
import org.apache.axiom.core.CoreParentNode;
import org.apache.axiom.core.ElementAction;
import org.apache.axiom.core.ElementMatcher;
import org.apache.axiom.core.Mappers;
import org.apache.axiom.core.NodeType;
import org.apache.axiom.core.impl.builder.BuilderImpl;
import org.apache.axiom.core.stream.NamespaceContextProvider;
import org.apache.axiom.core.stream.NamespaceRepairingFilterHandler;
import org.apache.axiom.core.stream.NamespaceURIInterningFilterHandler;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.XmlInput;
import org.apache.axiom.core.stream.sax.input.XmlHandlerContentHandler;
import org.apache.axiom.core.stream.serializer.Serializer;
import org.apache.axiom.core.stream.stax.pull.output.StAXPivot;
import org.apache.axiom.core.stream.stax.push.input.XMLStreamWriterNamespaceContextProvider;
import org.apache.axiom.dom.DOMConfigurationImpl;
import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.dom.DOMNSAwareElement;
import org.apache.axiom.dom.DOMNSAwareNamedNode;
import org.apache.axiom.dom.DOMNamedNode;
import org.apache.axiom.mime.PartDataHandler;
import org.apache.axiom.om.NodeUnavailableException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMInformationItem;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.OMXMLStreamReaderConfiguration;
import org.apache.axiom.om.XOPEncoded;
import org.apache.axiom.om.impl.OMMultipartWriter;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.AxiomSemantics;
import org.apache.axiom.om.impl.common.LiveNamespaceContext;
import org.apache.axiom.om.impl.common.NSUtil;
import org.apache.axiom.om.impl.common.NamespaceDeclarationMapper;
import org.apache.axiom.om.impl.common.NamespaceIterator;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.common.SAXResultContentHandler;
import org.apache.axiom.om.impl.common.builder.OMNamespaceCache;
import org.apache.axiom.om.impl.common.builder.OMXMLParserWrapperImpl;
import org.apache.axiom.om.impl.dom.CoreElementImpl;
import org.apache.axiom.om.impl.dom.factory.DOOMNodeFactoryImpl;
import org.apache.axiom.om.impl.dom.intf.DOOMElement;
import org.apache.axiom.om.impl.dom.intf.DOOMNSAwareElement;
import org.apache.axiom.om.impl.dom.intf.DOOMParentNode;
import org.apache.axiom.om.impl.intf.AxiomAttribute;
import org.apache.axiom.om.impl.intf.AxiomChildNode;
import org.apache.axiom.om.impl.intf.AxiomContainer;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.om.impl.intf.AxiomNamedInformationItem;
import org.apache.axiom.om.impl.intf.AxiomNamespaceDeclaration;
import org.apache.axiom.om.impl.intf.AxiomSerializable;
import org.apache.axiom.om.impl.intf.AxiomSourcedElement;
import org.apache.axiom.om.impl.intf.Sequence;
import org.apache.axiom.om.impl.intf.factory.AxiomNodeFactory;
import org.apache.axiom.om.impl.stream.NamespaceContextPreservationFilterHandler;
import org.apache.axiom.om.impl.stream.XmlDeclarationRewriterHandler;
import org.apache.axiom.om.impl.stream.XsiTypeFilterHandler;
import org.apache.axiom.om.impl.stream.sax.XMLReaderImpl;
import org.apache.axiom.om.impl.stream.stax.pull.AxiomXMLStreamReaderExtensionFactory;
import org.apache.axiom.om.impl.stream.stax.push.XMLStreamWriterHandler;
import org.apache.axiom.om.impl.stream.xop.ContentIDGenerator;
import org.apache.axiom.om.impl.stream.xop.ContentIDGeneratorImpl;
import org.apache.axiom.om.impl.stream.xop.OptimizationPolicy;
import org.apache.axiom.om.impl.stream.xop.OptimizationPolicyImpl;
import org.apache.axiom.om.impl.stream.xop.XOPEncodingFilterHandler;
import org.apache.axiom.util.io.IOUtils;
import org.apache.axiom.util.namespace.MapBasedNamespaceContext;
import org.apache.axiom.util.stax.XMLStreamIOException;
import org.apache.axiom.util.stax.XMLStreamReaderUtils;
import org.apache.axiom.util.xml.NSUtils;
import org.apache.axiom.util.xml.QNameCache;
import org.w3c.dom.DOMException;
import org.xml.sax.InputSource;

public class DOOMNSAwareElementImpl
extends CoreElementImpl
implements DOOMNSAwareElement,
DOOMElement,
DOOMParentNode,
DOMNSAwareElement,
AxiomContainer,
AxiomChildNode,
AxiomSerializable,
DOMNSAwareNamedNode,
DOMNamedNode,
AxiomNamedInformationItem {
    private static final OMNamespace XMLNS;
    private static final OMXMLStreamReaderConfiguration defaultReaderConfiguration;
    private OMNamespace namespace;
    private String localName;

    public DOOMNSAwareElementImpl() {
        this.init$CoreNSAwareElementMixin();
        this.init$AxiomElementMixin();
        this.init$DOMNSAwareElementMixin();
        this.init$AxiomContainerMixin();
        this.init$AxiomCoreParentNodeMixin();
        this.init$AxiomSerializableMixin();
        this.init$AxiomInformationItemMixin();
        this.init$AxiomChildNodeMixin();
        this.init$DOMNSAwareNamedNodeMixin();
        this.init$AxiomNamedInformationItemMixin();
    }

    static {
        DOOMNSAwareElementImpl.clinit$AxiomElementMixin();
        DOOMNSAwareElementImpl.clinit$AxiomContainerMixin();
    }

    private void init$CoreNSAwareElementMixin() {
    }

    private void init$AxiomElementMixin() {
    }

    private void init$DOMNSAwareElementMixin() {
    }

    private void init$AxiomContainerMixin() {
    }

    private void init$AxiomCoreParentNodeMixin() {
    }

    private void init$AxiomSerializableMixin() {
    }

    private void init$AxiomInformationItemMixin() {
    }

    private void init$AxiomChildNodeMixin() {
    }

    private void init$DOMNSAwareNamedNodeMixin() {
    }

    private void init$AxiomNamedInformationItemMixin() {
    }

    private static void clinit$AxiomElementMixin() {
        XMLNS = new OMNamespaceImpl("http://www.w3.org/XML/1998/namespace", "xml");
    }

    private static void clinit$AxiomContainerMixin() {
        defaultReaderConfiguration = new OMXMLStreamReaderConfiguration();
    }

    @Override
    public final NodeType coreGetNodeType() {
        return NodeType.NS_AWARE_ELEMENT;
    }

    @Override
    public final String getImplicitNamespaceURI(String prefix) {
        return prefix.equals(this.coreGetPrefix()) ? this.coreGetNamespaceURI() : null;
    }

    @Override
    public final String getImplicitPrefix(String namespaceURI) {
        return namespaceURI.equals(this.coreGetNamespaceURI()) ? this.coreGetPrefix() : null;
    }

    @Override
    public XmlInput getXmlInput(boolean cache, boolean incremental) throws StreamException {
        return null;
    }

    @Override
    public final void serializeStartEvent(XmlHandler handler) throws CoreModelException, StreamException {
        handler.startElement(this.coreGetNamespaceURI(), this.coreGetLocalName(), this.coreGetPrefix());
    }

    @Override
    public final void serializeEndEvent(XmlHandler handler) throws StreamException {
        handler.endElement();
    }

    @Override
    public void validateName(String staxPrefix, String staxLocalName, String staxNamespaceURI) {
    }

    @Override
    public final void initName(String localName, OMNamespace ns, boolean generateNSDecl) {
        this.internalSetLocalName(localName);
        this.internalSetNamespace(generateNSDecl ? NSUtil.handleNamespace(this, ns, false, true) : ns);
    }

    @Override
    public final void beforeSetLocalName() {
        this.forceExpand();
    }

    @Override
    public final int getType() {
        return 1;
    }

    @Override
    public final void setNamespaceWithNoFindInCurrentScope(OMNamespace namespace) {
        this.forceExpand();
        this.internalSetNamespace(namespace);
    }

    @Override
    public final void setNamespace(OMNamespace namespace, boolean decl) {
        this.forceExpand();
        this.internalSetNamespace(NSUtil.handleNamespace(this, namespace, false, decl));
    }

    @Override
    public final OMElement getFirstElement() {
        for (OMNode node = this.getFirstOMChild(); node != null; node = node.getNextOMSibling()) {
            if (node.getType() != 1) continue;
            return (OMElement)node;
        }
        return null;
    }

    @Override
    public final Iterator<OMElement> getChildElements() {
        return this.coreGetElements(Axis.CHILDREN, AxiomElement.class, ElementMatcher.ANY, null, null, Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    @Override
    public final Iterator<OMNamespace> getNamespacesInScope() {
        return new NamespaceIterator(this);
    }

    @Override
    public NamespaceContext getNamespaceContext(boolean detached) {
        if (detached) {
            HashMap<String, String> namespaces = new HashMap<String, String>();
            Iterator<OMNamespace> it = this.getNamespacesInScope();
            while (it.hasNext()) {
                OMNamespace ns = it.next();
                namespaces.put(ns.getPrefix(), ns.getNamespaceURI());
            }
            return new MapBasedNamespaceContext(namespaces);
        }
        return new LiveNamespaceContext(this);
    }

    @Override
    public final QName resolveQName(String qname) {
        int idx = qname.indexOf(58);
        if (idx == -1) {
            OMNamespace ns = this.getDefaultNamespace();
            return QNameCache.getQName(ns == null ? "" : ns.getNamespaceURI(), qname);
        }
        String prefix = qname.substring(0, idx);
        OMNamespace ns = this.findNamespace(null, prefix);
        return ns == null ? null : QNameCache.getQName(ns.getNamespaceURI(), qname.substring(idx + 1), prefix);
    }

    @Override
    public final String getText() {
        try {
            return this.coreGetCharacterData(ElementAction.SKIP).toString();
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final QName getTextAsQName() {
        String childText = this.getText().trim();
        return childText.length() == 0 ? null : this.resolveQName(childText);
    }

    @Override
    public Reader getTextAsStream(boolean cache) {
        if (!(this instanceof OMSourcedElement || cache && !this.isComplete())) {
            OMNode child = this.getFirstOMChild();
            if (child == null) {
                return new StringReader("");
            }
            if (child.getNextOMSibling() == null) {
                return new StringReader(child instanceof OMText ? ((OMText)child).getText() : "");
            }
        }
        try {
            XMLStreamReader reader = this.getXMLStreamReader(cache);
            if (reader.getEventType() == 7) {
                reader.next();
            }
            Reader stream2 = XMLStreamReaderUtils.getElementTextAsStream(reader, true);
            if (!cache) {
                stream2 = new FilterReader(this, stream2, reader){
                    final /* synthetic */ XMLStreamReader val$reader;
                    final /* synthetic */ DOOMNSAwareElementImpl this$0;
                    {
                        this.this$0 = this$0;
                        this.val$reader = xMLStreamReader;
                        super(arg0);
                    }

                    public void close() throws IOException {
                        try {
                            this.val$reader.close();
                        }
                        catch (XMLStreamException ex) {
                            throw new XMLStreamIOException(ex);
                        }
                    }
                };
            }
            return stream2;
        }
        catch (XMLStreamException ex) {
            throw new OMException(ex);
        }
    }

    @Override
    public void writeTextTo(Writer out, boolean cache) throws IOException {
        try {
            XMLStreamReader reader = this.getXMLStreamReader(cache);
            int depth = 0;
            while (reader.hasNext()) {
                switch (reader.next()) {
                    case 4: 
                    case 12: {
                        if (depth != 1) break;
                        out.write(reader.getText());
                        break;
                    }
                    case 1: {
                        ++depth;
                        break;
                    }
                    case 2: {
                        --depth;
                    }
                }
            }
        }
        catch (XMLStreamException ex) {
            throw new OMException(ex);
        }
    }

    @Override
    public final void setText(String text2) {
        try {
            this.coreSetCharacterData(text2, AxiomSemantics.INSTANCE);
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final void setText(QName qname) {
        this.removeChildren();
        if (qname != null) {
            OMNamespace ns = this.handleNamespace(qname.getNamespaceURI(), qname.getPrefix());
            this.getOMFactory().createOMText((OMContainer)this, ns == null ? qname.getLocalPart() : ns.getPrefix() + ":" + qname.getLocalPart());
        }
    }

    @Override
    public final void discard() {
        try {
            this.coreDiscard(true);
            this.detach();
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public <T extends OMElement> void insertChild(Sequence sequence, int pos, T newChild, boolean allowReplace) {
        if (!sequence.item(pos).isInstance(newChild)) {
            throw new IllegalArgumentException();
        }
        Class<? extends OMElement> type = sequence.item(pos);
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            if (!(child instanceof OMElement)) continue;
            if (child == newChild) {
                return;
            }
            if (type.isInstance(child)) {
                if (!allowReplace) {
                    throw new OMException("The element already has a child of type " + type.getName());
                }
                child.insertSiblingAfter(newChild);
                child.detach();
                return;
            }
            boolean isAfter = false;
            for (int i = 0; i < pos; ++i) {
                if (!sequence.item(i).isInstance(child)) continue;
                isAfter = true;
                break;
            }
            if (isAfter) continue;
            child.insertSiblingBefore(newChild);
            return;
        }
        this.addChild(newChild);
    }

    @Override
    public final OMNamespace handleNamespace(String namespaceURI, String prefix) {
        if (prefix.length() == 0 && namespaceURI.length() == 0) {
            OMNamespace namespace = this.getDefaultNamespace();
            if (namespace != null) {
                this.declareDefaultNamespace("");
            }
            return null;
        }
        OMNamespace namespace = this.findNamespace(namespaceURI, prefix);
        if (namespace == null) {
            namespace = this.declareNamespace(namespaceURI, prefix.length() > 0 ? prefix : null);
        }
        return namespace;
    }

    public final void internalAppendAttribute(OMAttribute attr) {
        this.coreSetAttribute(AxiomSemantics.ATTRIBUTE_MATCHER, (AxiomAttribute)attr, AxiomSemantics.INSTANCE);
    }

    @Override
    public final OMAttribute addAttribute(OMAttribute attr) {
        OMElement owner = attr.getOwner();
        if (owner != null) {
            if (owner == this) {
                return attr;
            }
            attr = this.getOMFactory().createOMAttribute(attr.getLocalName(), attr.getNamespace(), attr.getAttributeValue());
        }
        NSUtil.handleNamespace(this, attr.getNamespace(), true, true);
        this.internalAppendAttribute(attr);
        return attr;
    }

    @Override
    public final OMAttribute addAttribute(String localName, String value2, OMNamespace ns) {
        OMNamespace namespace = null;
        if (ns != null) {
            String namespaceURI = ns.getNamespaceURI();
            String prefix = ns.getPrefix();
            if ((namespaceURI.length() > 0 || prefix != null) && ((namespace = this.findNamespace(namespaceURI, prefix)) == null || prefix == null && namespace.getPrefix().length() == 0)) {
                namespace = new OMNamespaceImpl(namespaceURI, prefix != null ? prefix : NSUtils.generatePrefix(namespaceURI));
            }
        }
        return this.addAttribute(this.getOMFactory().createOMAttribute(localName, namespace, value2));
    }

    @Override
    public final Iterator<OMAttribute> getAllAttributes() {
        return this.coreGetAttributesByType(AxiomAttribute.class, Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    @Override
    public final OMAttribute getAttribute(QName qname) {
        return (AxiomAttribute)this.coreGetAttribute(AxiomSemantics.ATTRIBUTE_MATCHER, qname.getNamespaceURI(), qname.getLocalPart());
    }

    @Override
    public final String getAttributeValue(QName qname) {
        OMAttribute attr = this.getAttribute(qname);
        return attr == null ? null : attr.getAttributeValue();
    }

    @Override
    public final void _setAttributeValue(QName qname, String value2) {
        OMAttribute attr = this.getAttribute(qname);
        if (attr != null) {
            attr.setAttributeValue(value2);
        } else {
            this.addAttribute(qname.getLocalPart(), value2, new OMNamespaceImpl(qname.getNamespaceURI(), qname.getLocalPart()));
        }
    }

    @Override
    public final void removeAttribute(OMAttribute attr) {
        if (attr.getOwner() != this) {
            throw new OMException("The attribute is not owned by this element");
        }
        ((AxiomAttribute)attr).coreRemove(AxiomSemantics.INSTANCE);
    }

    @Override
    public final void addNamespaceDeclaration(OMNamespace ns) {
        AxiomNamespaceDeclaration decl = this.getNodeFactory().createNamespaceDeclaration();
        decl.setDeclaredNamespace(ns);
        this.coreSetAttribute(AxiomSemantics.NAMESPACE_DECLARATION_MATCHER, decl, AxiomSemantics.INSTANCE);
    }

    @Override
    public final Iterator<OMNamespace> getAllDeclaredNamespaces() {
        return this.coreGetAttributesByType(AxiomNamespaceDeclaration.class, NamespaceDeclarationMapper.INSTANCE, AxiomSemantics.INSTANCE);
    }

    @Override
    public final OMNamespace declareNamespace(OMNamespace namespace) {
        String prefix = namespace.getPrefix();
        String namespaceURI = namespace.getNamespaceURI();
        if (prefix == null) {
            prefix = NSUtils.generatePrefix(namespaceURI);
            namespace = new OMNamespaceImpl(namespaceURI, prefix);
        }
        if (prefix.length() > 0 && namespaceURI.length() == 0) {
            throw new IllegalArgumentException("Cannot bind a prefix to the empty namespace name");
        }
        this.addNamespaceDeclaration(namespace);
        return namespace;
    }

    @Override
    public final OMNamespace declareNamespace(String uri, String prefix) {
        return this.declareNamespace(new OMNamespaceImpl(uri, prefix));
    }

    @Override
    public final OMNamespace declareDefaultNamespace(String uri) {
        OMNamespace elementNamespace = this.getNamespace();
        if (elementNamespace == null && uri.length() > 0 || elementNamespace != null && elementNamespace.getPrefix().length() == 0 && !elementNamespace.getNamespaceURI().equals(uri)) {
            throw new OMException("Attempt to add a namespace declaration that conflicts with the namespace information of the element");
        }
        OMNamespaceImpl namespace = new OMNamespaceImpl(uri == null ? "" : uri, "");
        this.addNamespaceDeclaration(namespace);
        return namespace;
    }

    @Override
    public final void undeclarePrefix(String prefix) {
        this.addNamespaceDeclaration(new OMNamespaceImpl("", prefix));
    }

    @Override
    public final OMNamespace findNamespace(String uri, String prefix) {
        OMNamespace namespace = this.findDeclaredNamespace(uri, prefix);
        if (namespace != null) {
            return namespace;
        }
        OMContainer parent = this.getParent();
        if (parent != null && parent instanceof OMElement && (namespace = ((OMElement)parent).findNamespace(uri, prefix)) != null && this.findDeclaredNamespace(null, namespace.getPrefix()) != null) {
            namespace = null;
        }
        return namespace;
    }

    private OMNamespace findDeclaredNamespace(String uri, String prefix) {
        for (CoreAttribute attr = this.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
            if (!(attr instanceof AxiomNamespaceDeclaration)) continue;
            OMNamespace namespace = ((AxiomNamespaceDeclaration)attr).getDeclaredNamespace();
            if (prefix != null && !prefix.equals(namespace.getPrefix()) || uri != null && !uri.equals(namespace.getNamespaceURI())) continue;
            return namespace;
        }
        if ((prefix == null || prefix.equals("xml")) && (uri == null || uri.equals("http://www.w3.org/XML/1998/namespace"))) {
            return XMLNS;
        }
        return null;
    }

    @Override
    public final OMNamespace findNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        for (CoreAttribute attr = this.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
            AxiomNamespaceDeclaration nsDecl;
            if (!(attr instanceof AxiomNamespaceDeclaration) || !(nsDecl = (AxiomNamespaceDeclaration)attr).coreGetDeclaredPrefix().equals(prefix)) continue;
            OMNamespace ns = nsDecl.getDeclaredNamespace();
            if (ns.getNamespaceURI().length() == 0) {
                return null;
            }
            return ns;
        }
        OMContainer parent = this.getParent();
        if (parent instanceof OMElement) {
            return ((OMElement)parent).findNamespaceURI(prefix);
        }
        return null;
    }

    @Override
    public final OMNamespace getDefaultNamespace() {
        return this.findNamespaceURI("");
    }

    @Override
    public final String toStringWithConsume() throws XMLStreamException {
        StringWriter sw = new StringWriter();
        this.serializeAndConsume(sw);
        return sw.toString();
    }

    @Override
    public final String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.serialize(sw);
        }
        catch (XMLStreamException ex) {
            throw new OMException("Failed to serialize node", ex);
        }
        return sw.toString();
    }

    @Override
    public final OMElement cloneOMElement() {
        return (OMElement)this.clone(null);
    }

    @Override
    public final void buildWithAttachments() {
        if (this.getState() == 2) {
            this.build();
        }
        if (this.isExpanded()) {
            for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
                child.buildWithAttachments();
            }
        }
    }

    @Override
    public void checkChild(OMNode child) {
    }

    @Override
    public final void setNamespace(OMNamespace namespace) {
        this.setNamespace(namespace, true);
    }

    @Override
    public final void setLineNumber(int lineNumber) {
    }

    @Override
    public final int getLineNumber() {
        return 0;
    }

    @Override
    public final CoreElement getContextElement() {
        CoreParentNode parent = this.coreGetParent();
        return parent instanceof CoreElement ? (CoreElement)parent : null;
    }

    @Override
    public Iterator<OMNode> getDescendants(boolean includeSelf) {
        return this.coreGetNodes(includeSelf ? Axis.DESCENDANTS_OR_SELF : Axis.DESCENDANTS, AxiomChildNode.class, Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    @Override
    public final void normalize(DOMConfigurationImpl config) {
        if (config.isEnabled(128)) {
            OMNamespace namespace = this.getNamespace();
            if (namespace == null) {
                if (this.getDefaultNamespace() != null) {
                    this.declareDefaultNamespace("");
                }
            } else {
                OMNamespace namespaceForPrefix = this.findNamespaceURI(namespace.getPrefix());
                if (namespaceForPrefix == null || !namespaceForPrefix.getNamespaceURI().equals(namespace.getNamespaceURI())) {
                    this.declareNamespace(namespace);
                }
            }
        }
    }

    @Override
    public final OMXMLParserWrapper getBuilder() {
        BuilderImpl builder = (BuilderImpl)this.coreGetBuilder();
        if (builder == null) {
            return null;
        }
        OMXMLParserWrapper facade = (OMXMLParserWrapper)builder.getFacade();
        if (facade == null) {
            facade = new OMXMLParserWrapperImpl(builder, null);
        }
        return facade;
    }

    @Override
    public final XMLStreamReader getXMLStreamReader() {
        return this.getXMLStreamReader(true);
    }

    @Override
    public final XMLStreamReader getXMLStreamReaderWithoutCaching() {
        return this.getXMLStreamReader(false);
    }

    @Override
    public final XMLStreamReader getXMLStreamReader(boolean cache) {
        return this.getXMLStreamReader(cache, defaultReaderConfiguration);
    }

    @Override
    public XMLStreamReader getXMLStreamReader(boolean cache, OMXMLStreamReaderConfiguration configuration) {
        return this.defaultGetXMLStreamReader(cache, configuration);
    }

    @Override
    public final XMLStreamReader defaultGetXMLStreamReader(boolean cache, OMXMLStreamReaderConfiguration configuration) {
        CoreElement contextElement;
        StAXPivot pivot;
        XmlHandler handler = pivot = new StAXPivot(AxiomXMLStreamReaderExtensionFactory.INSTANCE);
        if (configuration.isNamespaceURIInterning()) {
            handler = new NamespaceURIInterningFilterHandler(handler);
        }
        if ((contextElement = this.getContextElement()) != null) {
            if (configuration.isPreserveNamespaceContext()) {
                handler = new NamespaceContextPreservationFilterHandler(handler, contextElement);
            } else {
                Iterator<OMNamespace> it = ((OMElement)((Object)contextElement)).getNamespacesInScope();
                while (it.hasNext()) {
                    OMNamespace ns = it.next();
                    pivot.setPrefix(ns.getPrefix(), ns.getNamespaceURI());
                }
                handler = new XsiTypeFilterHandler(handler, contextElement);
            }
        }
        try {
            pivot.setReader(this.coreGetReader(handler, cache, true));
        }
        catch (StreamException ex) {
            throw new OMException(ex);
        }
        return pivot;
    }

    @Override
    public final XOPEncoded<XMLStreamReader> getXOPEncodedStreamReader(boolean cache) {
        StAXPivot pivot = new StAXPivot(AxiomXMLStreamReaderExtensionFactory.INSTANCE);
        XOPEncodingFilterHandler encoder = new XOPEncodingFilterHandler(pivot, ContentIDGenerator.DEFAULT, OptimizationPolicy.ALL);
        try {
            pivot.setReader(this.coreGetReader(encoder, cache, true));
        }
        catch (StreamException ex) {
            throw new OMException(ex);
        }
        return new XOPEncoded<XMLStreamReader>(pivot, encoder);
    }

    @Override
    public final AxiomChildNode prepareNewChild(OMNode omNode) {
        AxiomChildNode child = omNode.getOMFactory().getMetaFactory().equals(this.getOMFactory().getMetaFactory()) ? (AxiomChildNode)omNode : (AxiomChildNode)this.getOMFactory().importInformationItem(omNode);
        this.checkChild(omNode);
        return child;
    }

    @Override
    public final void addChild(OMNode omNode) {
        try {
            this.coreAppendChild(this.prepareNewChild(omNode));
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public OMNode getFirstOMChild() {
        try {
            return (OMNode)((Object)this.coreGetFirstChild());
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public void removeChildren() {
        try {
            this.coreRemoveChildren(AxiomSemantics.INSTANCE);
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public Iterator<OMNode> getChildren() {
        return this.coreGetNodes(Axis.CHILDREN, AxiomChildNode.class, Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    @Override
    public Iterator<OMElement> getChildrenWithLocalName(String localName) {
        return this.coreGetElements(Axis.CHILDREN, AxiomElement.class, ElementMatcher.BY_LOCAL_NAME, null, localName, Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    @Override
    public Iterator<OMElement> getChildrenWithNamespaceURI(String uri) {
        return this.coreGetElements(Axis.CHILDREN, AxiomElement.class, ElementMatcher.BY_NAMESPACE_URI, uri, null, Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    @Override
    public Iterator<OMElement> getChildrenWithName(QName name) {
        return this.coreGetElements(Axis.CHILDREN, AxiomElement.class, ElementMatcher.BY_QNAME, name.getNamespaceURI(), name.getLocalPart(), Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    @Override
    public final OMElement getFirstChildWithName(QName name) throws OMException {
        try {
            for (CoreChildNode child = this.coreGetFirstChild(); child != null; child = child.coreGetNextSibling()) {
                if (!(child instanceof AxiomElement)) continue;
                AxiomElement element = (AxiomElement)child;
                if (!name.getLocalPart().equals(element.coreGetLocalName()) || !name.getNamespaceURI().equals(element.coreGetNamespaceURI())) continue;
                return element;
            }
            return null;
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final SAXSource getSAXSource(boolean cache) {
        return new SAXSource(new XMLReaderImpl(this, cache), new InputSource());
    }

    @Override
    public final SAXResult getSAXResult() {
        XmlHandlerContentHandler handler = new XmlHandlerContentHandler(new SAXResultContentHandler(this), true);
        SAXResult result = new SAXResult();
        result.setHandler(handler);
        result.setLexicalHandler(handler);
        return result;
    }

    private void serialize(XmlHandler handler, NamespaceContextProvider namespaceContextProvider, OMOutputFormat format, boolean cache) throws StreamException {
        handler = new XmlDeclarationRewriterHandler(handler, format);
        CoreElement contextElement = this.getContextElement();
        if (contextElement != null) {
            handler = new XsiTypeFilterHandler(handler, contextElement);
        }
        handler = new NamespaceRepairingFilterHandler(handler, namespaceContextProvider, true);
        try {
            this.internalSerialize(handler, cache);
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    private void serializeAndSurfaceIOException(XmlHandler handler, NamespaceContextProvider namespaceContextProvider, OMOutputFormat format, boolean cache) throws IOException {
        try {
            this.serialize(handler, namespaceContextProvider, format, cache);
        }
        catch (StreamException ex) {
            Throwable cause2 = ex.getCause();
            if (cause2 instanceof IOException) {
                throw (IOException)cause2;
            }
            throw new OMException(ex);
        }
    }

    @Override
    public final void serialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        try {
            this.serialize(new XMLStreamWriterHandler(writer), new XMLStreamWriterNamespaceContextProvider(writer), new OMOutputFormat(), cache);
        }
        catch (StreamException ex) {
            throw AxiomExceptionTranslator.toXMLStreamException(ex);
        }
    }

    @Override
    public final void serialize(Writer writer, boolean cache) throws IOException {
        this.serialize(writer, new OMOutputFormat(), cache);
    }

    @Override
    public final void serialize(OutputStream out, boolean cache) throws IOException {
        this.serialize(out, new OMOutputFormat(), cache);
    }

    @Override
    public final void serialize(OutputStream out, OMOutputFormat format, boolean cache) throws IOException {
        XmlHandler handler;
        XOPEncodingFilterHandler encoder;
        OutputStream rootPartOutputStream;
        OMMultipartWriter multipartWriter;
        String encoding = format.getCharSetEncoding();
        if (encoding == null) {
            encoding = "utf-8";
            format.setCharSetEncoding("utf-8");
        }
        if (format.isOptimized()) {
            multipartWriter = new OMMultipartWriter(out, format);
            rootPartOutputStream = multipartWriter.writeRootPart();
        } else {
            multipartWriter = null;
            rootPartOutputStream = out;
        }
        Serializer serializer = new Serializer(rootPartOutputStream, encoding);
        if (format.isOptimized()) {
            encoder = new XOPEncodingFilterHandler(serializer, new ContentIDGeneratorImpl(format), new OptimizationPolicyImpl(format));
            handler = encoder;
        } else {
            handler = serializer;
            encoder = null;
        }
        this.serializeAndSurfaceIOException(handler, null, format, cache);
        if (encoder != null) {
            rootPartOutputStream.close();
            for (String contentID : encoder.getContentIDs()) {
                DataHandler dataHandler = encoder.getDataHandler(contentID);
                if (cache || !(dataHandler instanceof PartDataHandler)) {
                    multipartWriter.writePart(dataHandler, contentID);
                    continue;
                }
                OutputStream part = multipartWriter.writePart(dataHandler.getContentType(), contentID);
                IOUtils.copy(((PartDataHandler)dataHandler).getPart().getInputStream(false), part, -1L);
                part.close();
            }
            multipartWriter.complete();
        }
    }

    @Override
    public final void serialize(Writer writer, OMOutputFormat format, boolean cache) throws IOException {
        this.serializeAndSurfaceIOException(new Serializer(writer), null, format, cache);
    }

    @Override
    public final void serialize(OutputStream output) throws XMLStreamException {
        this.serialize(output, new OMOutputFormat());
    }

    @Override
    public final void serializeAndConsume(OutputStream output) throws XMLStreamException {
        this.serializeAndConsume(output, new OMOutputFormat());
    }

    @Override
    public final void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        try {
            this.serialize(output, format, true);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public final void serializeAndConsume(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        try {
            this.serialize(output, format, false);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public final void serialize(Writer writer) throws XMLStreamException {
        try {
            this.serialize(writer, true);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public final void serializeAndConsume(Writer writer) throws XMLStreamException {
        try {
            this.serialize(writer, false);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public final void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        try {
            this.serialize(writer, format, true);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public final void serializeAndConsume(Writer writer, OMOutputFormat format) throws XMLStreamException {
        try {
            this.serialize(writer, format, false);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public final void close(boolean build) {
        Builder builder = this.coreGetBuilder();
        if (build) {
            this.build();
        }
        if (builder != null) {
            builder.close();
        }
    }

    @Override
    public final boolean isComplete() {
        try {
            switch (this.getState()) {
                case 5: {
                    return true;
                }
                case 0: {
                    if (this.isExpanded()) {
                        for (CoreChildNode child = this.coreGetFirstChild(); child != null; child = child.coreGetNextSibling()) {
                            if (child instanceof AxiomSourcedElement || ((AxiomSerializable)((Object)child)).isComplete()) continue;
                            return false;
                        }
                    }
                    return true;
                }
            }
            return false;
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final void build() {
        try {
            switch (this.getState()) {
                case 3: 
                case 4: {
                    throw new NodeUnavailableException();
                }
                case 0: {
                    if (!this.isExpanded()) break;
                }
                case 2: {
                    for (CoreChildNode child = this.coreGetFirstChildIfAvailable(); child != null; child = child.coreGetNextSibling()) {
                        if (child instanceof AxiomSourcedElement) continue;
                        ((AxiomSerializable)((Object)child)).build();
                    }
                    this.coreBuild();
                }
            }
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.serialize(xmlWriter, true);
    }

    @Override
    public final void serializeAndConsume(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.serialize(xmlWriter, false);
    }

    @Override
    public OMFactory getOMFactory() {
        return this.getMetaFactory().getOMFactory();
    }

    @Override
    public final OMInformationItem clone(OMCloneOptions options) {
        try {
            return (OMInformationItem)((Object)this.coreClone(AxiomSemantics.CLONE_POLICY, options));
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final AxiomNodeFactory getNodeFactory() {
        return DOOMNodeFactoryImpl.INSTANCE;
    }

    @Override
    public final OMMetaFactory getMetaFactory() {
        return DOOMNodeFactoryImpl.INSTANCE;
    }

    @Override
    public final OMContainer getParent() {
        CoreParentNode parent = this.coreGetParent();
        return parent instanceof OMContainer ? (OMContainer)((Object)parent) : null;
    }

    @Override
    public final OMNode getNextOMSibling() {
        try {
            return (OMNode)((Object)this.coreGetNextSibling());
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final OMNode getPreviousOMSibling() {
        return (OMNode)((Object)this.coreGetPreviousSibling());
    }

    @Override
    public final void insertSiblingAfter(OMNode sibling) throws OMException {
        try {
            AxiomContainer parent = (AxiomContainer)this.getParent();
            if (parent == null) {
                throw new OMException("Parent can not be null");
            }
            this.coreInsertSiblingAfter(parent.prepareNewChild(sibling));
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final void insertSiblingBefore(OMNode sibling) throws OMException {
        try {
            AxiomContainer parent = (AxiomContainer)this.getParent();
            if (parent == null) {
                throw new OMException("Parent can not be null");
            }
            this.coreInsertSiblingBefore(parent.prepareNewChild(sibling));
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final OMNode detach() {
        if (!this.coreHasParent()) {
            throw new OMException("Nodes that don't have a parent can not be detached");
        }
        this.coreDetach(AxiomSemantics.INSTANCE);
        return this;
    }

    @Override
    public final String getLocalName() {
        return this.coreGetLocalName();
    }

    @Override
    public final String getNamespaceURI() {
        String namespaceURI = this.coreGetNamespaceURI();
        return namespaceURI.length() == 0 ? null : namespaceURI;
    }

    @Override
    public final String getPrefix() {
        String prefix = this.coreGetPrefix();
        return prefix.length() == 0 ? null : prefix;
    }

    @Override
    public final void setPrefix(String prefix) throws DOMException {
        if (prefix == null) {
            prefix = "";
        }
        if (this.coreGetNamespaceURI().length() == 0 && prefix.length() > 0) {
            throw DOMExceptionUtil.newDOMException((short)14);
        }
        this.coreSetPrefix(prefix);
    }

    @Override
    public final String internalGetName() {
        String prefix = this.coreGetPrefix();
        String localName = this.coreGetLocalName();
        if (prefix.length() == 0) {
            return localName;
        }
        return prefix + ":" + localName;
    }

    @Override
    public final void initName(String namespaceURI, String localName, String prefix, Object namespaceHelper) {
        this.localName = localName;
        this.namespace = ((OMNamespaceCache)namespaceHelper).getOMNamespace(namespaceURI, prefix);
    }

    @Override
    public final void internalSetNamespace(OMNamespace namespace) {
        this.namespace = namespace;
    }

    @Override
    public final String internalGetLocalName() {
        return this.localName;
    }

    @Override
    public final void internalSetLocalName(String localName) {
        this.localName = localName;
    }

    @Override
    public OMNamespace getNamespace() {
        return this.defaultGetNamespace();
    }

    @Override
    public final OMNamespace defaultGetNamespace() {
        return this.namespace;
    }

    @Override
    public final void setLocalName(String localName) {
        this.beforeSetLocalName();
        this.localName = localName;
    }

    @Override
    public QName getQName() {
        return this.defaultGetQName();
    }

    @Override
    public final QName defaultGetQName() {
        return QNameCache.getQName(this.namespace == null ? "" : this.namespace.getNamespaceURI(), this.localName, this.namespace == null ? "" : this.namespace.getPrefix());
    }

    @Override
    public final boolean hasName(QName name) {
        if (name.getLocalPart().equals(this.getLocalName())) {
            OMNamespace ns = this.getNamespace();
            return ns == null && name.getNamespaceURI().length() == 0 || ns != null && name.getNamespaceURI().equals(ns.getNamespaceURI());
        }
        return false;
    }

    @Override
    public final String coreGetNamespaceURI() {
        OMNamespace namespace = this.getNamespace();
        return namespace == null ? "" : namespace.getNamespaceURI();
    }

    @Override
    public final String coreGetPrefix() {
        OMNamespace namespace = this.getNamespace();
        return namespace == null ? "" : namespace.getPrefix();
    }

    @Override
    public final void coreSetName(String namespaceURI, String localName, String prefix) {
        this.localName = localName;
        this.namespace = namespaceURI.length() == 0 && prefix.length() == 0 ? null : new OMNamespaceImpl(namespaceURI, prefix);
    }

    @Override
    public final void initName(CoreNamedNode other) {
        AxiomNamedInformationItem o = (AxiomNamedInformationItem)other;
        if (o instanceof AxiomSourcedElement && ((AxiomElement)this).isExpanded()) {
            this.localName = o.coreGetLocalName();
            this.namespace = o.getNamespace();
        } else {
            this.localName = o.internalGetLocalName();
            this.namespace = o.defaultGetNamespace();
        }
    }

    public void updateLocalName() {
        throw new IllegalStateException();
    }

    @Override
    public final String coreGetLocalName() {
        if (this.localName == null) {
            this.updateLocalName();
        }
        return this.localName;
    }

    @Override
    public final void coreSetPrefix(String prefix) {
        OMNamespace ns = this.getNamespace();
        if (ns == null) {
            if (prefix.length() > 0) {
                throw new OMException("Cannot set prefix on an information item without namespace");
            }
        } else {
            this.internalSetNamespace(new OMNamespaceImpl(ns.getNamespaceURI(), prefix));
        }
    }
}

