/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.core.Axis;
import org.apache.axiom.core.Builder;
import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.ElementMatcher;
import org.apache.axiom.core.Mappers;
import org.apache.axiom.core.impl.builder.BuilderImpl;
import org.apache.axiom.core.stream.NamespaceContextProvider;
import org.apache.axiom.core.stream.NamespaceRepairingFilterHandler;
import org.apache.axiom.core.stream.NamespaceURIInterningFilterHandler;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.sax.input.XmlHandlerContentHandler;
import org.apache.axiom.core.stream.serializer.Serializer;
import org.apache.axiom.core.stream.stax.pull.output.StAXPivot;
import org.apache.axiom.core.stream.stax.push.input.XMLStreamWriterNamespaceContextProvider;
import org.apache.axiom.mime.PartDataHandler;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMInformationItem;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMSerializable;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.OMXMLStreamReaderConfiguration;
import org.apache.axiom.om.XOPEncoded;
import org.apache.axiom.om.impl.OMMultipartWriter;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.AxiomSemantics;
import org.apache.axiom.om.impl.common.SAXResultContentHandler;
import org.apache.axiom.om.impl.common.builder.OMXMLParserWrapperImpl;
import org.apache.axiom.om.impl.intf.AxiomChildNode;
import org.apache.axiom.om.impl.intf.AxiomContainer;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.om.impl.llom.AxiomCoreParentNodeImpl;
import org.apache.axiom.om.impl.stream.NamespaceContextPreservationFilterHandler;
import org.apache.axiom.om.impl.stream.XmlDeclarationRewriterHandler;
import org.apache.axiom.om.impl.stream.XsiTypeFilterHandler;
import org.apache.axiom.om.impl.stream.sax.XMLReaderImpl;
import org.apache.axiom.om.impl.stream.stax.pull.AxiomXMLStreamReaderExtensionFactory;
import org.apache.axiom.om.impl.stream.stax.push.XMLStreamWriterHandler;
import org.apache.axiom.om.impl.stream.xop.ContentIDGenerator;
import org.apache.axiom.om.impl.stream.xop.ContentIDGeneratorImpl;
import org.apache.axiom.om.impl.stream.xop.OptimizationPolicy;
import org.apache.axiom.om.impl.stream.xop.OptimizationPolicyImpl;
import org.apache.axiom.om.impl.stream.xop.XOPEncodingFilterHandler;
import org.apache.axiom.util.io.IOUtils;
import org.xml.sax.InputSource;

public abstract class AxiomContainerImpl
extends AxiomCoreParentNodeImpl
implements AxiomContainer,
OMContainer,
OMSerializable,
OMInformationItem {
    private static final OMXMLStreamReaderConfiguration defaultReaderConfiguration;

    public AxiomContainerImpl() {
        this.init$AxiomContainerMixin();
    }

    static {
        AxiomContainerImpl.clinit$AxiomContainerMixin();
    }

    private void init$AxiomContainerMixin() {
    }

    private static void clinit$AxiomContainerMixin() {
        defaultReaderConfiguration = new OMXMLStreamReaderConfiguration();
    }

    @Override
    public final OMXMLParserWrapper getBuilder() {
        BuilderImpl builder = (BuilderImpl)this.coreGetBuilder();
        if (builder == null) {
            return null;
        }
        OMXMLParserWrapper facade = (OMXMLParserWrapper)builder.getFacade();
        if (facade == null) {
            facade = new OMXMLParserWrapperImpl(builder, null);
        }
        return facade;
    }

    @Override
    public final XMLStreamReader getXMLStreamReader() {
        return this.getXMLStreamReader(true);
    }

    @Override
    public final XMLStreamReader getXMLStreamReaderWithoutCaching() {
        return this.getXMLStreamReader(false);
    }

    @Override
    public final XMLStreamReader getXMLStreamReader(boolean cache) {
        return this.getXMLStreamReader(cache, defaultReaderConfiguration);
    }

    @Override
    public XMLStreamReader getXMLStreamReader(boolean cache, OMXMLStreamReaderConfiguration configuration) {
        return this.defaultGetXMLStreamReader(cache, configuration);
    }

    @Override
    public final XMLStreamReader defaultGetXMLStreamReader(boolean cache, OMXMLStreamReaderConfiguration configuration) {
        CoreElement contextElement;
        StAXPivot pivot;
        XmlHandler handler = pivot = new StAXPivot(AxiomXMLStreamReaderExtensionFactory.INSTANCE);
        if (configuration.isNamespaceURIInterning()) {
            handler = new NamespaceURIInterningFilterHandler(handler);
        }
        if ((contextElement = this.getContextElement()) != null) {
            if (configuration.isPreserveNamespaceContext()) {
                handler = new NamespaceContextPreservationFilterHandler(handler, contextElement);
            } else {
                Iterator<OMNamespace> it = ((OMElement)((Object)contextElement)).getNamespacesInScope();
                while (it.hasNext()) {
                    OMNamespace ns = it.next();
                    pivot.setPrefix(ns.getPrefix(), ns.getNamespaceURI());
                }
                handler = new XsiTypeFilterHandler(handler, contextElement);
            }
        }
        try {
            pivot.setReader(this.coreGetReader(handler, cache, true));
        }
        catch (StreamException ex) {
            throw new OMException(ex);
        }
        return pivot;
    }

    @Override
    public final XOPEncoded<XMLStreamReader> getXOPEncodedStreamReader(boolean cache) {
        StAXPivot pivot = new StAXPivot(AxiomXMLStreamReaderExtensionFactory.INSTANCE);
        XOPEncodingFilterHandler encoder = new XOPEncodingFilterHandler(pivot, ContentIDGenerator.DEFAULT, OptimizationPolicy.ALL);
        try {
            pivot.setReader(this.coreGetReader(encoder, cache, true));
        }
        catch (StreamException ex) {
            throw new OMException(ex);
        }
        return new XOPEncoded<XMLStreamReader>(pivot, encoder);
    }

    @Override
    public final AxiomChildNode prepareNewChild(OMNode omNode) {
        AxiomChildNode child = omNode.getOMFactory().getMetaFactory().equals(this.getOMFactory().getMetaFactory()) ? (AxiomChildNode)omNode : (AxiomChildNode)this.getOMFactory().importInformationItem(omNode);
        this.checkChild(omNode);
        return child;
    }

    @Override
    public final void addChild(OMNode omNode) {
        try {
            this.coreAppendChild(this.prepareNewChild(omNode));
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public OMNode getFirstOMChild() {
        try {
            return (OMNode)((Object)this.coreGetFirstChild());
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public void removeChildren() {
        try {
            this.coreRemoveChildren(AxiomSemantics.INSTANCE);
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public Iterator<OMNode> getChildren() {
        return this.coreGetNodes(Axis.CHILDREN, AxiomChildNode.class, Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    @Override
    public Iterator<OMElement> getChildrenWithLocalName(String localName) {
        return this.coreGetElements(Axis.CHILDREN, AxiomElement.class, ElementMatcher.BY_LOCAL_NAME, null, localName, Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    @Override
    public Iterator<OMElement> getChildrenWithNamespaceURI(String uri) {
        return this.coreGetElements(Axis.CHILDREN, AxiomElement.class, ElementMatcher.BY_NAMESPACE_URI, uri, null, Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    @Override
    public Iterator<OMElement> getChildrenWithName(QName name) {
        return this.coreGetElements(Axis.CHILDREN, AxiomElement.class, ElementMatcher.BY_QNAME, name.getNamespaceURI(), name.getLocalPart(), Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    @Override
    public final OMElement getFirstChildWithName(QName name) throws OMException {
        try {
            for (CoreChildNode child = this.coreGetFirstChild(); child != null; child = child.coreGetNextSibling()) {
                if (!(child instanceof AxiomElement)) continue;
                AxiomElement element = (AxiomElement)child;
                if (!name.getLocalPart().equals(element.coreGetLocalName()) || !name.getNamespaceURI().equals(element.coreGetNamespaceURI())) continue;
                return element;
            }
            return null;
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final SAXSource getSAXSource(boolean cache) {
        return new SAXSource(new XMLReaderImpl(this, cache), new InputSource());
    }

    @Override
    public final SAXResult getSAXResult() {
        XmlHandlerContentHandler handler = new XmlHandlerContentHandler(new SAXResultContentHandler(this), true);
        SAXResult result = new SAXResult();
        result.setHandler(handler);
        result.setLexicalHandler(handler);
        return result;
    }

    private void serialize(XmlHandler handler, NamespaceContextProvider namespaceContextProvider, OMOutputFormat format, boolean cache) throws StreamException {
        handler = new XmlDeclarationRewriterHandler(handler, format);
        CoreElement contextElement = this.getContextElement();
        if (contextElement != null) {
            handler = new XsiTypeFilterHandler(handler, contextElement);
        }
        handler = new NamespaceRepairingFilterHandler(handler, namespaceContextProvider, true);
        try {
            this.internalSerialize(handler, cache);
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    private void serializeAndSurfaceIOException(XmlHandler handler, NamespaceContextProvider namespaceContextProvider, OMOutputFormat format, boolean cache) throws IOException {
        try {
            this.serialize(handler, namespaceContextProvider, format, cache);
        }
        catch (StreamException ex) {
            Throwable cause2 = ex.getCause();
            if (cause2 instanceof IOException) {
                throw (IOException)cause2;
            }
            throw new OMException(ex);
        }
    }

    @Override
    public final void serialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        try {
            this.serialize(new XMLStreamWriterHandler(writer), new XMLStreamWriterNamespaceContextProvider(writer), new OMOutputFormat(), cache);
        }
        catch (StreamException ex) {
            throw AxiomExceptionTranslator.toXMLStreamException(ex);
        }
    }

    @Override
    public final void serialize(Writer writer, boolean cache) throws IOException {
        this.serialize(writer, new OMOutputFormat(), cache);
    }

    @Override
    public final void serialize(OutputStream out, boolean cache) throws IOException {
        this.serialize(out, new OMOutputFormat(), cache);
    }

    @Override
    public final void serialize(OutputStream out, OMOutputFormat format, boolean cache) throws IOException {
        XmlHandler handler;
        XOPEncodingFilterHandler encoder;
        OutputStream rootPartOutputStream;
        OMMultipartWriter multipartWriter;
        String encoding = format.getCharSetEncoding();
        if (encoding == null) {
            encoding = "utf-8";
            format.setCharSetEncoding("utf-8");
        }
        if (format.isOptimized()) {
            multipartWriter = new OMMultipartWriter(out, format);
            rootPartOutputStream = multipartWriter.writeRootPart();
        } else {
            multipartWriter = null;
            rootPartOutputStream = out;
        }
        Serializer serializer = new Serializer(rootPartOutputStream, encoding);
        if (format.isOptimized()) {
            encoder = new XOPEncodingFilterHandler(serializer, new ContentIDGeneratorImpl(format), new OptimizationPolicyImpl(format));
            handler = encoder;
        } else {
            handler = serializer;
            encoder = null;
        }
        this.serializeAndSurfaceIOException(handler, null, format, cache);
        if (encoder != null) {
            rootPartOutputStream.close();
            for (String contentID : encoder.getContentIDs()) {
                DataHandler dataHandler = encoder.getDataHandler(contentID);
                if (cache || !(dataHandler instanceof PartDataHandler)) {
                    multipartWriter.writePart(dataHandler, contentID);
                    continue;
                }
                OutputStream part = multipartWriter.writePart(dataHandler.getContentType(), contentID);
                IOUtils.copy(((PartDataHandler)dataHandler).getPart().getInputStream(false), part, -1L);
                part.close();
            }
            multipartWriter.complete();
        }
    }

    @Override
    public final void serialize(Writer writer, OMOutputFormat format, boolean cache) throws IOException {
        this.serializeAndSurfaceIOException(new Serializer(writer), null, format, cache);
    }

    @Override
    public final void serialize(OutputStream output) throws XMLStreamException {
        this.serialize(output, new OMOutputFormat());
    }

    @Override
    public final void serializeAndConsume(OutputStream output) throws XMLStreamException {
        this.serializeAndConsume(output, new OMOutputFormat());
    }

    @Override
    public final void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        try {
            this.serialize(output, format, true);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public final void serializeAndConsume(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        try {
            this.serialize(output, format, false);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public final void serialize(Writer writer) throws XMLStreamException {
        try {
            this.serialize(writer, true);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public final void serializeAndConsume(Writer writer) throws XMLStreamException {
        try {
            this.serialize(writer, false);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public final void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        try {
            this.serialize(writer, format, true);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public final void serializeAndConsume(Writer writer, OMOutputFormat format) throws XMLStreamException {
        try {
            this.serialize(writer, format, false);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public final void close(boolean build) {
        Builder builder = this.coreGetBuilder();
        if (build) {
            this.build();
        }
        if (builder != null) {
            builder.close();
        }
    }
}

