/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.core.AttributeMatcher;
import org.apache.axiom.core.Axis;
import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.Content;
import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreDocumentFragment;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNSAwareElement;
import org.apache.axiom.core.CoreNamedNode;
import org.apache.axiom.core.CoreNamespaceDeclaration;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.CoreParentNode;
import org.apache.axiom.core.DetachPolicy;
import org.apache.axiom.core.ElementAction;
import org.apache.axiom.core.ElementMatcher;
import org.apache.axiom.core.Mapper;
import org.apache.axiom.core.Mappers;
import org.apache.axiom.core.NoParentException;
import org.apache.axiom.core.NodeConsumedException;
import org.apache.axiom.core.NodeFilter;
import org.apache.axiom.core.NodeType;
import org.apache.axiom.core.SelfRelationshipException;
import org.apache.axiom.core.Semantics;
import org.apache.axiom.core.impl.AttributeIterator;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.XmlInput;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.AxiomSemantics;
import org.apache.axiom.om.impl.common.LiveNamespaceContext;
import org.apache.axiom.om.impl.common.NSUtil;
import org.apache.axiom.om.impl.common.NamespaceDeclarationMapper;
import org.apache.axiom.om.impl.common.NamespaceIterator;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.common.builder.OMNamespaceCache;
import org.apache.axiom.om.impl.intf.AxiomAttribute;
import org.apache.axiom.om.impl.intf.AxiomChildNode;
import org.apache.axiom.om.impl.intf.AxiomContainer;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.om.impl.intf.AxiomNamedInformationItem;
import org.apache.axiom.om.impl.intf.AxiomNamespaceDeclaration;
import org.apache.axiom.om.impl.intf.AxiomSourcedElement;
import org.apache.axiom.om.impl.intf.Sequence;
import org.apache.axiom.om.impl.llom.AxiomContainerImpl;
import org.apache.axiom.util.namespace.MapBasedNamespaceContext;
import org.apache.axiom.util.stax.XMLStreamIOException;
import org.apache.axiom.util.stax.XMLStreamReaderUtils;
import org.apache.axiom.util.xml.NSUtils;
import org.apache.axiom.util.xml.QNameCache;

public class AxiomElementImpl
extends AxiomContainerImpl
implements AxiomElement,
OMElement,
OMContainer,
CoreNSAwareElement,
AxiomNamedInformationItem,
AxiomChildNode {
    private static final OMNamespace XMLNS;
    private CoreAttribute firstAttribute;
    private OMNamespace namespace;
    private String localName;
    private CoreParentNode owner;
    CoreChildNode nextSibling;
    CoreChildNode previousSibling;

    public AxiomElementImpl() {
        this.init$AxiomElementMixin();
        this.init$CoreMixedContentContainerMixin();
        this.init$CoreElementMixin();
        this.init$CoreNSAwareElementMixin();
        this.init$AxiomNamedInformationItemMixin();
        this.init$CoreChildNodeMixin();
        this.init$AxiomChildNodeMixin();
    }

    static {
        AxiomElementImpl.clinit$AxiomElementMixin();
    }

    private void init$AxiomElementMixin() {
    }

    private void init$CoreMixedContentContainerMixin() {
    }

    private void init$CoreElementMixin() {
    }

    private void init$CoreNSAwareElementMixin() {
    }

    private void init$AxiomNamedInformationItemMixin() {
    }

    private void init$CoreChildNodeMixin() {
    }

    private void init$AxiomChildNodeMixin() {
    }

    private static void clinit$AxiomElementMixin() {
        XMLNS = new OMNamespaceImpl("http://www.w3.org/XML/1998/namespace", "xml");
    }

    @Override
    public final void initName(String localName, OMNamespace ns, boolean generateNSDecl) {
        this.internalSetLocalName(localName);
        this.internalSetNamespace(generateNSDecl ? NSUtil.handleNamespace(this, ns, false, true) : ns);
    }

    @Override
    public final void beforeSetLocalName() {
        this.forceExpand();
    }

    @Override
    public final int getType() {
        return 1;
    }

    @Override
    public final void setNamespaceWithNoFindInCurrentScope(OMNamespace namespace) {
        this.forceExpand();
        this.internalSetNamespace(namespace);
    }

    @Override
    public final void setNamespace(OMNamespace namespace, boolean decl) {
        this.forceExpand();
        this.internalSetNamespace(NSUtil.handleNamespace(this, namespace, false, decl));
    }

    @Override
    public final OMElement getFirstElement() {
        for (OMNode node = this.getFirstOMChild(); node != null; node = node.getNextOMSibling()) {
            if (node.getType() != 1) continue;
            return (OMElement)node;
        }
        return null;
    }

    @Override
    public final Iterator<OMElement> getChildElements() {
        return this.coreGetElements(Axis.CHILDREN, AxiomElement.class, ElementMatcher.ANY, null, null, Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    @Override
    public final Iterator<OMNamespace> getNamespacesInScope() {
        return new NamespaceIterator(this);
    }

    @Override
    public NamespaceContext getNamespaceContext(boolean detached) {
        if (detached) {
            HashMap<String, String> namespaces = new HashMap<String, String>();
            Iterator<OMNamespace> it = this.getNamespacesInScope();
            while (it.hasNext()) {
                OMNamespace ns = it.next();
                namespaces.put(ns.getPrefix(), ns.getNamespaceURI());
            }
            return new MapBasedNamespaceContext(namespaces);
        }
        return new LiveNamespaceContext(this);
    }

    @Override
    public final QName resolveQName(String qname) {
        int idx = qname.indexOf(58);
        if (idx == -1) {
            OMNamespace ns = this.getDefaultNamespace();
            return QNameCache.getQName(ns == null ? "" : ns.getNamespaceURI(), qname);
        }
        String prefix = qname.substring(0, idx);
        OMNamespace ns = this.findNamespace(null, prefix);
        return ns == null ? null : QNameCache.getQName(ns.getNamespaceURI(), qname.substring(idx + 1), prefix);
    }

    @Override
    public final String getText() {
        try {
            return this.coreGetCharacterData(ElementAction.SKIP).toString();
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final QName getTextAsQName() {
        String childText = this.getText().trim();
        return childText.length() == 0 ? null : this.resolveQName(childText);
    }

    @Override
    public Reader getTextAsStream(boolean cache) {
        if (!(this instanceof OMSourcedElement || cache && !this.isComplete())) {
            OMNode child = this.getFirstOMChild();
            if (child == null) {
                return new StringReader("");
            }
            if (child.getNextOMSibling() == null) {
                return new StringReader(child instanceof OMText ? ((OMText)child).getText() : "");
            }
        }
        try {
            XMLStreamReader reader = this.getXMLStreamReader(cache);
            if (reader.getEventType() == 7) {
                reader.next();
            }
            Reader stream2 = XMLStreamReaderUtils.getElementTextAsStream(reader, true);
            if (!cache) {
                stream2 = new FilterReader(this, stream2, reader){
                    final /* synthetic */ XMLStreamReader val$reader;
                    final /* synthetic */ AxiomElementImpl this$0;
                    {
                        this.this$0 = this$0;
                        this.val$reader = xMLStreamReader;
                        super(arg0);
                    }

                    public void close() throws IOException {
                        try {
                            this.val$reader.close();
                        }
                        catch (XMLStreamException ex) {
                            throw new XMLStreamIOException(ex);
                        }
                    }
                };
            }
            return stream2;
        }
        catch (XMLStreamException ex) {
            throw new OMException(ex);
        }
    }

    @Override
    public void writeTextTo(Writer out, boolean cache) throws IOException {
        try {
            XMLStreamReader reader = this.getXMLStreamReader(cache);
            int depth = 0;
            while (reader.hasNext()) {
                switch (reader.next()) {
                    case 4: 
                    case 12: {
                        if (depth != 1) break;
                        out.write(reader.getText());
                        break;
                    }
                    case 1: {
                        ++depth;
                        break;
                    }
                    case 2: {
                        --depth;
                    }
                }
            }
        }
        catch (XMLStreamException ex) {
            throw new OMException(ex);
        }
    }

    @Override
    public final void setText(String text2) {
        try {
            this.coreSetCharacterData(text2, AxiomSemantics.INSTANCE);
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final void setText(QName qname) {
        this.removeChildren();
        if (qname != null) {
            OMNamespace ns = this.handleNamespace(qname.getNamespaceURI(), qname.getPrefix());
            this.getOMFactory().createOMText((OMContainer)this, ns == null ? qname.getLocalPart() : ns.getPrefix() + ":" + qname.getLocalPart());
        }
    }

    @Override
    public final void discard() {
        try {
            this.coreDiscard(true);
            this.detach();
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public <T extends OMElement> void insertChild(Sequence sequence, int pos, T newChild, boolean allowReplace) {
        if (!sequence.item(pos).isInstance(newChild)) {
            throw new IllegalArgumentException();
        }
        Class<? extends OMElement> type = sequence.item(pos);
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            if (!(child instanceof OMElement)) continue;
            if (child == newChild) {
                return;
            }
            if (type.isInstance(child)) {
                if (!allowReplace) {
                    throw new OMException("The element already has a child of type " + type.getName());
                }
                child.insertSiblingAfter(newChild);
                child.detach();
                return;
            }
            boolean isAfter = false;
            for (int i = 0; i < pos; ++i) {
                if (!sequence.item(i).isInstance(child)) continue;
                isAfter = true;
                break;
            }
            if (isAfter) continue;
            child.insertSiblingBefore(newChild);
            return;
        }
        this.addChild(newChild);
    }

    @Override
    public final OMNamespace handleNamespace(String namespaceURI, String prefix) {
        if (prefix.length() == 0 && namespaceURI.length() == 0) {
            OMNamespace namespace = this.getDefaultNamespace();
            if (namespace != null) {
                this.declareDefaultNamespace("");
            }
            return null;
        }
        OMNamespace namespace = this.findNamespace(namespaceURI, prefix);
        if (namespace == null) {
            namespace = this.declareNamespace(namespaceURI, prefix.length() > 0 ? prefix : null);
        }
        return namespace;
    }

    public final void internalAppendAttribute(OMAttribute attr) {
        this.coreSetAttribute(AxiomSemantics.ATTRIBUTE_MATCHER, (AxiomAttribute)attr, AxiomSemantics.INSTANCE);
    }

    @Override
    public final OMAttribute addAttribute(OMAttribute attr) {
        OMElement owner = attr.getOwner();
        if (owner != null) {
            if (owner == this) {
                return attr;
            }
            attr = this.getOMFactory().createOMAttribute(attr.getLocalName(), attr.getNamespace(), attr.getAttributeValue());
        }
        NSUtil.handleNamespace(this, attr.getNamespace(), true, true);
        this.internalAppendAttribute(attr);
        return attr;
    }

    @Override
    public final OMAttribute addAttribute(String localName, String value2, OMNamespace ns) {
        OMNamespace namespace = null;
        if (ns != null) {
            String namespaceURI = ns.getNamespaceURI();
            String prefix = ns.getPrefix();
            if ((namespaceURI.length() > 0 || prefix != null) && ((namespace = this.findNamespace(namespaceURI, prefix)) == null || prefix == null && namespace.getPrefix().length() == 0)) {
                namespace = new OMNamespaceImpl(namespaceURI, prefix != null ? prefix : NSUtils.generatePrefix(namespaceURI));
            }
        }
        return this.addAttribute(this.getOMFactory().createOMAttribute(localName, namespace, value2));
    }

    @Override
    public final Iterator<OMAttribute> getAllAttributes() {
        return this.coreGetAttributesByType(AxiomAttribute.class, Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    @Override
    public final OMAttribute getAttribute(QName qname) {
        return (AxiomAttribute)this.coreGetAttribute(AxiomSemantics.ATTRIBUTE_MATCHER, qname.getNamespaceURI(), qname.getLocalPart());
    }

    @Override
    public final String getAttributeValue(QName qname) {
        OMAttribute attr = this.getAttribute(qname);
        return attr == null ? null : attr.getAttributeValue();
    }

    @Override
    public final void _setAttributeValue(QName qname, String value2) {
        OMAttribute attr = this.getAttribute(qname);
        if (attr != null) {
            attr.setAttributeValue(value2);
        } else {
            this.addAttribute(qname.getLocalPart(), value2, new OMNamespaceImpl(qname.getNamespaceURI(), qname.getLocalPart()));
        }
    }

    @Override
    public final void removeAttribute(OMAttribute attr) {
        if (attr.getOwner() != this) {
            throw new OMException("The attribute is not owned by this element");
        }
        ((AxiomAttribute)attr).coreRemove(AxiomSemantics.INSTANCE);
    }

    @Override
    public final void addNamespaceDeclaration(OMNamespace ns) {
        AxiomNamespaceDeclaration decl = this.getNodeFactory().createNamespaceDeclaration();
        decl.setDeclaredNamespace(ns);
        this.coreSetAttribute(AxiomSemantics.NAMESPACE_DECLARATION_MATCHER, decl, AxiomSemantics.INSTANCE);
    }

    @Override
    public final Iterator<OMNamespace> getAllDeclaredNamespaces() {
        return this.coreGetAttributesByType(AxiomNamespaceDeclaration.class, NamespaceDeclarationMapper.INSTANCE, AxiomSemantics.INSTANCE);
    }

    @Override
    public final OMNamespace declareNamespace(OMNamespace namespace) {
        String prefix = namespace.getPrefix();
        String namespaceURI = namespace.getNamespaceURI();
        if (prefix == null) {
            prefix = NSUtils.generatePrefix(namespaceURI);
            namespace = new OMNamespaceImpl(namespaceURI, prefix);
        }
        if (prefix.length() > 0 && namespaceURI.length() == 0) {
            throw new IllegalArgumentException("Cannot bind a prefix to the empty namespace name");
        }
        this.addNamespaceDeclaration(namespace);
        return namespace;
    }

    @Override
    public final OMNamespace declareNamespace(String uri, String prefix) {
        return this.declareNamespace(new OMNamespaceImpl(uri, prefix));
    }

    @Override
    public final OMNamespace declareDefaultNamespace(String uri) {
        OMNamespace elementNamespace = this.getNamespace();
        if (elementNamespace == null && uri.length() > 0 || elementNamespace != null && elementNamespace.getPrefix().length() == 0 && !elementNamespace.getNamespaceURI().equals(uri)) {
            throw new OMException("Attempt to add a namespace declaration that conflicts with the namespace information of the element");
        }
        OMNamespaceImpl namespace = new OMNamespaceImpl(uri == null ? "" : uri, "");
        this.addNamespaceDeclaration(namespace);
        return namespace;
    }

    @Override
    public final void undeclarePrefix(String prefix) {
        this.addNamespaceDeclaration(new OMNamespaceImpl("", prefix));
    }

    @Override
    public final OMNamespace findNamespace(String uri, String prefix) {
        OMNamespace namespace = this.findDeclaredNamespace(uri, prefix);
        if (namespace != null) {
            return namespace;
        }
        OMContainer parent = this.getParent();
        if (parent != null && parent instanceof OMElement && (namespace = ((OMElement)parent).findNamespace(uri, prefix)) != null && this.findDeclaredNamespace(null, namespace.getPrefix()) != null) {
            namespace = null;
        }
        return namespace;
    }

    private OMNamespace findDeclaredNamespace(String uri, String prefix) {
        for (CoreAttribute attr = this.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
            if (!(attr instanceof AxiomNamespaceDeclaration)) continue;
            OMNamespace namespace = ((AxiomNamespaceDeclaration)attr).getDeclaredNamespace();
            if (prefix != null && !prefix.equals(namespace.getPrefix()) || uri != null && !uri.equals(namespace.getNamespaceURI())) continue;
            return namespace;
        }
        if ((prefix == null || prefix.equals("xml")) && (uri == null || uri.equals("http://www.w3.org/XML/1998/namespace"))) {
            return XMLNS;
        }
        return null;
    }

    @Override
    public final OMNamespace findNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        for (CoreAttribute attr = this.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
            AxiomNamespaceDeclaration nsDecl;
            if (!(attr instanceof AxiomNamespaceDeclaration) || !(nsDecl = (AxiomNamespaceDeclaration)attr).coreGetDeclaredPrefix().equals(prefix)) continue;
            OMNamespace ns = nsDecl.getDeclaredNamespace();
            if (ns.getNamespaceURI().length() == 0) {
                return null;
            }
            return ns;
        }
        OMContainer parent = this.getParent();
        if (parent instanceof OMElement) {
            return ((OMElement)parent).findNamespaceURI(prefix);
        }
        return null;
    }

    @Override
    public final OMNamespace getDefaultNamespace() {
        return this.findNamespaceURI("");
    }

    @Override
    public final String toStringWithConsume() throws XMLStreamException {
        StringWriter sw = new StringWriter();
        this.serializeAndConsume(sw);
        return sw.toString();
    }

    @Override
    public final String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.serialize(sw);
        }
        catch (XMLStreamException ex) {
            throw new OMException("Failed to serialize node", ex);
        }
        return sw.toString();
    }

    @Override
    public final OMElement cloneOMElement() {
        return (OMElement)this.clone(null);
    }

    @Override
    public final void buildWithAttachments() {
        if (this.getState() == 2) {
            this.build();
        }
        if (this.isExpanded()) {
            for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
                child.buildWithAttachments();
            }
        }
    }

    @Override
    public void checkChild(OMNode child) {
    }

    @Override
    public final void setNamespace(OMNamespace namespace) {
        this.setNamespace(namespace, true);
    }

    @Override
    public final void setLineNumber(int lineNumber) {
    }

    @Override
    public final int getLineNumber() {
        return 0;
    }

    @Override
    public final CoreElement getContextElement() {
        CoreParentNode parent = this.coreGetParent();
        return parent instanceof CoreElement ? (CoreElement)parent : null;
    }

    @Override
    public Iterator<OMNode> getDescendants(boolean includeSelf) {
        return this.coreGetNodes(includeSelf ? Axis.DESCENDANTS_OR_SELF : Axis.DESCENDANTS, AxiomChildNode.class, Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    @Override
    public final Object coreGetCharacterData(ElementAction elementAction) throws CoreModelException {
        return this.internalGetCharacterData(elementAction);
    }

    @Override
    public final CoreAttribute coreGetFirstAttribute() {
        this.forceExpand();
        return this.firstAttribute;
    }

    @Override
    public final void internalSetFirstAttribute(CoreAttribute firstAttribute) {
        this.firstAttribute = firstAttribute;
    }

    @Override
    public final CoreAttribute coreGetLastAttribute() {
        CoreAttribute previousAttribute = null;
        for (CoreAttribute attribute = this.firstAttribute; attribute != null; attribute = attribute.coreGetNextAttribute()) {
            previousAttribute = attribute;
        }
        return previousAttribute;
    }

    @Override
    public final CoreAttribute coreGetAttribute(AttributeMatcher matcher, String namespaceURI, String name) {
        CoreAttribute attr;
        for (attr = this.coreGetFirstAttribute(); attr != null && !matcher.matches(attr, namespaceURI, name); attr = attr.coreGetNextAttribute()) {
        }
        return attr;
    }

    @Override
    public final void coreAppendAttribute(CoreAttribute attr) {
        attr.internalRemove(null, this);
        CoreAttribute lastAttribute = this.coreGetLastAttribute();
        if (lastAttribute == null) {
            this.firstAttribute = attr;
        } else {
            lastAttribute.internalSetNextAttribute(attr);
        }
    }

    @Override
    public final void coreSetAttribute(AttributeMatcher matcher, String namespaceURI, String name, String prefix, String value2) throws CoreModelException {
        CoreAttribute attr;
        CoreAttribute previousAttr = null;
        for (attr = this.firstAttribute; attr != null && !matcher.matches(attr, namespaceURI, name); attr = attr.coreGetNextAttribute()) {
            previousAttr = attr;
        }
        if (attr == null) {
            CoreAttribute newAttr = matcher.createAttribute(this.coreGetNodeFactory().getFactory2(), namespaceURI, name, prefix, value2);
            if (previousAttr == null) {
                this.coreAppendAttribute(newAttr);
            } else {
                previousAttr.internalInsertAttributeAfter(newAttr);
            }
        } else {
            matcher.update(attr, prefix, value2);
        }
    }

    @Override
    public final CoreAttribute coreSetAttribute(AttributeMatcher matcher, CoreAttribute attr, Semantics semantics) {
        CoreAttribute existingAttr;
        if (attr.coreGetOwnerElement() == this) {
            return attr;
        }
        attr.internalRemove(null, this);
        String namespaceURI = matcher.getNamespaceURI(attr);
        String name = matcher.getName(attr);
        CoreAttribute previousAttr = null;
        for (existingAttr = this.coreGetFirstAttribute(); existingAttr != null && !matcher.matches(existingAttr, namespaceURI, name); existingAttr = existingAttr.coreGetNextAttribute()) {
            previousAttr = existingAttr;
        }
        if (existingAttr == null) {
            if (previousAttr == null) {
                this.firstAttribute = attr;
            } else {
                previousAttr.internalSetNextAttribute(attr);
            }
        } else {
            if (previousAttr == null) {
                this.firstAttribute = attr;
            } else {
                previousAttr.internalSetNextAttribute(attr);
            }
            existingAttr.internalUnsetOwnerElement(semantics.getDetachPolicy().getNewOwnerDocument(this));
            attr.internalSetNextAttribute(existingAttr.coreGetNextAttribute());
            existingAttr.internalSetNextAttribute(null);
        }
        return existingAttr;
    }

    @Override
    public final boolean coreRemoveAttribute(AttributeMatcher matcher, String namespaceURI, String name, Semantics semantics) {
        CoreAttribute att = this.coreGetAttribute(matcher, namespaceURI, name);
        if (att != null) {
            att.coreRemove(semantics);
            return true;
        }
        return false;
    }

    @Override
    public final <T extends CoreAttribute, S> Iterator<S> coreGetAttributesByType(Class<T> type, Mapper<S, ? super T> mapper, Semantics semantics) {
        return AttributeIterator.create(this, type, mapper, semantics);
    }

    @Override
    public final String coreLookupNamespaceURI(String prefix, Semantics semantics) throws CoreModelException {
        String namespaceURI;
        if (!semantics.isUseStrictNamespaceLookup() && (namespaceURI = this.getImplicitNamespaceURI(prefix)) != null) {
            return namespaceURI;
        }
        for (CoreAttribute attr = this.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
            CoreNamespaceDeclaration decl;
            if (!(attr instanceof CoreNamespaceDeclaration) || !prefix.equals((decl = (CoreNamespaceDeclaration)attr).coreGetDeclaredPrefix())) continue;
            return decl.coreGetCharacterData().toString();
        }
        CoreElement parentElement = this.coreGetParentElement();
        if (parentElement != null) {
            return parentElement.coreLookupNamespaceURI(prefix, semantics);
        }
        if (prefix.length() == 0) {
            return "";
        }
        return null;
    }

    @Override
    public final String coreLookupPrefix(String namespaceURI, Semantics semantics) throws CoreModelException {
        String prefix;
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI must not be null");
        }
        if (!semantics.isUseStrictNamespaceLookup() && (prefix = this.getImplicitPrefix(namespaceURI)) != null) {
            return prefix;
        }
        for (CoreAttribute attr = this.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
            CoreNamespaceDeclaration decl;
            if (!(attr instanceof CoreNamespaceDeclaration) || !(decl = (CoreNamespaceDeclaration)attr).coreGetCharacterData().toString().equals(namespaceURI)) continue;
            return decl.coreGetDeclaredPrefix();
        }
        CoreElement parentElement = this.coreGetParentElement();
        if (parentElement != null) {
            String prefix2 = parentElement.coreLookupPrefix(namespaceURI, semantics);
            if (!semantics.isUseStrictNamespaceLookup() && this.getImplicitNamespaceURI(prefix2) != null) {
                return null;
            }
            for (CoreAttribute attr = this.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
                CoreNamespaceDeclaration decl;
                if (!(attr instanceof CoreNamespaceDeclaration) || !(decl = (CoreNamespaceDeclaration)attr).coreGetDeclaredPrefix().equals(prefix2)) continue;
                return null;
            }
            return prefix2;
        }
        return null;
    }

    @Override
    public final <T> void init(ClonePolicy<T> policy, T options, CoreNode other) throws CoreModelException {
        CoreElement o = (CoreElement)other;
        this.initSource(policy, options, o);
        this.initName(o);
        if (this.isExpanded()) {
            for (CoreAttribute attr = o.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
                this.coreAppendAttribute((CoreAttribute)attr.coreClone(policy, options));
            }
        }
    }

    public <T> void initSource(ClonePolicy<T> policy, T options, CoreElement other) {
    }

    @Override
    public final void corePromote(CoreElement newElement, Semantics semantics) throws CoreModelException {
        newElement.initName(this);
        newElement.internalSetFirstAttribute(this.firstAttribute);
        for (CoreAttribute attr = this.firstAttribute; attr != null; attr = attr.coreGetNextAttribute()) {
            attr.internalSetOwnerElement(newElement);
        }
        this.firstAttribute = null;
        newElement.coreMoveChildrenFrom(this, semantics);
        this.coreReplaceWith(newElement, semantics);
    }

    @Override
    public final NodeType coreGetNodeType() {
        return NodeType.NS_AWARE_ELEMENT;
    }

    @Override
    public final String getImplicitNamespaceURI(String prefix) {
        return prefix.equals(this.coreGetPrefix()) ? this.coreGetNamespaceURI() : null;
    }

    @Override
    public final String getImplicitPrefix(String namespaceURI) {
        return namespaceURI.equals(this.coreGetNamespaceURI()) ? this.coreGetPrefix() : null;
    }

    @Override
    public XmlInput getXmlInput(boolean cache, boolean incremental) throws StreamException {
        return null;
    }

    @Override
    public final void serializeStartEvent(XmlHandler handler) throws CoreModelException, StreamException {
        handler.startElement(this.coreGetNamespaceURI(), this.coreGetLocalName(), this.coreGetPrefix());
    }

    @Override
    public final void serializeEndEvent(XmlHandler handler) throws StreamException {
        handler.endElement();
    }

    @Override
    public void validateName(String staxPrefix, String staxLocalName, String staxNamespaceURI) {
    }

    @Override
    public final void initName(String namespaceURI, String localName, String prefix, Object namespaceHelper) {
        this.localName = localName;
        this.namespace = ((OMNamespaceCache)namespaceHelper).getOMNamespace(namespaceURI, prefix);
    }

    @Override
    public final void internalSetNamespace(OMNamespace namespace) {
        this.namespace = namespace;
    }

    @Override
    public final String internalGetLocalName() {
        return this.localName;
    }

    @Override
    public final void internalSetLocalName(String localName) {
        this.localName = localName;
    }

    @Override
    public OMNamespace getNamespace() {
        return this.defaultGetNamespace();
    }

    @Override
    public final String getLocalName() {
        return this.coreGetLocalName();
    }

    @Override
    public final String getNamespaceURI() {
        String namespaceURI = this.coreGetNamespaceURI();
        return namespaceURI.length() == 0 ? null : namespaceURI;
    }

    @Override
    public final String getPrefix() {
        String prefix = this.coreGetPrefix();
        return prefix.length() == 0 ? null : prefix;
    }

    @Override
    public final OMNamespace defaultGetNamespace() {
        return this.namespace;
    }

    @Override
    public final void setLocalName(String localName) {
        this.beforeSetLocalName();
        this.localName = localName;
    }

    @Override
    public QName getQName() {
        return this.defaultGetQName();
    }

    @Override
    public final QName defaultGetQName() {
        return QNameCache.getQName(this.namespace == null ? "" : this.namespace.getNamespaceURI(), this.localName, this.namespace == null ? "" : this.namespace.getPrefix());
    }

    @Override
    public final boolean hasName(QName name) {
        if (name.getLocalPart().equals(this.getLocalName())) {
            OMNamespace ns = this.getNamespace();
            return ns == null && name.getNamespaceURI().length() == 0 || ns != null && name.getNamespaceURI().equals(ns.getNamespaceURI());
        }
        return false;
    }

    @Override
    public final String coreGetNamespaceURI() {
        OMNamespace namespace = this.getNamespace();
        return namespace == null ? "" : namespace.getNamespaceURI();
    }

    @Override
    public final String coreGetPrefix() {
        OMNamespace namespace = this.getNamespace();
        return namespace == null ? "" : namespace.getPrefix();
    }

    @Override
    public final void coreSetName(String namespaceURI, String localName, String prefix) {
        this.localName = localName;
        this.namespace = namespaceURI.length() == 0 && prefix.length() == 0 ? null : new OMNamespaceImpl(namespaceURI, prefix);
    }

    @Override
    public final void initName(CoreNamedNode other) {
        AxiomNamedInformationItem o = (AxiomNamedInformationItem)other;
        if (o instanceof AxiomSourcedElement && ((AxiomElement)this).isExpanded()) {
            this.localName = o.coreGetLocalName();
            this.namespace = o.getNamespace();
        } else {
            this.localName = o.internalGetLocalName();
            this.namespace = o.defaultGetNamespace();
        }
    }

    public void updateLocalName() {
        throw new IllegalStateException();
    }

    @Override
    public final String coreGetLocalName() {
        if (this.localName == null) {
            this.updateLocalName();
        }
        return this.localName;
    }

    @Override
    public final void coreSetPrefix(String prefix) {
        OMNamespace ns = this.getNamespace();
        if (ns == null) {
            if (prefix.length() > 0) {
                throw new OMException("Cannot set prefix on an information item without namespace");
            }
        } else {
            this.internalSetNamespace(new OMNamespaceImpl(ns.getNamespaceURI(), prefix));
        }
    }

    @Override
    public final boolean coreHasParent() {
        return this.internalGetFlag(8);
    }

    @Override
    public final CoreParentNode coreGetParent() {
        return this.internalGetFlag(8) ? this.owner : null;
    }

    @Override
    public final CoreElement coreGetParentElement() {
        return this.owner instanceof CoreElement ? (CoreElement)this.owner : null;
    }

    @Override
    public void internalSetParent(CoreParentNode parent) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        this.owner = parent;
        this.internalSetFlag(8, true);
    }

    @Override
    public final void internalUnsetParent(CoreDocument newOwnerDocument) {
        this.owner = newOwnerDocument;
        this.internalSetFlag(8, false);
    }

    @Override
    public final CoreNode getRootOrOwnerDocument() {
        if (this.owner == null) {
            return this;
        }
        return this.owner.getRootOrOwnerDocument();
    }

    @Override
    public final void coreSetOwnerDocument(CoreDocument document) {
        if (this.internalGetFlag(8)) {
            throw new IllegalStateException();
        }
        this.owner = document;
    }

    @Override
    public final CoreChildNode coreGetNextSiblingIfAvailable() {
        return this.nextSibling;
    }

    @Override
    public final void internalSetNextSibling(CoreChildNode nextSibling) {
        this.nextSibling = nextSibling;
    }

    @Override
    public final CoreChildNode coreGetPreviousSibling() {
        return this.previousSibling;
    }

    @Override
    public final CoreChildNode coreGetPreviousSibling(NodeFilter filter2) {
        CoreChildNode sibling;
        for (sibling = this.coreGetPreviousSibling(); sibling != null && !filter2.accept(sibling); sibling = sibling.coreGetPreviousSibling()) {
        }
        return sibling;
    }

    @Override
    public final void internalSetPreviousSibling(CoreChildNode previousSibling) {
        this.previousSibling = previousSibling;
    }

    @Override
    public final CoreChildNode coreGetNextSibling() throws CoreModelException {
        CoreParentNode parent;
        CoreChildNode nextSibling = this.coreGetNextSiblingIfAvailable();
        if (nextSibling == null && (parent = this.coreGetParent()) != null) {
            switch (parent.getState()) {
                case 3: 
                case 4: {
                    throw new NodeConsumedException();
                }
                case 2: {
                    if (parent.coreGetBuilder() == null) break;
                    do {
                        parent.internalBuildNext();
                    } while (parent.getState() == 2 && (nextSibling = this.coreGetNextSiblingIfAvailable()) == null);
                }
            }
        }
        return nextSibling;
    }

    @Override
    public final CoreChildNode coreGetNextSibling(NodeFilter filter2) throws CoreModelException {
        CoreChildNode sibling;
        for (sibling = this.coreGetNextSibling(); sibling != null && !filter2.accept(sibling); sibling = sibling.coreGetNextSibling()) {
        }
        return sibling;
    }

    @Override
    public final void coreInsertSiblingAfter(CoreChildNode sibling) throws CoreModelException {
        CoreParentNode parent = this.coreGetParent();
        if (parent == null) {
            throw new NoParentException("Parent can not be null");
        }
        if (this == sibling) {
            throw new SelfRelationshipException("Inserting self as the sibling is not allowed");
        }
        parent.internalCheckNewChild(sibling, null);
        sibling.internalDetach(null, parent);
        CoreChildNode nextSibling = this.coreGetNextSibling();
        sibling.internalSetPreviousSibling(this);
        if (nextSibling == null) {
            parent.internalGetContent((boolean)true).lastChild = sibling;
        } else {
            nextSibling.internalSetPreviousSibling(sibling);
        }
        sibling.internalSetNextSibling(nextSibling);
        this.nextSibling = sibling;
    }

    @Override
    public final void coreInsertSiblingBefore(CoreChildNode sibling) throws CoreModelException {
        CoreParentNode parent = this.coreGetParent();
        if (parent == null) {
            throw new NoParentException("Parent can not be null");
        }
        if (this == sibling) {
            throw new SelfRelationshipException("Inserting self as the sibling is not allowed");
        }
        parent.internalCheckNewChild(sibling, null);
        sibling.internalDetach(null, parent);
        sibling.internalSetNextSibling(this);
        if (this.previousSibling == null) {
            parent.internalGetContent((boolean)true).firstChild = sibling;
        } else {
            this.previousSibling.internalSetNextSibling(sibling);
        }
        sibling.internalSetPreviousSibling(this.previousSibling);
        this.previousSibling = sibling;
    }

    @Override
    public final void coreInsertSiblingsBefore(CoreDocumentFragment fragment) {
        Content fragmentContent = fragment.internalGetContent(false);
        if (fragmentContent == null || fragmentContent.firstChild == null) {
            return;
        }
        CoreParentNode parent = this.coreGetParent();
        for (CoreChildNode child = fragmentContent.firstChild; child != null; child = child.coreGetNextSiblingIfAvailable()) {
            child.internalSetParent(parent);
        }
        fragmentContent.lastChild.internalSetNextSibling(this);
        if (this.previousSibling == null) {
            parent.internalGetContent((boolean)true).firstChild = fragmentContent.firstChild;
        } else {
            this.previousSibling.internalSetNextSibling(fragmentContent.firstChild);
        }
        fragmentContent.firstChild.internalSetPreviousSibling(this.previousSibling);
        this.previousSibling = fragmentContent.lastChild;
        fragmentContent.firstChild = null;
        fragmentContent.lastChild = null;
    }

    @Override
    public final void coreDetach(Semantics semantics) {
        this.internalDetach(semantics.getDetachPolicy(), null);
    }

    @Override
    public final void coreDetach(CoreDocument newOwnerDocument) {
        this.internalDetach(DetachPolicy.NEW_DOCUMENT, null);
        this.owner = newOwnerDocument;
    }

    @Override
    public final void internalDetach(DetachPolicy detachPolicy, CoreParentNode newParent) {
        CoreParentNode parent = this.coreGetParent();
        if (parent != null) {
            if (this.previousSibling == null) {
                parent.internalGetContent((boolean)true).firstChild = this.nextSibling;
            } else {
                this.previousSibling.internalSetNextSibling(this.nextSibling);
            }
            if (this.nextSibling == null) {
                parent.internalGetContent((boolean)true).lastChild = this.previousSibling;
            } else {
                this.nextSibling.internalSetPreviousSibling(this.previousSibling);
            }
            this.nextSibling = null;
            this.previousSibling = null;
            if (newParent == null) {
                this.internalUnsetParent(detachPolicy.getNewOwnerDocument(parent));
            }
        }
        if (newParent != null) {
            this.internalSetParent(newParent);
        }
    }

    @Override
    public final void coreReplaceWith(CoreChildNode newNode, Semantics semantics) throws CoreModelException {
        if (newNode == this) {
            return;
        }
        CoreParentNode parent = this.coreGetParent();
        if (parent != null) {
            parent.internalCheckNewChild(newNode, this);
            newNode.internalDetach(null, parent);
            if (this.previousSibling == null) {
                parent.internalGetContent((boolean)true).firstChild = newNode;
            } else {
                this.previousSibling.internalSetNextSibling(newNode);
                newNode.internalSetPreviousSibling(this.previousSibling);
                this.previousSibling = null;
            }
            if (this.nextSibling == null) {
                parent.internalGetContent((boolean)true).lastChild = newNode;
            } else {
                this.nextSibling.internalSetPreviousSibling(newNode);
                newNode.internalSetNextSibling(this.nextSibling);
                this.nextSibling = null;
            }
            this.internalUnsetParent(semantics.getDetachPolicy().getNewOwnerDocument(parent));
        }
    }

    @Override
    public final <T> CoreNode coreClone(ClonePolicy<T> policy, T options, CoreParentNode targetParent) throws CoreModelException {
        return this.internalClone(policy, options, targetParent);
    }

    @Override
    public final OMContainer getParent() {
        CoreParentNode parent = this.coreGetParent();
        return parent instanceof OMContainer ? (OMContainer)((Object)parent) : null;
    }

    @Override
    public final OMNode getNextOMSibling() {
        try {
            return (OMNode)((Object)this.coreGetNextSibling());
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final OMNode getPreviousOMSibling() {
        return (OMNode)((Object)this.coreGetPreviousSibling());
    }

    @Override
    public final void insertSiblingAfter(OMNode sibling) throws OMException {
        try {
            AxiomContainer parent = (AxiomContainer)this.getParent();
            if (parent == null) {
                throw new OMException("Parent can not be null");
            }
            this.coreInsertSiblingAfter(parent.prepareNewChild(sibling));
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final void insertSiblingBefore(OMNode sibling) throws OMException {
        try {
            AxiomContainer parent = (AxiomContainer)this.getParent();
            if (parent == null) {
                throw new OMException("Parent can not be null");
            }
            this.coreInsertSiblingBefore(parent.prepareNewChild(sibling));
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final OMNode detach() {
        if (!this.coreHasParent()) {
            throw new OMException("Nodes that don't have a parent can not be detached");
        }
        this.coreDetach(AxiomSemantics.INSTANCE);
        return this;
    }
}

