/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.Content;
import org.apache.axiom.core.CoreCharacterDataContainer;
import org.apache.axiom.core.CoreCharacterDataContainingParentNode;
import org.apache.axiom.core.CoreCharacterDataSinkNode;
import org.apache.axiom.core.CoreCharacterDataSourceNode;
import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreDocumentFragment;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.CoreParentNode;
import org.apache.axiom.core.CoreProcessingInstruction;
import org.apache.axiom.core.DetachPolicy;
import org.apache.axiom.core.ElementAction;
import org.apache.axiom.core.NoParentException;
import org.apache.axiom.core.NodeConsumedException;
import org.apache.axiom.core.NodeFilter;
import org.apache.axiom.core.NodeType;
import org.apache.axiom.core.SelfRelationshipException;
import org.apache.axiom.core.Semantics;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.AxiomSemantics;
import org.apache.axiom.om.impl.intf.AxiomContainer;
import org.apache.axiom.om.impl.intf.AxiomLeafNode;
import org.apache.axiom.om.impl.intf.AxiomProcessingInstruction;
import org.apache.axiom.om.impl.llom.AxiomCoreParentNodeImpl;

public final class AxiomProcessingInstructionImpl
extends AxiomCoreParentNodeImpl
implements AxiomProcessingInstruction,
OMProcessingInstruction,
CoreProcessingInstruction,
AxiomLeafNode,
CoreCharacterDataContainingParentNode,
CoreCharacterDataContainer,
CoreCharacterDataSourceNode,
CoreCharacterDataSinkNode {
    private String target;
    private CoreParentNode owner;
    CoreChildNode nextSibling;
    CoreChildNode previousSibling;

    public AxiomProcessingInstructionImpl() {
        this.init$AxiomProcessingInstructionMixin();
        this.init$CoreProcessingInstructionMixin();
        this.init$AxiomLeafNodeMixin();
        this.init$AxiomChildNodeMixin();
        this.init$CoreChildNodeMixin();
        this.init$CoreCharacterDataContainingParentNodeMixin();
    }

    private void init$AxiomProcessingInstructionMixin() {
    }

    private void init$CoreProcessingInstructionMixin() {
    }

    private void init$AxiomLeafNodeMixin() {
    }

    private void init$AxiomChildNodeMixin() {
    }

    private void init$CoreChildNodeMixin() {
    }

    private void init$CoreCharacterDataContainingParentNodeMixin() {
    }

    @Override
    public final int getType() {
        return 3;
    }

    @Override
    public final String getTarget() {
        return this.coreGetTarget();
    }

    @Override
    public final void setTarget(String target) {
        this.coreSetTarget(target);
    }

    @Override
    public final String getValue() {
        try {
            return this.coreGetCharacterData().toString();
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final void setValue(String value2) {
        try {
            this.coreSetCharacterData(value2, AxiomSemantics.INSTANCE);
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final void serialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        try {
            writer.writeProcessingInstruction(this.coreGetTarget() + " ", this.coreGetCharacterData().toString());
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final void buildWithAttachments() {
    }

    @Override
    public final NodeType coreGetNodeType() {
        return NodeType.PROCESSING_INSTRUCTION;
    }

    @Override
    public final String coreGetTarget() {
        return this.target;
    }

    @Override
    public final void coreSetTarget(String target) {
        this.target = target;
    }

    @Override
    public final <T> void init(ClonePolicy<T> policy, T options, CoreNode other) {
        this.target = ((CoreProcessingInstruction)other).coreGetTarget();
    }

    @Override
    public final void serializeStartEvent(XmlHandler handler) throws CoreModelException, StreamException {
        handler.startProcessingInstruction(this.coreGetTarget());
    }

    @Override
    public final void serializeEndEvent(XmlHandler handler) throws StreamException {
        handler.endProcessingInstruction();
    }

    @Override
    public final void discard() throws OMException {
        this.detach();
    }

    @Override
    public final void close(boolean build) {
    }

    @Override
    public final OMContainer getParent() {
        CoreParentNode parent = this.coreGetParent();
        return parent instanceof OMContainer ? (OMContainer)((Object)parent) : null;
    }

    @Override
    public final OMNode getNextOMSibling() {
        try {
            return (OMNode)((Object)this.coreGetNextSibling());
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final OMNode getPreviousOMSibling() {
        return (OMNode)((Object)this.coreGetPreviousSibling());
    }

    @Override
    public final void insertSiblingAfter(OMNode sibling) throws OMException {
        try {
            AxiomContainer parent = (AxiomContainer)this.getParent();
            if (parent == null) {
                throw new OMException("Parent can not be null");
            }
            this.coreInsertSiblingAfter(parent.prepareNewChild(sibling));
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final void insertSiblingBefore(OMNode sibling) throws OMException {
        try {
            AxiomContainer parent = (AxiomContainer)this.getParent();
            if (parent == null) {
                throw new OMException("Parent can not be null");
            }
            this.coreInsertSiblingBefore(parent.prepareNewChild(sibling));
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final OMNode detach() {
        if (!this.coreHasParent()) {
            throw new OMException("Nodes that don't have a parent can not be detached");
        }
        this.coreDetach(AxiomSemantics.INSTANCE);
        return this;
    }

    @Override
    public final boolean coreHasParent() {
        return this.internalGetFlag(8);
    }

    @Override
    public final CoreParentNode coreGetParent() {
        return this.internalGetFlag(8) ? this.owner : null;
    }

    @Override
    public final CoreElement coreGetParentElement() {
        return this.owner instanceof CoreElement ? (CoreElement)this.owner : null;
    }

    @Override
    public void internalSetParent(CoreParentNode parent) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        this.owner = parent;
        this.internalSetFlag(8, true);
    }

    @Override
    public final void internalUnsetParent(CoreDocument newOwnerDocument) {
        this.owner = newOwnerDocument;
        this.internalSetFlag(8, false);
    }

    @Override
    public final CoreNode getRootOrOwnerDocument() {
        if (this.owner == null) {
            return this;
        }
        return this.owner.getRootOrOwnerDocument();
    }

    @Override
    public final void coreSetOwnerDocument(CoreDocument document) {
        if (this.internalGetFlag(8)) {
            throw new IllegalStateException();
        }
        this.owner = document;
    }

    @Override
    public final CoreChildNode coreGetNextSiblingIfAvailable() {
        return this.nextSibling;
    }

    @Override
    public final void internalSetNextSibling(CoreChildNode nextSibling) {
        this.nextSibling = nextSibling;
    }

    @Override
    public final CoreChildNode coreGetPreviousSibling() {
        return this.previousSibling;
    }

    @Override
    public final CoreChildNode coreGetPreviousSibling(NodeFilter filter2) {
        CoreChildNode sibling;
        for (sibling = this.coreGetPreviousSibling(); sibling != null && !filter2.accept(sibling); sibling = sibling.coreGetPreviousSibling()) {
        }
        return sibling;
    }

    @Override
    public final void internalSetPreviousSibling(CoreChildNode previousSibling) {
        this.previousSibling = previousSibling;
    }

    @Override
    public final CoreChildNode coreGetNextSibling() throws CoreModelException {
        CoreParentNode parent;
        CoreChildNode nextSibling = this.coreGetNextSiblingIfAvailable();
        if (nextSibling == null && (parent = this.coreGetParent()) != null) {
            switch (parent.getState()) {
                case 3: 
                case 4: {
                    throw new NodeConsumedException();
                }
                case 2: {
                    if (parent.coreGetBuilder() == null) break;
                    do {
                        parent.internalBuildNext();
                    } while (parent.getState() == 2 && (nextSibling = this.coreGetNextSiblingIfAvailable()) == null);
                }
            }
        }
        return nextSibling;
    }

    @Override
    public final CoreChildNode coreGetNextSibling(NodeFilter filter2) throws CoreModelException {
        CoreChildNode sibling;
        for (sibling = this.coreGetNextSibling(); sibling != null && !filter2.accept(sibling); sibling = sibling.coreGetNextSibling()) {
        }
        return sibling;
    }

    @Override
    public final void coreInsertSiblingAfter(CoreChildNode sibling) throws CoreModelException {
        CoreParentNode parent = this.coreGetParent();
        if (parent == null) {
            throw new NoParentException("Parent can not be null");
        }
        if (this == sibling) {
            throw new SelfRelationshipException("Inserting self as the sibling is not allowed");
        }
        parent.internalCheckNewChild(sibling, null);
        sibling.internalDetach(null, parent);
        CoreChildNode nextSibling = this.coreGetNextSibling();
        sibling.internalSetPreviousSibling(this);
        if (nextSibling == null) {
            parent.internalGetContent((boolean)true).lastChild = sibling;
        } else {
            nextSibling.internalSetPreviousSibling(sibling);
        }
        sibling.internalSetNextSibling(nextSibling);
        this.nextSibling = sibling;
    }

    @Override
    public final void coreInsertSiblingBefore(CoreChildNode sibling) throws CoreModelException {
        CoreParentNode parent = this.coreGetParent();
        if (parent == null) {
            throw new NoParentException("Parent can not be null");
        }
        if (this == sibling) {
            throw new SelfRelationshipException("Inserting self as the sibling is not allowed");
        }
        parent.internalCheckNewChild(sibling, null);
        sibling.internalDetach(null, parent);
        sibling.internalSetNextSibling(this);
        if (this.previousSibling == null) {
            parent.internalGetContent((boolean)true).firstChild = sibling;
        } else {
            this.previousSibling.internalSetNextSibling(sibling);
        }
        sibling.internalSetPreviousSibling(this.previousSibling);
        this.previousSibling = sibling;
    }

    @Override
    public final void coreInsertSiblingsBefore(CoreDocumentFragment fragment) {
        Content fragmentContent = fragment.internalGetContent(false);
        if (fragmentContent == null || fragmentContent.firstChild == null) {
            return;
        }
        CoreParentNode parent = this.coreGetParent();
        for (CoreChildNode child = fragmentContent.firstChild; child != null; child = child.coreGetNextSiblingIfAvailable()) {
            child.internalSetParent(parent);
        }
        fragmentContent.lastChild.internalSetNextSibling(this);
        if (this.previousSibling == null) {
            parent.internalGetContent((boolean)true).firstChild = fragmentContent.firstChild;
        } else {
            this.previousSibling.internalSetNextSibling(fragmentContent.firstChild);
        }
        fragmentContent.firstChild.internalSetPreviousSibling(this.previousSibling);
        this.previousSibling = fragmentContent.lastChild;
        fragmentContent.firstChild = null;
        fragmentContent.lastChild = null;
    }

    @Override
    public final void coreDetach(Semantics semantics) {
        this.internalDetach(semantics.getDetachPolicy(), null);
    }

    @Override
    public final void coreDetach(CoreDocument newOwnerDocument) {
        this.internalDetach(DetachPolicy.NEW_DOCUMENT, null);
        this.owner = newOwnerDocument;
    }

    @Override
    public final void internalDetach(DetachPolicy detachPolicy, CoreParentNode newParent) {
        CoreParentNode parent = this.coreGetParent();
        if (parent != null) {
            if (this.previousSibling == null) {
                parent.internalGetContent((boolean)true).firstChild = this.nextSibling;
            } else {
                this.previousSibling.internalSetNextSibling(this.nextSibling);
            }
            if (this.nextSibling == null) {
                parent.internalGetContent((boolean)true).lastChild = this.previousSibling;
            } else {
                this.nextSibling.internalSetPreviousSibling(this.previousSibling);
            }
            this.nextSibling = null;
            this.previousSibling = null;
            if (newParent == null) {
                this.internalUnsetParent(detachPolicy.getNewOwnerDocument(parent));
            }
        }
        if (newParent != null) {
            this.internalSetParent(newParent);
        }
    }

    @Override
    public final void coreReplaceWith(CoreChildNode newNode, Semantics semantics) throws CoreModelException {
        if (newNode == this) {
            return;
        }
        CoreParentNode parent = this.coreGetParent();
        if (parent != null) {
            parent.internalCheckNewChild(newNode, this);
            newNode.internalDetach(null, parent);
            if (this.previousSibling == null) {
                parent.internalGetContent((boolean)true).firstChild = newNode;
            } else {
                this.previousSibling.internalSetNextSibling(newNode);
                newNode.internalSetPreviousSibling(this.previousSibling);
                this.previousSibling = null;
            }
            if (this.nextSibling == null) {
                parent.internalGetContent((boolean)true).lastChild = newNode;
            } else {
                this.nextSibling.internalSetPreviousSibling(newNode);
                newNode.internalSetNextSibling(this.nextSibling);
                this.nextSibling = null;
            }
            this.internalUnsetParent(semantics.getDetachPolicy().getNewOwnerDocument(parent));
        }
    }

    @Override
    public final <T> CoreNode coreClone(ClonePolicy<T> policy, T options, CoreParentNode targetParent) throws CoreModelException {
        return this.internalClone(policy, options, targetParent);
    }

    @Override
    public final Object coreGetCharacterData() throws CoreModelException {
        Object characterData = this.internalGetCharacterData(ElementAction.RETURN_NULL);
        if (characterData == null) {
            throw new IllegalStateException();
        }
        return characterData;
    }
}

