/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.llom.soap12;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamedInformationItem;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.common.util.LocaleUtil;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.impl.intf.AxiomSOAPFaultReason;
import org.apache.axiom.soap.impl.intf.soap12.AxiomSOAP12FaultReason;
import org.apache.axiom.soap.impl.llom.soap12.AxiomSOAP12ElementImpl;

public final class AxiomSOAP12FaultReasonImpl
extends AxiomSOAP12ElementImpl
implements AxiomSOAP12FaultReason,
AxiomSOAPFaultReason,
SOAPFaultReason,
OMElement,
OMNamedInformationItem,
OMNode,
OMContainer {
    public AxiomSOAP12FaultReasonImpl() {
        this.init$AxiomSOAP12FaultReasonMixin();
    }

    private void init$AxiomSOAP12FaultReasonMixin() {
    }

    @Override
    public final Class<? extends CoreNode> coreGetNodeClass() {
        return AxiomSOAP12FaultReason.class;
    }

    @Override
    public final boolean isChildElementAllowed(OMElement child) {
        return child instanceof SOAPFaultText;
    }

    @Override
    public final void addSOAPText(SOAPFaultText soapFaultText) {
        this.addChild(soapFaultText);
    }

    @Override
    public final SOAPFaultText getFirstSOAPText() {
        return (SOAPFaultText)this.getFirstElement();
    }

    @Override
    public final List<SOAPFaultText> getAllSoapTexts() {
        ArrayList<SOAPFaultText> faultTexts = new ArrayList<SOAPFaultText>();
        Iterator<OMElement> it = this.getChildElements();
        while (it.hasNext()) {
            faultTexts.add((SOAPFaultText)it.next());
        }
        return faultTexts;
    }

    @Override
    public final SOAPFaultText getSOAPFaultText(String language) {
        Iterator<OMElement> it = this.getChildElements();
        while (it.hasNext()) {
            SOAPFaultText text2 = (SOAPFaultText)it.next();
            if (language != null && !language.equals(text2.getLang())) continue;
            return text2;
        }
        return null;
    }

    @Override
    public final String getFaultReasonText(Locale locale) {
        String text2 = "";
        int maxScore = -1;
        Iterator<OMElement> it = this.getChildElements();
        while (it.hasNext()) {
            SOAPFaultText textNode = (SOAPFaultText)it.next();
            String lang2 = textNode.getLang();
            int score = LocaleUtil.getMatchScore(locale, lang2 == null ? null : Locale.forLanguageTag(lang2));
            if (score <= maxScore) continue;
            text2 = textNode.getText();
            maxScore = score;
        }
        return text2;
    }
}

