/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.base64;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.activation.DataHandler;
import org.apache.axiom.util.activation.DataSourceUtils;
import org.apache.axiom.util.base64.Base64Constants;
import org.apache.axiom.util.base64.Base64EncodingStringBufferOutputStream;
import org.apache.axiom.util.base64.Base64EncodingWriterOutputStream;
import org.apache.axiom.util.base64.NoCopyCharArrayWriter;

public class Base64Utils {
    private static int getEncodedSize(int unencodedSize) {
        return (unencodedSize + 2) / 3 * 4;
    }

    private static int getBufferSize(DataHandler dh) {
        long size = DataSourceUtils.getSize(dh.getDataSource());
        if (size == -1L) {
            return 4096;
        }
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("DataHandler is too large to encode to string");
        }
        return Base64Utils.getEncodedSize((int)size);
    }

    public static String encode(DataHandler dh) throws IOException {
        StringBuilder buffer = new StringBuilder(Base64Utils.getBufferSize(dh));
        Base64EncodingStringBufferOutputStream out = new Base64EncodingStringBufferOutputStream(buffer);
        dh.writeTo((OutputStream)out);
        out.complete();
        return buffer.toString();
    }

    public static char[] encodeToCharArray(DataHandler dh) throws IOException {
        NoCopyCharArrayWriter buffer = new NoCopyCharArrayWriter(Base64Utils.getBufferSize(dh));
        Base64EncodingWriterOutputStream out = new Base64EncodingWriterOutputStream(buffer);
        dh.writeTo((OutputStream)out);
        out.complete();
        return buffer.toCharArray();
    }

    private static int decode0(char[] ibuf, byte[] obuf, int wp) {
        int outlen = 3;
        if (ibuf[3] == '=') {
            outlen = 2;
        }
        if (ibuf[2] == '=') {
            outlen = 1;
        }
        byte b0 = Base64Constants.S_DECODETABLE[ibuf[0]];
        byte b1 = Base64Constants.S_DECODETABLE[ibuf[1]];
        byte b2 = Base64Constants.S_DECODETABLE[ibuf[2]];
        byte b3 = Base64Constants.S_DECODETABLE[ibuf[3]];
        switch (outlen) {
            case 1: {
                obuf[wp] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                return 1;
            }
            case 2: {
                obuf[wp++] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                obuf[wp] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
                return 2;
            }
            case 3: {
                obuf[wp++] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                obuf[wp++] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
                obuf[wp] = (byte)(b2 << 6 & 0xC0 | b3 & 0x3F);
                return 3;
            }
        }
        throw new RuntimeException("internalError00");
    }

    public static byte[] decode(char[] data2, int off, int len) {
        char[] ibuf = new char[4];
        int ibufcount = 0;
        byte[] obuf = new byte[len / 4 * 3 + 3];
        int obufcount = 0;
        for (int i = off; i < off + len; ++i) {
            char ch = data2[i];
            if (ch != '=' && (ch >= Base64Constants.S_DECODETABLE.length || Base64Constants.S_DECODETABLE[ch] < 0)) continue;
            ibuf[ibufcount++] = ch;
            if (ibufcount != ibuf.length) continue;
            ibufcount = 0;
            obufcount += Base64Utils.decode0(ibuf, obuf, obufcount);
        }
        if (obufcount == obuf.length) {
            return obuf;
        }
        byte[] ret = new byte[obufcount];
        System.arraycopy(obuf, 0, ret, 0, obufcount);
        return ret;
    }

    public static byte[] decode(String data2) {
        int symbols = 0;
        int padding = 0;
        block5: for (int i = 0; i < data2.length(); ++i) {
            switch (Base64Constants.S_DECODETABLE[data2.charAt(i)]) {
                case -1: {
                    if (padding == 2) {
                        throw new IllegalArgumentException("Too much padding");
                    }
                    ++padding;
                    continue block5;
                }
                case -2: {
                    continue block5;
                }
                case -3: {
                    throw new IllegalArgumentException("Invalid character encountered");
                }
                default: {
                    if (padding > 0) {
                        throw new IllegalArgumentException("Unexpected padding character");
                    }
                    ++symbols;
                }
            }
        }
        if ((symbols + padding) % 4 != 0) {
            throw new IllegalArgumentException("Missing padding");
        }
        byte[] result = new byte[(symbols + padding) / 4 * 3 - padding];
        int pos = 0;
        int resultPos = 0;
        byte accumulator = 0;
        int bits = 0;
        while (symbols > 0) {
            byte b;
            if ((b = Base64Constants.S_DECODETABLE[data2.charAt(pos++)]) == -2) continue;
            if (bits == 0) {
                accumulator = (byte)(b << 2);
                bits = 6;
            } else {
                accumulator = (byte)(accumulator | b >> bits - 2);
                result[resultPos++] = accumulator;
                accumulator = (byte)(b << 10 - bits);
                bits -= 2;
            }
            --symbols;
        }
        if (accumulator != 0) {
            throw new IllegalArgumentException("Invalid base64 value");
        }
        if (resultPos != result.length) {
            throw new Error("Oops. This is a bug.");
        }
        return result;
    }

    public static boolean isValidBase64Encoding(String data2) {
        for (int i = 0; i < data2.length(); ++i) {
            char ch = data2.charAt(i);
            if (ch == '=' || ch < Base64Constants.S_DECODETABLE.length && Base64Constants.S_DECODETABLE[ch] >= 0 || ch == '\r' || ch == '\n') continue;
            return false;
        }
        return true;
    }

    public static void decode(char[] data2, int off, int len, OutputStream ostream) throws IOException {
        char[] ibuf = new char[4];
        int ibufcount = 0;
        byte[] obuf = new byte[3];
        for (int i = off; i < off + len; ++i) {
            char ch = data2[i];
            if (ch != '=' && (ch >= Base64Constants.S_DECODETABLE.length || Base64Constants.S_DECODETABLE[ch] < 0)) continue;
            ibuf[ibufcount++] = ch;
            if (ibufcount != ibuf.length) continue;
            ibufcount = 0;
            int obufcount = Base64Utils.decode0(ibuf, obuf, 0);
            ostream.write(obuf, 0, obufcount);
        }
    }

    public static void decode(String data2, OutputStream ostream) throws IOException {
        char[] ibuf = new char[4];
        int ibufcount = 0;
        byte[] obuf = new byte[3];
        for (int i = 0; i < data2.length(); ++i) {
            char ch = data2.charAt(i);
            if (ch != '=' && (ch >= Base64Constants.S_DECODETABLE.length || Base64Constants.S_DECODETABLE[ch] < 0)) continue;
            ibuf[ibufcount++] = ch;
            if (ibufcount != ibuf.length) continue;
            ibufcount = 0;
            int obufcount = Base64Utils.decode0(ibuf, obuf, 0);
            ostream.write(obuf, 0, obufcount);
        }
    }

    public static String encode(byte[] data2) {
        return Base64Utils.encode(data2, 0, data2.length);
    }

    public static String encode(byte[] data2, int off, int len) {
        int i;
        int rest;
        if (len <= 0) {
            return "";
        }
        char[] out = new char[len / 3 * 4 + 4];
        int rindex = off;
        int windex = 0;
        for (rest = len - off; rest >= 3; rest -= 3) {
            i = ((data2[rindex] & 0xFF) << 16) + ((data2[rindex + 1] & 0xFF) << 8) + (data2[rindex + 2] & 0xFF);
            out[windex++] = (char)Base64Constants.S_BASE64CHAR[i >> 18];
            out[windex++] = (char)Base64Constants.S_BASE64CHAR[i >> 12 & 0x3F];
            out[windex++] = (char)Base64Constants.S_BASE64CHAR[i >> 6 & 0x3F];
            out[windex++] = (char)Base64Constants.S_BASE64CHAR[i & 0x3F];
            rindex += 3;
        }
        if (rest == 1) {
            i = data2[rindex] & 0xFF;
            out[windex++] = (char)Base64Constants.S_BASE64CHAR[i >> 2];
            out[windex++] = (char)Base64Constants.S_BASE64CHAR[i << 4 & 0x3F];
            out[windex++] = 61;
            out[windex++] = 61;
        } else if (rest == 2) {
            i = ((data2[rindex] & 0xFF) << 8) + (data2[rindex + 1] & 0xFF);
            out[windex++] = (char)Base64Constants.S_BASE64CHAR[i >> 10];
            out[windex++] = (char)Base64Constants.S_BASE64CHAR[i >> 4 & 0x3F];
            out[windex++] = (char)Base64Constants.S_BASE64CHAR[i << 2 & 0x3F];
            out[windex++] = 61;
        }
        return new String(out, 0, windex);
    }

    public static void encode(byte[] data2, int off, int len, StringBuffer buffer) {
        int i;
        int rest;
        if (len <= 0) {
            return;
        }
        char[] out = new char[4];
        int rindex = off;
        for (rest = len - off; rest >= 3; rest -= 3) {
            i = ((data2[rindex] & 0xFF) << 16) + ((data2[rindex + 1] & 0xFF) << 8) + (data2[rindex + 2] & 0xFF);
            out[0] = (char)Base64Constants.S_BASE64CHAR[i >> 18];
            out[1] = (char)Base64Constants.S_BASE64CHAR[i >> 12 & 0x3F];
            out[2] = (char)Base64Constants.S_BASE64CHAR[i >> 6 & 0x3F];
            out[3] = (char)Base64Constants.S_BASE64CHAR[i & 0x3F];
            buffer.append(out);
            rindex += 3;
        }
        if (rest == 1) {
            i = data2[rindex] & 0xFF;
            out[0] = (char)Base64Constants.S_BASE64CHAR[i >> 2];
            out[1] = (char)Base64Constants.S_BASE64CHAR[i << 4 & 0x3F];
            out[2] = 61;
            out[3] = 61;
            buffer.append(out);
        } else if (rest == 2) {
            i = ((data2[rindex] & 0xFF) << 8) + (data2[rindex + 1] & 0xFF);
            out[0] = (char)Base64Constants.S_BASE64CHAR[i >> 10];
            out[1] = (char)Base64Constants.S_BASE64CHAR[i >> 4 & 0x3F];
            out[2] = (char)Base64Constants.S_BASE64CHAR[i << 2 & 0x3F];
            out[3] = 61;
            buffer.append(out);
        }
    }

    public static void encode(byte[] data2, int off, int len, OutputStream ostream) throws IOException {
        int i;
        int rest;
        if (len <= 0) {
            return;
        }
        byte[] out = new byte[4];
        int rindex = off;
        for (rest = len - off; rest >= 3; rest -= 3) {
            i = ((data2[rindex] & 0xFF) << 16) + ((data2[rindex + 1] & 0xFF) << 8) + (data2[rindex + 2] & 0xFF);
            out[0] = Base64Constants.S_BASE64CHAR[i >> 18];
            out[1] = Base64Constants.S_BASE64CHAR[i >> 12 & 0x3F];
            out[2] = Base64Constants.S_BASE64CHAR[i >> 6 & 0x3F];
            out[3] = Base64Constants.S_BASE64CHAR[i & 0x3F];
            ostream.write(out, 0, 4);
            rindex += 3;
        }
        if (rest == 1) {
            i = data2[rindex] & 0xFF;
            out[0] = Base64Constants.S_BASE64CHAR[i >> 2];
            out[1] = Base64Constants.S_BASE64CHAR[i << 4 & 0x3F];
            out[2] = 61;
            out[3] = 61;
            ostream.write(out, 0, 4);
        } else if (rest == 2) {
            i = ((data2[rindex] & 0xFF) << 8) + (data2[rindex + 1] & 0xFF);
            out[0] = Base64Constants.S_BASE64CHAR[i >> 10];
            out[1] = Base64Constants.S_BASE64CHAR[i >> 4 & 0x3F];
            out[2] = Base64Constants.S_BASE64CHAR[i << 2 & 0x3F];
            out[3] = 61;
            ostream.write(out, 0, 4);
        }
    }

    public static void encode(byte[] data2, int off, int len, Writer writer) throws IOException {
        int i;
        int rest;
        if (len <= 0) {
            return;
        }
        char[] out = new char[4];
        int rindex = off;
        int output = 0;
        for (rest = len - off; rest >= 3; rest -= 3) {
            i = ((data2[rindex] & 0xFF) << 16) + ((data2[rindex + 1] & 0xFF) << 8) + (data2[rindex + 2] & 0xFF);
            out[0] = (char)Base64Constants.S_BASE64CHAR[i >> 18];
            out[1] = (char)Base64Constants.S_BASE64CHAR[i >> 12 & 0x3F];
            out[2] = (char)Base64Constants.S_BASE64CHAR[i >> 6 & 0x3F];
            out[3] = (char)Base64Constants.S_BASE64CHAR[i & 0x3F];
            writer.write(out, 0, 4);
            rindex += 3;
            if ((output += 4) % 76 != 0) continue;
            writer.write("\n");
        }
        if (rest == 1) {
            i = data2[rindex] & 0xFF;
            out[0] = (char)Base64Constants.S_BASE64CHAR[i >> 2];
            out[1] = (char)Base64Constants.S_BASE64CHAR[i << 4 & 0x3F];
            out[2] = 61;
            out[3] = 61;
            writer.write(out, 0, 4);
        } else if (rest == 2) {
            i = ((data2[rindex] & 0xFF) << 8) + (data2[rindex + 1] & 0xFF);
            out[0] = (char)Base64Constants.S_BASE64CHAR[i >> 10];
            out[1] = (char)Base64Constants.S_BASE64CHAR[i >> 4 & 0x3F];
            out[2] = (char)Base64Constants.S_BASE64CHAR[i << 2 & 0x3F];
            out[3] = 61;
            writer.write(out, 0, 4);
        }
    }
}

