/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.core;

import java.lang.reflect.Method;
import org.awaitility.Duration;
import org.awaitility.core.CheckedExceptionRethrower;
import org.awaitility.core.Condition;
import org.awaitility.core.ConditionAwaiter;
import org.awaitility.core.ConditionEvaluationHandler;
import org.awaitility.core.ConditionEvaluationResult;
import org.awaitility.core.ConditionEvaluator;
import org.awaitility.core.ConditionSettings;
import org.awaitility.core.LambdaErrorMessageGenerator;
import org.awaitility.core.ThrowingRunnable;

public class AssertionCondition
implements Condition<Void> {
    private final ConditionAwaiter conditionAwaiter;
    private String lastExceptionMessage;
    private final ConditionEvaluationHandler<Object> conditionEvaluationHandler;

    public AssertionCondition(final ThrowingRunnable supplier, final ConditionSettings settings) {
        if (supplier == null) {
            throw new IllegalArgumentException("You must specify a supplier (was null).");
        }
        this.conditionEvaluationHandler = new ConditionEvaluationHandler(null, settings);
        ConditionEvaluator callable = new ConditionEvaluator(){

            @Override
            public ConditionEvaluationResult eval(Duration pollInterval) throws Exception {
                try {
                    supplier.run();
                    AssertionCondition.this.conditionEvaluationHandler.handleConditionResultMatch(AssertionCondition.this.getMatchMessage(supplier, settings.getAlias()), null, pollInterval);
                    return new ConditionEvaluationResult(true);
                }
                catch (AssertionError e2) {
                    AssertionCondition.this.lastExceptionMessage = ((Throwable)((Object)e2)).getMessage();
                    AssertionCondition.this.conditionEvaluationHandler.handleConditionResultMismatch(AssertionCondition.this.getMismatchMessage(supplier, AssertionCondition.this.lastExceptionMessage, settings.getAlias(), true), null, pollInterval);
                    return new ConditionEvaluationResult(false, null, (Throwable)((Object)e2));
                }
                catch (Throwable throwable) {
                    return (ConditionEvaluationResult)CheckedExceptionRethrower.safeRethrow(throwable);
                }
            }
        };
        this.conditionAwaiter = new ConditionAwaiter(callable, settings){

            @Override
            protected String getTimeoutMessage() {
                return AssertionCondition.this.getMismatchMessage(supplier, AssertionCondition.this.lastExceptionMessage, settings.getAlias(), false);
            }
        };
    }

    private String getMatchMessage(ThrowingRunnable supplier, String conditionAlias) {
        return this.generateDescriptionPrefix(supplier, conditionAlias, true) + " reached its end value";
    }

    private String getMismatchMessage(ThrowingRunnable supplier, String exceptionMessage, String conditionAlias, boolean includeAliasIfDefined) {
        if (exceptionMessage != null && exceptionMessage.endsWith(".")) {
            exceptionMessage = exceptionMessage.substring(0, exceptionMessage.length() - 1);
        }
        return this.generateDescriptionPrefix(supplier, conditionAlias, includeAliasIfDefined) + " " + exceptionMessage;
    }

    private String generateDescriptionPrefix(ThrowingRunnable supplier, String conditionAlias, boolean includeAliasIfDefined) {
        boolean hasAlias;
        String methodDescription = this.generateMethodDescription(supplier);
        boolean bl = hasAlias = conditionAlias != null;
        if (LambdaErrorMessageGenerator.isLambdaClass(supplier.getClass())) {
            String prefix = hasAlias && includeAliasIfDefined ? "Assertion condition with alias " + conditionAlias + " defined as a " : "Assertion condition defined as a ";
            return prefix + LambdaErrorMessageGenerator.generateLambdaErrorMessagePrefix(supplier.getClass(), false) + methodDescription;
        }
        return "Assertion condition" + (hasAlias ? " with alias " + conditionAlias : "") + methodDescription;
    }

    private String generateMethodDescription(ThrowingRunnable supplier) {
        String methodDescription = "";
        Method enclosingMethod = null;
        try {
            enclosingMethod = supplier.getClass().getEnclosingMethod();
        }
        catch (Error error2) {
            // empty catch block
        }
        if (enclosingMethod != null) {
            methodDescription = " defined in " + enclosingMethod.toString();
        }
        return methodDescription;
    }

    @Override
    public Void await() {
        this.conditionAwaiter.await(this.conditionEvaluationHandler);
        return null;
    }
}

