/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.core;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;

public class DeadlockException
extends Throwable {
    private final ThreadInfo[] threadInfos;

    public DeadlockException(long[] threads) {
        super("Deadlocked threads detected");
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        this.threadInfos = bean.getThreadInfo(threads, true, true);
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessage()).append(":\n\n");
        for (ThreadInfo info2 : this.threadInfos) {
            sb.append(info2.toString());
        }
        return sb.toString();
    }

    public ThreadInfo[] getThreadInfos() {
        return Arrays.copyOf(this.threadInfos, this.threadInfos.length);
    }
}

