/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.error;

import io.ballerina.identifier.Utils;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BFuture;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.internal.scheduling.Strand;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class StackTrace {
    private static final Module MODULE = new Module("ballerina", "lang.error", "1");
    private static final ObjectType CALLSTACK_TYPE = StackTrace.createCallStackType();

    private StackTrace() {
    }

    public static BObject stackTrace(BError value2) {
        CallStack callStack = new CallStack(CALLSTACK_TYPE);
        callStack.callStack = StackTrace.getCallStackArray(value2.getStackTrace());
        callStack.callStack.freezeDirect();
        return callStack;
    }

    private static ObjectType createCallStackType() {
        RecordType callStackElementType = TypeCreator.createRecordType("CallStackElement", MODULE, 0L, Map.of("callableName", TypeCreator.createField(PredefinedTypes.TYPE_STRING, "callableName", 0L), "moduleName", TypeCreator.createField(PredefinedTypes.TYPE_STRING, "moduleName", 4096L), "fileName", TypeCreator.createField(PredefinedTypes.TYPE_STRING, "fileName", 0L), "lineNumber", TypeCreator.createField(PredefinedTypes.TYPE_INT, "lineNumber", 0L)), PredefinedTypes.TYPE_NEVER, false, 0);
        ObjectType callStackObjType = TypeCreator.createObjectType("CallStack", MODULE, 0L);
        callStackObjType.setMethods(new MethodType[0]);
        callStackObjType.setFields(Collections.singletonMap("callStack", TypeCreator.createField(TypeCreator.createArrayType(callStackElementType), "callStack", 1L)));
        return callStackObjType;
    }

    private static BArray getCallStackArray(StackTraceElement[] stackTrace2) {
        Type recordType = ValueCreator.createRecordValue(RuntimeConstants.BALLERINA_LANG_ERROR_PKG_ID, "CallStackElement").getType();
        Object[] array2 = new Object[stackTrace2.length];
        for (int i = 0; i < stackTrace2.length; ++i) {
            array2[i] = StackTrace.getStackFrame(stackTrace2[i]);
        }
        return ValueCreator.createArrayValue(array2, TypeCreator.createArrayType(recordType));
    }

    static BMap<BString, Object> getStackFrame(StackTraceElement stackTraceElement) {
        String fileName;
        Object[] values = new Object[4];
        values[0] = stackTraceElement.getMethodName();
        values[2] = stackTraceElement.getFileName();
        values[3] = stackTraceElement.getLineNumber();
        String moduleName = Utils.decodeIdentifier(stackTraceElement.getClassName()).replace("$$$", ".");
        if (!moduleName.equals(fileName = stackTraceElement.getFileName().replace(".bal", ""))) {
            int index = moduleName.lastIndexOf("." + fileName);
            values[1] = index != -1 ? moduleName.substring(0, index) : moduleName;
        }
        return ValueCreator.createRecordValue(ValueCreator.createRecordValue(RuntimeConstants.BALLERINA_LANG_ERROR_PKG_ID, "CallStackElement"), values);
    }

    public static class CallStack
    implements BObject {
        private static final BasicTypeBitSet BASIC_TYPE = Builder.getObjectType();
        BArray callStack;
        private final ObjectType type;
        private final BTypedesc typedesc;

        public CallStack(ObjectType type) {
            this.type = type;
            this.typedesc = ValueCreator.createTypedescValue(type);
        }

        @Override
        @Deprecated
        public Object call(Strand strand, String funcName, Object ... args2) {
            throw ErrorCreator.createError(StringUtils.fromString("No such field or method: " + funcName));
        }

        @Override
        @Deprecated
        public BFuture start(Strand strand, String funcName, Object ... args2) {
            throw ErrorCreator.createError(StringUtils.fromString("No such field or method: " + funcName));
        }

        @Override
        public String stringValue(BLink parent) {
            return "object " + this.type.toString();
        }

        @Override
        public String expressionStringValue(BLink parent) {
            return null;
        }

        @Override
        public ObjectType getType() {
            return (ObjectType)TypeUtils.getImpliedType(this.type);
        }

        @Override
        public BasicTypeBitSet getBasicType() {
            return BASIC_TYPE;
        }

        @Override
        public Type getOriginalType() {
            return this.type;
        }

        @Override
        public Object get(BString fieldName) {
            if (fieldName.getValue().equals("callStack")) {
                return this.callStack;
            }
            throw ErrorCreator.createError(StringUtils.fromString("No such field or method: callStack"));
        }

        @Override
        public long getIntValue(BString fieldName) {
            return 0L;
        }

        @Override
        public double getFloatValue(BString fieldName) {
            return 0.0;
        }

        @Override
        public BString getStringValue(BString fieldName) {
            return null;
        }

        @Override
        public boolean getBooleanValue(BString fieldName) {
            return false;
        }

        @Override
        public BMap<BString, Object> getMapValue(BString fieldName) {
            return null;
        }

        @Override
        public BObject getObjectValue(BString fieldName) {
            return null;
        }

        @Override
        public BArray getArrayValue(BString fieldName) {
            return null;
        }

        @Override
        public void addNativeData(String key, Object data2) {
        }

        @Override
        public Object getNativeData(String key) {
            return null;
        }

        @Override
        public HashMap<String, Object> getNativeData() {
            return null;
        }

        @Override
        public void set(BString fieldName, Object value2) {
            throw ErrorCreator.createError(StringUtils.fromString("No such field or method: callStack"));
        }

        @Override
        public Object copy(Map<Object, Object> refs) {
            return null;
        }

        @Override
        public Object frozenCopy(Map<Object, Object> refs) {
            return null;
        }

        @Override
        public BTypedesc getTypedesc() {
            return this.typedesc;
        }
    }
}

