/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.floatingpoint;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import java.util.regex.Pattern;

public final class FromHexString {
    private static final Pattern HEX_FLOAT_LITERAL = Pattern.compile("[-+]?0[xX][\\dA-Fa-f.pP\\-+]+");

    private FromHexString() {
    }

    public static Object fromHexString(BString s) {
        String hexValue = s.getValue();
        try {
            if (FromHexString.isValidHexString(hexValue.toLowerCase())) {
                return Double.parseDouble(hexValue);
            }
            return FromHexString.getNumberFormatError("invalid hex string: '" + hexValue + "'");
        }
        catch (NumberFormatException e2) {
            return FromHexString.getNumberFormatError(e2.getMessage());
        }
    }

    private static boolean isValidHexString(String hexValue) {
        return switch (hexValue) {
            case "+infinity", "-infinity", "infinity", "nan" -> true;
            default -> HEX_FLOAT_LITERAL.matcher(hexValue).matches();
        };
    }

    private static BError getNumberFormatError(String message2) {
        return ErrorCreator.createError(ErrorReasons.getModulePrefixedReason("lang.float", "NumberParsingError"), StringUtils.fromString(message2));
    }
}

