/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.floatingpoint;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class Round {
    private Round() {
    }

    public static double round(double x, long fractionDigits) {
        if (Double.isInfinite(x) || Double.isNaN(x) || x == 0.0) {
            return x;
        }
        if (fractionDigits == 0L) {
            return Math.rint(x);
        }
        if (fractionDigits > Integer.MAX_VALUE) {
            return x;
        }
        if (fractionDigits < Integer.MIN_VALUE) {
            return 0.0;
        }
        int fractionDigitsAsInt = (int)fractionDigits;
        BigDecimal xInBigDecimal = BigDecimal.valueOf(x);
        int scale = xInBigDecimal.scale();
        if (fractionDigitsAsInt > 0) {
            if (fractionDigitsAsInt > scale) {
                return x;
            }
        } else if (-fractionDigitsAsInt > xInBigDecimal.precision() - scale) {
            return 0.0;
        }
        return xInBigDecimal.setScale(fractionDigitsAsInt, RoundingMode.HALF_EVEN).doubleValue();
    }
}

