/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.floatingpoint;

import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.utils.ErrorUtils;
import io.ballerina.runtime.internal.utils.FloatUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public final class ToExpString {
    private ToExpString() {
    }

    public static BString toExpString(double x, Object fractionDigits) {
        long noOfFractionDigits;
        BString str = FloatUtils.getBStringIfInfiniteOrNaN(x);
        if (str != null) {
            return str;
        }
        double xAbsValue = Math.abs(x);
        if (fractionDigits == null) {
            if (xAbsValue == 0.0) {
                noOfFractionDigits = 1L;
            } else {
                BigDecimal xInBigDecimal = BigDecimal.valueOf(x);
                if (xAbsValue < 1.0) {
                    pow = ToExpString.calculatePowerForFloatLessThanOne(xAbsValue);
                    noOfFractionDigits = xInBigDecimal.scaleByPowerOfTen(pow).scale();
                } else {
                    pow = ToExpString.calculatePowerForFloatGreaterThanOrEqualToOne(xAbsValue);
                    noOfFractionDigits = xInBigDecimal.scale() + pow;
                }
            }
        } else {
            noOfFractionDigits = (Long)fractionDigits;
        }
        if (noOfFractionDigits < 0L) {
            throw ErrorUtils.createInvalidFractionDigitsError();
        }
        if (FloatUtils.checkFractionDigitsWithinRange(noOfFractionDigits)) {
            noOfFractionDigits = 308L;
        }
        int exponent = (int)noOfFractionDigits;
        int tens = 0;
        if (xAbsValue != 0.0 && xAbsValue < 1.0) {
            tens = ToExpString.calculatePowerForFloatLessThanOne(xAbsValue);
        }
        BigDecimal numberBigDecimal = new BigDecimal(x);
        numberBigDecimal = xAbsValue != 0.0 && xAbsValue < 1.0 ? numberBigDecimal.setScale(exponent + tens, RoundingMode.HALF_EVEN) : numberBigDecimal.setScale(exponent, RoundingMode.HALF_EVEN);
        return ToExpString.getScientificNotation(numberBigDecimal, exponent);
    }

    public static int calculatePowerForFloatLessThanOne(double xAbsValue) {
        int pow2 = 0;
        while (xAbsValue < 1.0) {
            xAbsValue *= Math.pow(10.0, 1.0);
            ++pow2;
        }
        return pow2;
    }

    public static int calculatePowerForFloatGreaterThanOrEqualToOne(double xAbsValue) {
        int pow2 = 0;
        while (xAbsValue > 10.0) {
            xAbsValue /= Math.pow(10.0, 1.0);
            ++pow2;
        }
        return pow2;
    }

    public static BString getScientificNotation(BigDecimal numberBigDecimal, int exp2) {
        Object exponent;
        int p;
        int indexOfExp;
        String power = "0".repeat(exp2);
        DecimalFormat decimalFormat = new DecimalFormat("0." + power + "E0");
        String res = decimalFormat.format(numberBigDecimal).toLowerCase();
        String coefficient = res.substring(0, indexOfExp = res.lastIndexOf("e"));
        int idxOfDecimalPoint = coefficient.lastIndexOf(".");
        if (idxOfDecimalPoint == coefficient.length() - 1) {
            coefficient = res.substring(0, idxOfDecimalPoint);
        }
        exponent = (p = Integer.parseInt((String)(exponent = res.substring(indexOfExp + 1)))) >= 0 ? "e+" + (String)exponent : "e" + (String)exponent;
        String notation = coefficient + (String)exponent;
        return StringUtils.fromString(notation);
    }
}

