/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.internal;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.api.values.BXmlSequence;
import java.util.ArrayList;
import org.ballerinalang.langlib.internal.IsElement;

public final class GetElements {
    public static final String EMPTY = "";
    public static final String STAR = "*";

    private GetElements() {
    }

    public static BXml getElements(BXml xmlVal, BString[] elemNames) {
        ArrayList<String> nsList = new ArrayList<String>();
        ArrayList<String> localNameList = new ArrayList<String>();
        GetElements.destructureFilters(elemNames, nsList, localNameList);
        if (IsElement.isElement(xmlVal)) {
            if (GetElements.matchFilters(elemNames, nsList, localNameList, xmlVal.getElementName())) {
                return xmlVal;
            }
            return ValueCreator.createXmlSequence();
        }
        ArrayList<BXml> selectedElements = new ArrayList<BXml>();
        if (xmlVal.getNodeType() == XmlNodeType.SEQUENCE) {
            BXmlSequence sequence = (BXmlSequence)xmlVal;
            for (BXml child : sequence.getChildrenList()) {
                if (child.getNodeType() != XmlNodeType.ELEMENT || !GetElements.matchFilters(elemNames, nsList, localNameList, child.getElementName())) continue;
                selectedElements.add(child);
            }
        }
        return ValueCreator.createXmlSequence(selectedElements);
    }

    public static void destructureFilters(BString[] elemNames, ArrayList<String> nsList, ArrayList<String> localNameList) {
        for (BString elemName : elemNames) {
            String fullName = elemName.getValue();
            int lastIndexOf2 = fullName.lastIndexOf(125);
            if (lastIndexOf2 < 0) {
                nsList.add(EMPTY);
                localNameList.add(fullName);
                continue;
            }
            nsList.add(fullName.substring(1, lastIndexOf2));
            localNameList.add(fullName.substring(lastIndexOf2 + 1));
        }
    }

    public static boolean matchFilters(BString[] elemNames, ArrayList<String> nsList, ArrayList<String> elemList, String elementName) {
        int filterCount = elemNames.length;
        for (int i = 0; i < filterCount; ++i) {
            int index;
            String ns = nsList.get(i);
            String eName = elemList.get(i);
            if (ns.equals(EMPTY) && eName.equals(STAR)) {
                return true;
            }
            if (eName.equals(STAR) && (index = elementName.lastIndexOf(125)) > 0 && elementName.substring(1, index).equals(ns)) {
                return true;
            }
            if (!elementName.equals(elemNames[i].getValue())) continue;
            return true;
        }
        return false;
    }
}

