/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.java;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.errors.ErrorReasons;

public final class JavaUtils {
    private static final String booleanTypeName = "boolean";
    private static final String byteTypeName = "byte";
    private static final String shortTypeName = "short";
    private static final String charTypeName = "char";
    private static final String intTypeName = "int";
    private static final String longTypeName = "long";
    private static final String floatTypeName = "float";
    private static final String doubleTypeName = "double";
    private static final Module JAVA_PACKAGE_ID = new Module("ballerina", "java", "0.9.0");

    private JavaUtils() {
    }

    public static Object getClass(BString namebStr) {
        String name = namebStr.getValue();
        Class<?> clazz = JavaUtils.getPrimitiveTypeClass(name);
        if (clazz != null) {
            return ValueCreator.createHandleValue(clazz);
        }
        try {
            clazz = Class.forName(name);
            return ValueCreator.createHandleValue(clazz);
        }
        catch (ClassNotFoundException e2) {
            return ErrorCreator.createDistinctError(ErrorReasons.JAVA_CLASS_NOT_FOUND_ERROR, JAVA_PACKAGE_ID, StringUtils.fromString(name));
        }
    }

    private static Class<?> getPrimitiveTypeClass(String name) {
        return switch (name) {
            case booleanTypeName -> Boolean.TYPE;
            case byteTypeName -> Byte.TYPE;
            case shortTypeName -> Short.TYPE;
            case charTypeName -> Character.TYPE;
            case intTypeName -> Integer.TYPE;
            case longTypeName -> Long.TYPE;
            case floatTypeName -> Float.TYPE;
            case doubleTypeName -> Double.TYPE;
            default -> null;
        };
    }
}

