/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.map;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.utils.MapUtils;
import org.ballerinalang.langlib.map.util.MapLibUtils;

public final class Remove {
    private Remove() {
    }

    public static Object remove(BMap<?, ?> m, BString k) {
        Type type = TypeUtils.getImpliedType(m.getType());
        MapUtils.checkIsMapOnlyOperation(type, "remove()");
        MapLibUtils.validateRequiredFieldForRecord(m, k.getValue());
        if (m.containsKey(k)) {
            try {
                return m.remove(k);
            }
            catch (BError e2) {
                Object errorMsgDetail = "failed to remove element from map";
                if (ErrorHelper.hasMessageDetail(e2)) {
                    errorMsgDetail = (String)errorMsgDetail + ": " + ((BMap)e2.getDetails()).get(StringUtils.fromString("message")).toString();
                }
                throw ErrorCreator.createError(e2.getErrorMessage(), StringUtils.fromString((String)errorMsgDetail));
            }
        }
        throw ErrorCreator.createError(ErrorReasons.MAP_KEY_NOT_FOUND_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.KEY_NOT_FOUND_ERROR, k));
    }
}

