/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.runtime;

import io.ballerina.identifier.Utils;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import java.util.List;
import org.ballerinalang.langlib.runtime.Constants;

public final class GetStackTrace {
    private static final BString EMPTY_ERROR_MESSAGE = StringUtils.fromString("");

    private GetStackTrace() {
    }

    public static BArray getStackTrace() {
        List<StackTraceElement> filteredStack = ErrorCreator.createError(EMPTY_ERROR_MESSAGE).getCallStack();
        Type recordType = ValueCreator.createRecordValue(Constants.BALLERINA_RUNTIME_PKG_ID, "CallStackElement").getType();
        BArray callStack = ValueCreator.createArrayValue(TypeCreator.createArrayType(recordType));
        for (int i = 0; i < filteredStack.size(); ++i) {
            Object[] values = GetStackTrace.getStackFrame(filteredStack.get(i));
            BMap<BString, Object> createRecordValue = ValueCreator.createRecordValue(ValueCreator.createRecordValue(Constants.BALLERINA_RUNTIME_PKG_ID, "CallStackElement"), values);
            callStack.add((long)i, createRecordValue);
        }
        return callStack;
    }

    private static Object[] getStackFrame(StackTraceElement stackTraceElement) {
        String fileName;
        Object[] values = new Object[4];
        values[0] = stackTraceElement.getMethodName();
        values[2] = stackTraceElement.getFileName();
        values[3] = stackTraceElement.getLineNumber();
        String moduleName = Utils.decodeIdentifier(stackTraceElement.getClassName()).replace("$$$", ".");
        if (!moduleName.equals(fileName = stackTraceElement.getFileName().replace(".bal", ""))) {
            int index = moduleName.lastIndexOf("." + fileName);
            values[1] = index != -1 ? moduleName.substring(0, index) : moduleName;
        }
        return values;
    }
}

